@props(['tasks', 'scrollColor' => '#d4a65a'])

<div class="space-y-1">
    @foreach($tasks as $task)
        <div class="flex items-center gap-3 p-2 bg-papyrus-dark/30 hover:bg-papyrus-dark/50 rounded border border-ra-gold/20 transition-colors">
            <input type="checkbox" class="rounded border-ra-gold text-ra-gold flex-shrink-0">
            <a href="{{ route('tasks.show', $task) }}" class="flex-1 min-w-0 text-sm text-desert-sand hover:text-ra-gold truncate">
                {{ $task->title }}
            </a>
            <span class="text-nile-turquoise text-xs font-semibold flex-shrink-0">✨{{ $task->points }}</span>
            @if($task->category)
                <span class="px-1.5 py-0.5 text-xs rounded bg-papyrus-dark/50 text-desert-sand/70 border border-ra-gold/20 flex-shrink-0">
                    {{ Str::limit($task->category->name, 10) }}
                </span>
            @endif
            <span class="w-2 h-2 rounded-full flex-shrink-0
                {{ $task->status === 'completed' ? 'bg-green-500' : '' }}
                {{ $task->status === 'pending' ? 'bg-ra-gold' : '' }}
                {{ $task->status === 'skipped' ? 'bg-gray-500' : '' }}">
            </span>
        </div>
    @endforeach
</div>

