@props(['tasks', 'scrollColor' => '#d4a65a'])

@php
    $todoTasks = $tasks->where('status', 'pending');
    $inProgressTasks = $tasks->where('status', 'in_progress'); // If you add this status
    $doneTasks = $tasks->where('status', 'completed');
@endphp

<div class="grid grid-cols-1 md:grid-cols-3 gap-4" x-data="{ 
    draggedTask: null,
    dragOverColumn: null
}">
    <!-- To Do Column -->
    <div class="kanban-column bg-papyrus-dark/30 rounded-lg p-4 border-2 min-h-[400px]" 
         style="border-color: {{ $scrollColor }};"
         @dragover.prevent="dragOverColumn = 'todo'"
         @dragleave="dragOverColumn = null"
         @drop.prevent="dragOverColumn = null">
        <h3 class="font-egyptian text-lg text-ra-gold font-bold mb-4 pb-2 border-b border-ra-gold/30">
            To Do ({{ $todoTasks->count() }})
        </h3>
        <div class="space-y-3">
            @foreach($todoTasks as $task)
                <div class="kanban-card bg-[#fdf2d2] border border-ra-gold/30 rounded-lg p-3 cursor-move hover:shadow-md transition-all"
                     draggable="true"
                     @dragstart="draggedTask = {{ $task->id }}"
                     @dragend="draggedTask = null">
                    <h4 class="font-egyptian text-sm text-ra-gold font-semibold mb-2">{{ $task->title }}</h4>
                    @if($task->scrollCategory)
                        <span class="px-1.5 py-0.5 text-xs rounded bg-papyrus-dark/50 text-desert-sand/70 mb-2 inline-block">
                            {{ $task->scrollCategory->title }}
                        </span>
                    @endif
                    <div class="flex items-center gap-2 text-xs">
                        <span class="text-nile-turquoise">✨ {{ $task->points }}</span>
                        @if($task->coins > 0)
                            <span class="text-ra-gold">💰 {{ $task->coins }}</span>
                        @endif
                    </div>
                </div>
            @endforeach
        </div>
    </div>

    <!-- In Progress Column -->
    <div class="kanban-column bg-papyrus-dark/30 rounded-lg p-4 border-2 min-h-[400px]" 
         style="border-color: {{ $scrollColor }};"
         @dragover.prevent="dragOverColumn = 'in_progress'"
         @dragleave="dragOverColumn = null"
         @drop.prevent="dragOverColumn = null">
        <h3 class="font-egyptian text-lg text-nile-turquoise font-bold mb-4 pb-2 border-b border-nile-turquoise/30">
            In Progress ({{ $inProgressTasks->count() }})
        </h3>
        <div class="space-y-3">
            @foreach($inProgressTasks as $task)
                <div class="kanban-card bg-[#fdf2d2] border border-nile-turquoise/30 rounded-lg p-3 cursor-move hover:shadow-md transition-all"
                     draggable="true"
                     @dragstart="draggedTask = {{ $task->id }}"
                     @dragend="draggedTask = null">
                    <h4 class="font-egyptian text-sm text-nile-turquoise font-semibold mb-2">{{ $task->title }}</h4>
                    @if($task->scrollCategory)
                        <span class="px-1.5 py-0.5 text-xs rounded bg-papyrus-dark/50 text-desert-sand/70 mb-2 inline-block">
                            {{ $task->scrollCategory->title }}
                        </span>
                    @endif
                    <div class="flex items-center gap-2 text-xs">
                        <span class="text-nile-turquoise">✨ {{ $task->points }}</span>
                        @if($task->coins > 0)
                            <span class="text-ra-gold">💰 {{ $task->coins }}</span>
                        @endif
                    </div>
                </div>
            @endforeach
        </div>
    </div>

    <!-- Done Column -->
    <div class="kanban-column bg-papyrus-dark/30 rounded-lg p-4 border-2 min-h-[400px]" 
         style="border-color: {{ $scrollColor }};"
         @dragover.prevent="dragOverColumn = 'done'"
         @dragleave="dragOverColumn = null"
         @drop.prevent="dragOverColumn = null">
        <h3 class="font-egyptian text-lg text-green-400 font-bold mb-4 pb-2 border-b border-green-500/30">
            Done ({{ $doneTasks->count() }})
        </h3>
        <div class="space-y-3">
            @foreach($doneTasks as $task)
                <div class="kanban-card bg-green-900/20 border border-green-500/30 rounded-lg p-3 opacity-75">
                    <h4 class="font-egyptian text-sm text-green-300 font-semibold mb-2 line-through">{{ $task->title }}</h4>
                    @if($task->scrollCategory)
                        <span class="px-1.5 py-0.5 text-xs rounded bg-papyrus-dark/50 text-desert-sand/70 mb-2 inline-block">
                            {{ $task->scrollCategory->title }}
                        </span>
                    @endif
                    <div class="flex items-center gap-2 text-xs text-green-300">
                        <span>✨ {{ $task->points }}</span>
                        @if($task->coins > 0)
                            <span>💰 {{ $task->coins }}</span>
                        @endif
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</div>

