@props(['tasks', 'scrollColor' => '#d4a65a'])

<div class="space-y-2">
    @foreach($tasks as $task)
        <a href="{{ route('tasks.show', $task) }}" 
           class="block bg-papyrus-dark/50 hover:bg-papyrus-dark border border-ra-gold/30 rounded-lg p-4 transition-all duration-300 hover:border-ra-gold">
            <div class="flex items-center justify-between">
                <div class="flex-1 min-w-0">
                    <h4 class="font-egyptian text-ra-gold font-semibold truncate">{{ $task->title }}</h4>
                    <div class="flex items-center gap-4 mt-2 text-sm">
                        <div class="flex items-center gap-1">
                            <span class="text-nile-turquoise">✨</span>
                            <span class="text-desert-sand">{{ $task->points }}</span>
                        </div>
                        @if($task->coins > 0)
                        <div class="flex items-center gap-1">
                            <span class="text-ra-gold">💰</span>
                            <span class="text-desert-sand">{{ $task->coins }}</span>
                        </div>
                        @endif
                        @if($task->category)
                        <span class="text-desert-sand/70 text-xs">📜 {{ $task->category->name }}</span>
                        @endif
                    </div>
                </div>
                <div class="flex items-center gap-3 ml-4">
                    <span class="px-2 py-1 text-xs rounded border capitalize
                        {{ $task->status === 'completed' ? 'bg-green-900/30 border-green-500 text-green-300' : '' }}
                        {{ $task->status === 'pending' ? 'bg-ra-gold/20 border-ra-gold text-ra-gold' : '' }}
                        {{ $task->status === 'skipped' ? 'bg-gray-700/30 border-gray-500 text-gray-300' : '' }}">
                        {{ $task->status }}
                    </span>
                    <span class="text-desert-sand/50">›</span>
                </div>
            </div>
        </a>
    @endforeach
</div>

