@props(['tasks', 'scrollColor' => '#d4a65a'])

<div class="overflow-x-auto">
    <table class="w-full">
        <thead>
            <tr class="border-b-2" style="border-color: {{ $scrollColor }};">
                <th class="text-left py-3 px-4 text-desert-sand font-egyptian font-semibold">
                    <input type="checkbox" class="rounded border-ra-gold text-ra-gold">
                </th>
                <th class="text-left py-3 px-4 text-desert-sand font-egyptian font-semibold">Title</th>
                <th class="text-left py-3 px-4 text-desert-sand font-egyptian font-semibold">Category</th>
                <th class="text-left py-3 px-4 text-desert-sand font-egyptian font-semibold">XP</th>
                <th class="text-left py-3 px-4 text-desert-sand font-egyptian font-semibold">Coins</th>
                <th class="text-left py-3 px-4 text-desert-sand font-egyptian font-semibold">Difficulty</th>
                <th class="text-left py-3 px-4 text-desert-sand font-egyptian font-semibold">Deadline</th>
                <th class="text-left py-3 px-4 text-desert-sand font-egyptian font-semibold">Status</th>
                <th class="text-left py-3 px-4 text-desert-sand font-egyptian font-semibold">Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($tasks as $task)
                <tr class="border-b border-ra-gold/20 hover:bg-papyrus-dark/30 transition-colors">
                    <td class="py-3 px-4">
                        <input type="checkbox" class="rounded border-ra-gold text-ra-gold">
                    </td>
                    <td class="py-3 px-4">
                        <a href="{{ route('tasks.show', $task) }}" class="text-ra-gold hover:text-yellow-400 font-egyptian font-semibold">
                            {{ $task->title }}
                        </a>
                    </td>
                    <td class="py-3 px-4 text-desert-sand text-sm">
                        {{ $task->category->name ?? '-' }}
                    </td>
                    <td class="py-3 px-4">
                        <span class="text-nile-turquoise font-semibold">✨ {{ $task->points }}</span>
                    </td>
                    <td class="py-3 px-4">
                        @if($task->coins > 0)
                            <span class="text-ra-gold font-semibold">💰 {{ $task->coins }}</span>
                        @else
                            <span class="text-desert-sand/50">-</span>
                        @endif
                    </td>
                    <td class="py-3 px-4">
                        @if($task->difficulty_level)
                            <span class="text-desert-sand capitalize text-sm">⚔️ {{ $task->difficulty_level }}</span>
                        @else
                            <span class="text-desert-sand/50">-</span>
                        @endif
                    </td>
                    <td class="py-3 px-4 text-desert-sand text-sm">
                        @if($task->due_date)
                            {{ $task->due_date->format('M d, Y') }}
                        @else
                            <span class="text-desert-sand/50">-</span>
                        @endif
                    </td>
                    <td class="py-3 px-4">
                        <span class="px-2 py-1 text-xs rounded border capitalize
                            {{ $task->status === 'completed' ? 'bg-green-900/30 border-green-500 text-green-300' : '' }}
                            {{ $task->status === 'pending' ? 'bg-ra-gold/20 border-ra-gold text-ra-gold' : '' }}
                            {{ $task->status === 'skipped' ? 'bg-gray-700/30 border-gray-500 text-gray-300' : '' }}">
                            {{ $task->status }}
                        </span>
                    </td>
                    <td class="py-3 px-4">
                        <div class="flex gap-2">
                            <a href="{{ route('tasks.show', $task) }}" class="text-nile-turquoise hover:text-nile-turquoise/70 text-sm">View</a>
                            @if($task->status !== 'completed')
                            <form method="POST" action="{{ route('tasks.complete', $task) }}" class="inline">
                                @csrf
                                <button type="submit" class="text-ra-gold hover:text-yellow-400 text-sm">Complete</button>
                            </form>
                            @endif
                        </div>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>

