@props(['progress', 'current', 'next', 'level'])

<div class="mb-6">
    <div class="flex justify-between text-sm text-desert-sand mb-2">
        <span>✨ Divine Energy: {{ $current }} / {{ $next }}</span>
        <span class="text-ra-gold">Next Rank: {{ $level + 1 }}</span>
    </div>
    <div class="relative w-full bg-shadow-ink rounded-full h-6 border-2 border-ra-gold/30 overflow-hidden">
        <div class="h-full bg-gradient-to-r from-ra-gold via-yellow-400 to-ra-gold rounded-full transition-all duration-500 flex items-center justify-center shadow-gold-glow" 
             style="width: {{ min(100, max(0, $progress)) }}%; clip-path: polygon(0 0, 100% 0, calc(100% - 8px) 50%, 100% 100%, 0 100%);">
            @if($progress > 10)
            <span class="text-xs font-stat text-papyrus-dark font-bold">{{ round($progress) }}%</span>
            @endif
        </div>
    </div>
</div>

