@php
use Illuminate\Support\Facades\Storage;
@endphp
<x-app-layout>
    <div x-data="egyptianAnimations()"></div>
    <x-slot name="header">
        <div class="flex items-center gap-3">
            <span class="text-4xl">🏺</span>
            <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold leading-tight">
                Temple of Tasks
            </h2>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <!-- Three Column Layout -->
            <div class="grid grid-cols-1 lg:grid-cols-12 gap-6">
                
                <!-- Main Content - Scroll Parchment -->
                <div class="lg:col-span-8 space-y-6">
                    @if(session('success'))
                        <div class="quest-card bg-gradient-to-r from-ra-gold/20 to-nile-turquoise/20 border-nile-turquoise" role="alert">
                            <span class="block text-desert-sand font-egyptian">{{ session('success') }}</span>
                            @if(session('level_up'))
                            <div class="mt-2 text-ra-gold font-egyptian animate-gold-pulse" 
                                 x-data 
                                 x-init="setTimeout(() => window.dispatchEvent(new CustomEvent('level-up')), 500)">
                                👁️ Ra has blessed you — Level Up to {{ session('new_level') }}!
                            </div>
                            @endif
                        </div>
                    @endif

                    <!-- User Stats Card - Parchment Scroll -->
                    <div class="quest-card">
                        <div class="flex items-center justify-between mb-4">
                            <div class="flex items-center gap-4">
                                @if($user->character)
                                    <div class="w-16 h-16">
                                        <x-character-animation 
                                            :character="$user->character" 
                                            state="idle" 
                                            class="w-16 h-16 rounded-lg border-2 border-ra-gold"
                                        />
                                    </div>
                                    <h3 class="font-egyptian text-2xl text-ra-gold text-shadow-gold">{{ $user->name }}</h3>
                                    <span class="text-sm text-desert-sand">({{ $user->character->name }})</span>
                                @else
                                    <h3 class="font-egyptian text-2xl text-ra-gold text-shadow-gold">{{ $user->name }}</h3>
                                @endif
                            </div>
                            <div class="text-center px-4 py-2 bg-ra-gold/20 border border-ra-gold rounded-lg">
                                <span class="font-stat text-2xl text-ra-gold">Rank {{ $user->level }}</span>
                            </div>
                        </div>
                        
                        <!-- XP Progress Bar - Sun Ray Shape -->
                        <div class="mb-6">
                            <div class="flex justify-between text-sm text-desert-sand mb-2">
                                <span>✨ Divine Energy: {{ $xpInCurrentLevel }} / {{ $xpNeededForNextLevel }}</span>
                                <span class="text-ra-gold">Next Rank: {{ $user->level + 1 }}</span>
                            </div>
                            <div class="relative w-full bg-shadow-ink rounded-full h-6 border-2 border-ra-gold/30 overflow-hidden">
                                <div class="h-full bg-gradient-to-r from-ra-gold via-yellow-400 to-ra-gold rounded-full transition-all duration-500 flex items-center justify-center shadow-gold-glow" 
                                     style="width: {{ min(100, max(0, $xpProgress)) }}%; clip-path: polygon(0 0, 100% 0, calc(100% - 8px) 50%, 100% 100%, 0 100%);">
                                    @if($xpProgress > 10)
                                    <span class="text-xs font-stat text-papyrus-dark font-bold">{{ round($xpProgress) }}%</span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <!-- Sacred Gold and Stats -->
                        <div class="grid grid-cols-2 md:grid-cols-5 gap-4">
                            <div class="text-center p-4 bg-ra-gold/10 border border-ra-gold rounded-lg">
                                <div class="text-3xl mb-1">💰</div>
                                <div class="font-stat text-2xl text-ra-gold">{{ number_format($user->gold) }}</div>
                                <div class="text-xs text-desert-sand">Sacred Gold</div>
                            </div>
                            <div class="text-center p-4 bg-nile-turquoise/10 border border-nile-turquoise rounded-lg">
                                <div class="text-3xl mb-1">💎</div>
                                <div class="font-stat text-2xl text-nile-turquoise">{{ number_format($user->premium_coins) }}</div>
                                <div class="text-xs text-desert-sand">Premium Coins</div>
                            </div>
                            <div class="text-center p-4 bg-blood-red/10 border border-blood-red/50 rounded-lg">
                                <div class="text-3xl mb-1">⚔️</div>
                                <div class="font-stat text-2xl text-blood-red">{{ $totalStats['attack'] }}</div>
                                <div class="text-xs text-desert-sand">Strength</div>
                            </div>
                            <div class="text-center p-4 bg-nile-turquoise/10 border border-nile-turquoise/50 rounded-lg">
                                <div class="text-3xl mb-1">🛡️</div>
                                <div class="font-stat text-2xl text-nile-turquoise">{{ $totalStats['defense'] }}</div>
                                <div class="text-xs text-desert-sand">Resilience</div>
                            </div>
                            <div class="text-center p-4 bg-purple-600/20 border border-purple-400/50 rounded-lg">
                                <div class="text-3xl mb-1">❤️</div>
                                <div class="font-stat text-2xl text-purple-300">{{ $totalStats['stamina'] }}</div>
                                <div class="text-xs text-desert-sand">Endurance</div>
                            </div>
                        </div>
                    </div>

                    <!-- Quick Actions -->
                    <div class="quest-card">
                        <h3 class="font-egyptian text-xl text-ra-gold mb-4">Quick Actions</h3>
                        <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                            <a href="{{ route('tasks.create') }}" class="bg-nile-turquoise/20 hover:bg-nile-turquoise/30 border-2 border-nile-turquoise text-nile-turquoise font-bold py-3 px-4 rounded-lg text-center transition-all duration-300 hover:shadow-turquoise-glow">
                                🗺️ New Quest
                            </a>
                            <a href="{{ route('categories.create') }}" class="bg-ra-gold/20 hover:bg-ra-gold/30 border-2 border-ra-gold text-ra-gold font-bold py-3 px-4 rounded-lg text-center transition-all duration-300 hover:shadow-gold-glow">
                                📜 New Scroll
                            </a>
                            <a href="{{ route('shop.index') }}" class="bg-yellow-600/20 hover:bg-yellow-600/30 border-2 border-yellow-600 text-yellow-400 font-bold py-3 px-4 rounded-lg text-center transition-all duration-300">
                                💰 Market
                            </a>
                            <a href="{{ route('battle.index') }}" class="bg-blood-red/20 hover:bg-blood-red/30 border-2 border-blood-red text-blood-red font-bold py-3 px-4 rounded-lg text-center transition-all duration-300">
                                ⚔️ Arena
                            </a>
                        </div>
                    </div>

                    <!-- Recent Completed Quests -->
                    @if($recentTasks->count() > 0)
                    <div class="quest-card">
                        <h3 class="font-egyptian text-xl text-ra-gold mb-4">Recent Blessings</h3>
                        <div class="space-y-2">
                            @foreach($recentTasks as $task)
                            <div class="flex justify-between items-center p-3 bg-papyrus-dark/50 rounded-lg border border-ra-gold/20 hover:border-ra-gold transition-all duration-300">
                                <div class="flex items-center gap-3">
                                    <span class="text-2xl">✨</span>
                                <span class="text-desert-sand">{{ $task->title }}</span>
                                </div>
                                <span class="text-sm text-nile-turquoise">{{ $task->completed_at->diffForHumans() }}</span>
                            </div>
                            @endforeach
                        </div>
                    </div>
                    @endif
                </div>

                <!-- Right Sidebar - Power of Ra Panel -->
                <div class="lg:col-span-4 space-y-6">
                    <!-- Power of Ra Card -->
                    <div class="quest-card border-nile-turquoise">
                        <h3 class="font-egyptian text-xl text-nile-turquoise text-shadow-turquoise mb-4 flex items-center gap-2">
                            <span class="text-3xl">👁️</span>
                            <span>Power of Ra</span>
                        </h3>
                        
                        <div class="space-y-4">
                            <!-- Level Display -->
                            <div class="text-center p-4 bg-gradient-to-br from-ra-gold/20 to-yellow-600/20 border-2 border-ra-gold rounded-lg">
                                <div class="font-stat text-4xl text-ra-gold mb-1">{{ $user->level }}</div>
                                <div class="text-xs text-desert-sand">Rank</div>
                            </div>

                            <!-- Gold Display -->
                            <div class="p-3 bg-ra-gold/10 border border-ra-gold rounded-lg flex items-center justify-between">
                                <span class="text-desert-sand">Sacred Gold:</span>
                                <span class="font-stat text-ra-gold">{{ number_format($user->gold) }}</span>
                            </div>

                            <!-- Premium Coins Display -->
                            <div class="p-3 bg-nile-turquoise/10 border border-nile-turquoise rounded-lg flex items-center justify-between">
                                <span class="text-desert-sand">💎 Premium Coins:</span>
                                <span class="font-stat text-nile-turquoise">{{ number_format($user->premium_coins) }}</span>
                            </div>

                            <!-- VIP Status Panel -->
                            @if($user->isVip())
                                @php
                                    $membership = $user->membership;
                                    $daysUntilExpiry = now()->diffInDays($user->vip_expires_at, false);
                                @endphp
                                <div class="p-4 bg-gradient-to-br from-ra-gold/30 to-yellow-600/20 border-2 border-ra-gold rounded-lg">
                                    <div class="flex items-center justify-between mb-2">
                                        <span class="font-egyptian text-ra-gold text-lg">👑 VIP Status</span>
                                        <span class="bg-ra-gold text-papyrus-dark text-xs font-bold px-2 py-1 rounded-full">ACTIVE</span>
                                    </div>
                                    @if($membership)
                                        <div class="text-xs text-desert-sand mb-2">
                                            <div>{{ $membership->name }}</div>
                                            <div class="mt-1">
                                                <span class="text-nile-turquoise">+{{ $membership->xp_bonus_percent }}% XP</span> | 
                                                <span class="text-nile-turquoise">+{{ $membership->gold_bonus_percent }}% Gold</span>
                                            </div>
                                        </div>
                                    @endif
                                    @if($user->vip_expires_at)
                                        <div class="text-xs text-desert-sand">
                                            Expires: {{ $user->vip_expires_at->format('M d, Y') }}
                                            @if($daysUntilExpiry <= 7 && $daysUntilExpiry >= 0)
                                                <span class="text-blood-red block mt-1">⚠️ {{ $daysUntilExpiry }} day{{ $daysUntilExpiry !== 1 ? 's' : '' }} remaining</span>
                                            @endif
                                        </div>
                                    @endif
                                    @php
                                        $canClaimDaily = !$user->last_vip_reward_claimed_at || !$user->last_vip_reward_claimed_at->isToday();
                                    @endphp
                                    @if($canClaimDaily)
                                        <form method="POST" action="{{ route('rewards.daily-vip') }}" class="mt-3">
                                            @csrf
                                            <button type="submit" class="w-full cartouche-button text-sm py-2">
                                                🎁 Claim Daily Blessing
                                            </button>
                                        </form>
                                    @else
                                        <div class="mt-3 text-xs text-desert-sand/70 text-center">
                                            Daily blessing already claimed today
                                        </div>
                                    @endif
                                </div>
                            @else
                                <div class="p-4 bg-papyrus-dark/50 border border-ra-gold/30 rounded-lg text-center space-y-2">
                                    <div class="text-desert-sand text-sm mb-2">Become VIP for exclusive benefits!</div>
                                    <a href="{{ route('membership.plans') }}" class="cartouche-button text-sm py-2 inline-block w-full">
                                        👑 Upgrade to VIP (PayPal)
                                    </a>
                                </div>
                            @endif

                            <!-- Buy Premium Coins Button -->
                            <div class="p-4 bg-nile-turquoise/10 border border-nile-turquoise rounded-lg text-center">
                                <a href="{{ route('coins.index') }}" class="cartouche-button text-sm py-2 inline-block w-full">
                                    💎 Buy Premium Coins (PayPal)
                                </a>
                            </div>

                            <!-- Equipped Items - Floating Relics -->
                            <div>
                                <h4 class="text-desert-sand mb-2 text-sm font-semibold">Blessed Relics</h4>
                                @php
                                    $equippedItems = $user->userItems()->where('equipped', true)->with('item')->get();
                                @endphp
                                @if($equippedItems->count() > 0)
                                <div class="space-y-2">
                                    @foreach($equippedItems as $userItem)
                                    <div class="flex items-center gap-2 p-2 bg-papyrus-dark/50 border border-ra-gold/30 rounded">
                                        <span class="text-xl">{{ $userItem->item->type === 'weapon' ? '⚔️' : ($userItem->item->type === 'armor' ? '🛡️' : ($userItem->item->type === 'potion' ? '🧪' : '🔧')) }}</span>
                                        <span class="text-xs text-desert-sand">{{ $userItem->item->name }}</span>
                                    </div>
                                    @endforeach
                                </div>
                                @else
                                <p class="text-xs text-desert-sand/70 italic">No relics equipped</p>
                                @endif
                            </div>
                        </div>
                    </div>

                    <!-- Blessings Meter - Daily Quest Streak -->
                    <div class="quest-card border-nile-turquoise">
                        <h3 class="font-egyptian text-lg text-nile-turquoise text-shadow-turquoise mb-4 flex items-center gap-2">
                            <span class="text-2xl">👁️</span>
                            <span>Blessings of Ra</span>
                        </h3>
                        
                        <div class="text-center mb-4">
                            <div class="font-stat text-4xl text-ra-gold mb-1">{{ $streakData['streak'] }}</div>
                            <div class="text-xs text-desert-sand">Day Streak</div>
                        </div>
                        
                        @if($streakData['bonus_percent'] > 0)
                        <div class="bg-gradient-to-r from-ra-gold/20 to-yellow-600/20 border-2 border-ra-gold rounded-lg p-3 mb-3">
                            <div class="flex justify-between items-center">
                                <span class="text-desert-sand text-sm font-semibold">Blessing Bonus:</span>
                                <span class="font-stat text-ra-gold text-lg">+{{ $streakData['bonus_percent'] }}%</span>
                            </div>
                            <div class="text-xs text-desert-sand/70 mt-1">
                                All daily quest rewards increased!
                            </div>
                        </div>
                        @else
                        <div class="bg-papyrus-dark/50 border border-ra-gold/30 rounded-lg p-3 mb-3 text-center">
                            <div class="text-xs text-desert-sand/70">
                                Complete a daily quest to start your streak!
                            </div>
                        </div>
                        @endif
                        
                        <!-- Visual Streak Indicator -->
                        <div class="mt-4">
                            <div class="flex gap-1 justify-center">
                                @for($i = 0; $i < min(7, $streakData['streak']); $i++)
                                <div class="w-2 h-8 bg-gradient-to-t from-ra-gold to-yellow-400 rounded border border-ra-gold shadow-gold-glow"></div>
                                @endfor
                                @for($i = min(7, $streakData['streak']); $i < 7; $i++)
                                <div class="w-2 h-8 bg-shadow-ink border border-ra-gold/20 rounded"></div>
                                @endfor
                            </div>
                            <div class="text-xs text-desert-sand/70 text-center mt-2">
                                @if($streakData['streak'] >= 7)
                                <span class="text-ra-gold font-semibold">Maximum Blessing!</span>
                                @else
                                {{ 7 - min(7, $streakData['streak']) }} more days for full blessing
                                @endif
                            </div>
                        </div>
                    </div>

                    <!-- Daily Stats -->
                    <div class="quest-card">
                        <h3 class="font-egyptian text-lg text-ra-gold mb-4">Today's Progress</h3>
                        <div class="space-y-3">
                            <div class="flex justify-between items-center p-2 bg-green-900/20 border border-green-500/30 rounded">
                                <span class="text-desert-sand text-sm">Today</span>
                                <span class="font-stat text-green-400">{{ $tasksCompletedToday }}</span>
                            </div>
                            <div class="flex justify-between items-center p-2 bg-blue-900/20 border border-blue-500/30 rounded">
                                <span class="text-desert-sand text-sm">This Week</span>
                                <span class="font-stat text-blue-400">{{ $tasksCompletedThisWeek }}</span>
                            </div>
                            <div class="flex justify-between items-center p-2 bg-purple-900/20 border border-purple-500/30 rounded">
                                <span class="text-desert-sand text-sm">This Month</span>
                                <span class="font-stat text-purple-400">{{ $tasksCompletedThisMonth }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Achievements -->
            @if($achievements->count() > 0)
            <div class="quest-card mt-6">
                <h3 class="font-egyptian text-2xl text-ra-gold mb-6 text-center">Blessings of the Gods</h3>
                <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                    @foreach($achievements as $achievement)
                    <div class="text-center p-4 bg-gradient-to-br from-ra-gold/10 to-yellow-600/10 border-2 border-ra-gold rounded-xl hover:shadow-gold-glow transition-all duration-300">
                        <div class="text-5xl mb-2">{{ $achievement->icon }}</div>
                        <div class="font-egyptian font-semibold text-ra-gold text-sm mb-1">{{ $achievement->name }}</div>
                        <div class="text-xs text-desert-sand">{{ $achievement->description }}</div>
                    </div>
                    @endforeach
                </div>
            </div>
            @endif

            <!-- Leaderboard -->
            @if($leaderboard->count() > 0)
            <div class="quest-card mt-6">
                <h3 class="font-egyptian text-2xl text-ra-gold mb-4 text-center">Champions of Ra</h3>
                <div class="space-y-2">
                    @foreach($leaderboard as $index => $leader)
                    <div class="flex justify-between items-center p-3 bg-papyrus-dark/50 rounded-lg border border-ra-gold/20 hover:border-ra-gold transition-all duration-300">
                        <div class="flex items-center gap-3">
                            <span class="font-egyptian text-ra-gold w-8">#{{ $index + 1 }}</span>
                            <span class="text-desert-sand">{{ $leader->name }}</span>
                            @if($leader->id === $user->id)
                            <span class="text-xs text-ra-gold">(You)</span>
                            @endif
                        </div>
                        <div class="flex gap-4 text-sm">
                            <span class="font-stat text-nile-turquoise">Rank {{ $leader->level }}</span>
                            <span class="text-desert-sand">{{ number_format($leader->xp) }} ✨</span>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
            @endif
        </div>
    </div>
</x-app-layout>
