{{-- Example: Character Animation Usage --}}

{{-- Basic Usage --}}
<x-character-animation 
    :character="$character" 
    state="idle" 
    class="w-64 h-64"
/>

{{-- With Custom Fallback --}}
<x-character-animation 
    :character="$character" 
    state="attack" 
    class="w-64 h-64"
    :fallbackImage="$character->image_normal"
/>

{{-- In Battle View --}}
<div class="battle-container flex items-center justify-between">
    {{-- Player Character --}}
    <div class="player-character">
        <x-character-animation 
            :character="$user->character" 
            state="idle" 
            class="w-96 h-96"
            x-ref="playerCharacter"
        />
    </div>
    
    {{-- Enemy Character --}}
    <div class="enemy-character">
        <x-character-animation 
            :character="$enemy" 
            state="idle" 
            class="w-96 h-96"
            x-ref="enemyCharacter"
        />
    </div>
</div>

{{-- JavaScript to Control Animations --}}
<script>
document.addEventListener('DOMContentLoaded', () => {
    // Get video elements
    const playerVideo = document.querySelector('[x-ref="playerCharacter"] video');
    const enemyVideo = document.querySelector('[x-ref="enemyCharacter"] video');
    
    // Create animators
    const playerAnimator = new CharacterAnimator('{{ $user->character->slug }}', playerVideo);
    const enemyAnimator = new CharacterAnimator('{{ $enemy->slug }}', enemyVideo);
    
    // Attack button
    document.getElementById('attack-btn')?.addEventListener('click', () => {
        playerAnimator.playAttack();
        // Enemy reacts after a delay
        setTimeout(() => {
            enemyAnimator.playLose();
        }, 500);
    });
    
    // Magic button
    document.getElementById('magic-btn')?.addEventListener('click', () => {
        playerAnimator.playMagic();
    });
    
    // Listen for battle events
    window.addEventListener('battle-won', () => {
        playerAnimator.playWin();
        enemyAnimator.playLose();
    });
    
    window.addEventListener('battle-lost', () => {
        playerAnimator.playLose();
        enemyAnimator.playWin();
    });
});
</script>

{{-- Using Alpine.js with Component --}}
<div 
    x-data="{
        characterState: 'idle',
        changeState(state) {
            this.characterState = state;
            window.dispatchEvent(new CustomEvent('character-animation-state-change', {
                detail: {
                    characterSlug: '{{ $character->slug }}',
                    state: state
                }
            }));
        }
    }"
>
    <x-character-animation 
        :character="$character" 
        x-bind:state="characterState" 
        class="w-64 h-64"
    />
    
    <div class="controls mt-4">
        <button @click="changeState('idle')" class="btn">Idle</button>
        <button @click="changeState('attack')" class="btn">Attack</button>
        <button @click="changeState('win')" class="btn">Win</button>
        <button @click="changeState('lose')" class="btn">Lose</button>
    </div>
</div>

