<x-app-layout>
    <x-slot name="header">
        <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold flex items-center gap-3">
            <span class="text-4xl">🧿</span>
            <span>Blessings of the Gods</span>
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            @if(session('success'))
                <div class="quest-card bg-gradient-to-r from-ra-gold/20 to-nile-turquoise/20 border-nile-turquoise mb-4">
                    <span class="block text-desert-sand font-egyptian">{{ session('success') }}</span>
                </div>
            @endif

            @php
                $types = ['weapon' => '⚔️', 'armor' => '🛡️', 'potion' => '🧪', 'tool' => '🔧'];
                $typeNames = ['weapon' => 'Weapons', 'armor' => 'Armor', 'potion' => 'Potions', 'tool' => 'Tools'];
                $egyptianNames = ['weapon' => 'Weapons of War', 'armor' => 'Protection', 'potion' => 'Elixirs', 'tool' => 'Artifacts'];
            @endphp

            @foreach(['weapon', 'armor', 'potion', 'tool'] as $type)
                @if($userItems->has($type))
                <div class="mb-8">
                    <h3 class="font-egyptian text-2xl text-ra-gold mb-4 flex items-center gap-2">
                        <span class="text-3xl">{{ $types[$type] }}</span>
                        <span>{{ $egyptianNames[$type] }}</span>
                    </h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                        @foreach($userItems[$type] as $userItem)
                        <div class="quest-card {{ $userItem->equipped ? 'ring-4 ring-ra-gold shadow-gold-glow-lg' : '' }} hover:scale-105 transition-all duration-300">
                            @if($userItem->item->image_url)
                            <img src="{{ $userItem->item->image_url }}" alt="{{ $userItem->item->name }}" class="w-full h-32 object-cover rounded-lg border-2 border-ra-gold mb-3">
                            @else
                            <div class="w-full h-32 bg-gradient-to-br from-shadow-ink to-papyrus-dark border-2 border-ra-gold rounded-lg mb-3 flex items-center justify-center">
                                <span class="text-5xl">{{ $types[$type] }}</span>
                            </div>
                            @endif

                            <div class="p-2">
                                <div class="flex justify-between items-start mb-2">
                                    <h4 class="font-egyptian text-ra-gold font-semibold">{{ $userItem->item->name }}</h4>
                                    @if($userItem->equipped)
                                    <span class="bg-ra-gold text-papyrus-dark text-xs px-2 py-1 rounded-full font-bold">Blessed</span>
                                    @endif
                                </div>

                                <div class="text-xs space-y-1 mb-4 text-desert-sand">
                                    @if($userItem->item->attack > 0)
                                    <div class="flex items-center gap-1">
                                        <span>⚔️</span>
                                        <span>Strength: <span class="font-stat text-blood-red">+{{ $userItem->item->attack }}</span></span>
                                    </div>
                                    @endif
                                    @if($userItem->item->defense > 0)
                                    <div class="flex items-center gap-1">
                                        <span>🛡️</span>
                                        <span>Resilience: <span class="font-stat text-nile-turquoise">+{{ $userItem->item->defense }}</span></span>
                                    </div>
                                    @endif
                                    @if($userItem->item->magic > 0)
                                    <div class="flex items-center gap-1">
                                        <span>✨</span>
                                        <span>Wisdom: <span class="font-stat text-purple-300">+{{ $userItem->item->magic }}</span></span>
                                    </div>
                                    @endif
                                    @if($userItem->item->stamina > 0)
                                    <div class="flex items-center gap-1">
                                        <span>❤️</span>
                                        <span>Endurance: <span class="font-stat text-pink-300">+{{ $userItem->item->stamina }}</span></span>
                                    </div>
                                    @endif
                                </div>

                                @if($userItem->equipped)
                                <form method="POST" action="{{ route('inventory.unequip', $userItem) }}">
                                    @csrf
                                    <button type="submit" class="w-full bg-shadow-ink hover:bg-papyrus-dark border-2 border-ra-gold/50 text-desert-sand font-bold py-2 px-4 rounded-lg transition-all duration-300">
                                        Remove Blessing
                                    </button>
                                </form>
                                @else
                                <form method="POST" action="{{ route('inventory.equip', $userItem) }}">
                                    @csrf
                                    <button type="submit" class="w-full cartouche-button">
                                        Bless with Relic
                                    </button>
                                </form>
                                @endif
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
                @endif
            @endforeach

            @if($userItems->isEmpty())
            <div class="quest-card text-center py-12">
                <div class="text-6xl mb-4">🧿</div>
                <p class="text-desert-sand mb-4 font-egyptian">You have no blessed relics yet.</p>
                <a href="{{ route('shop.index') }}" class="cartouche-button inline-block">
                    Visit the Market of the Gods
                </a>
            </div>
            @endif
        </div>
    </div>
</x-app-layout>
