<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>Quest of Ra - {{ config('app.name', 'Laravel') }}</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Cinzel+Decorative:wght@400;700&family=Noto+Serif:wght@400;600;700&family=Orbitron:wght@400;600;700&display=swap" rel="stylesheet">
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Scripts -->
        @vite(['resources/css/app.css', 'resources/js/app.js'])
        @stack('head')
    </head>
    <body class="font-sans antialiased" style="background: linear-gradient(to bottom, #1a0e0a, #2d1b0f);">
        <div class="min-h-screen bg-papyrus-dark relative flex">
            <!-- Hieroglyph Pattern Overlay -->
            <div class="fixed inset-0 opacity-5 pointer-events-none" style="background-image: url('data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTAwIiBoZWlnaHQ9IjEwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48cmVjdCB3aWR0aD0iMTAwIiBoZWlnaHQ9IjEwMCIgZmlsbD0iIzFhMGUwYSIvPjxwYXRoIGQ9Ik0yMCAyMGgxMHYxMEgyMHoiIGZpbGw9IiNkNGFmMzciLz48cGF0aCBkPSJNNzAgNzBoMTB2MTBINzB6IiBmaWxsPSIjZGZhZjM3Ii8+PC9zdmc+'); background-repeat: repeat;"></div>
            
            @include('layouts.navigation')

            <!-- Main Content Area -->
            <div class="flex-1 flex flex-col min-w-0">
                <!-- Top Bar (for logo and user menu on mobile/desktop) -->
                <header class="bg-gradient-to-r from-papyrus-dark via-shadow-ink to-papyrus-dark border-b-2 border-ra-gold shadow-gold-glow">
                    <div class="px-4 sm:px-6 lg:px-8 py-4">
                        <div class="flex justify-between items-center">
                            <!-- Logo -->
                            <div class="flex items-center gap-3">
                                <a href="{{ route('dashboard') }}" class="flex items-center gap-2">
                                    <span class="text-4xl">👁️</span>
                                    <span class="font-egyptian text-ra-gold text-2xl text-shadow-gold">Quest of Ra</span>
                                </a>
                            </div>

                            <!-- User Menu (Desktop) -->
                            @auth
                            <div class="hidden lg:flex items-center">
                                <x-dropdown align="right" width="48">
                                    <x-slot name="trigger">
                                        <button class="inline-flex items-center px-4 py-2 border-2 border-ra-gold/30 rounded-lg text-sm leading-4 font-medium bg-papyrus-dark text-desert-sand hover:bg-ra-gold/10 hover:border-ra-gold focus:outline-none transition ease-in-out duration-150">
                                            <div class="font-egyptian">{{ Auth::user()->name }}</div>
                                            <div class="ms-2">
                                                <svg class="fill-current h-4 w-4 text-ra-gold" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                                                    <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                                                </svg>
                                            </div>
                                        </button>
                                    </x-slot>

                                    <x-slot name="content">
                                        <x-dropdown-link :href="route('profile.edit')">
                                            {{ __('Profile') }}
                                        </x-dropdown-link>

                                        <form method="POST" action="{{ route('logout') }}">
                                            @csrf
                                            <x-dropdown-link :href="route('logout')"
                                                    onclick="event.preventDefault();
                                                                this.closest('form').submit();">
                                                {{ __('Log Out') }}
                                            </x-dropdown-link>
                                        </form>
                                    </x-slot>
                                </x-dropdown>
                            </div>

                            <!-- Mobile Menu Toggle -->
                            <button x-data 
                                    @click="$dispatch('toggle-sidebar')" 
                                    class="lg:hidden inline-flex items-center justify-center p-3 rounded-lg border-2 border-ra-gold/30 bg-ra-gold/10 text-ra-gold hover:bg-ra-gold/20 hover:border-ra-gold focus:outline-none transition duration-150 ease-in-out shadow-gold-glow">
                                <svg class="h-6 w-6" stroke="currentColor" fill="none" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                                </svg>
                            </button>
                            @endauth
                        </div>
                    </div>
                </header>

                <!-- User Stats Bar (always visible) -->
                <x-user-stats-bar />

                <!-- Page Heading -->
                @isset($header)
                    <div class="bg-gradient-to-r from-papyrus-dark via-shadow-ink to-papyrus-dark border-b-2 border-ra-gold shadow-gold-glow">
                        <div class="px-4 sm:px-6 lg:px-8 py-4">
                            {{ $header }}
                        </div>
                    </div>
                @endisset

                <!-- Page Content -->
                <main class="relative z-10 flex-1">
                    {{ $slot }}
                </main>
            </div>
        </div>
        
        <!-- Character Animation Config -->
        <script>
            window.characterAnimationConfig = {
                states: @json(config('character_animations.states', [])),
                loopingStates: @json(config('character_animations.looping_states', [])),
                nonLoopingStates: @json(config('character_animations.non_looping_states', [])),
                autoReturnStates: @json(config('character_animations.auto_return_states', [])),
                stayOnLastFrameStates: @json(config('character_animations.stay_on_last_frame_states', [])),
                defaultState: @json(config('character_animations.default_state', 'idle')),
                videoFormats: @json(config('character_animations.video_formats', ['mp4', 'webm']))
            };
        </script>
        
        @stack('scripts')
    </body>
</html>
