<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>Quest of Ra - {{ config('app.name', 'Laravel') }}</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Cinzel+Decorative:wght@400;700&family=Noto+Serif:wght@400;600;700&family=Orbitron:wght@400;600;700&display=swap" rel="stylesheet">
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Scripts -->
        @vite(['resources/css/app.css', 'resources/js/app.js'])
    </head>
    <body class="font-sans antialiased" style="background: linear-gradient(to bottom, #1a0e0a, #2d1b0f);">
        <div class="min-h-screen flex flex-col sm:justify-center items-center pt-6 sm:pt-0 bg-papyrus-dark relative overflow-hidden">
            <!-- Hieroglyph Pattern Overlay -->
            <div class="fixed inset-0 opacity-5 pointer-events-none" style="background-image: url('data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTAwIiBoZWlnaHQ9IjEwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48cmVjdCB3aWR0aD0iMTAwIiBoZWlnaHQ9IjEwMCIgZmlsbD0iIzFhMGUwYSIvPjxwYXRoIGQ9Ik0yMCAyMGgxMHYxMEgyMHoiIGZpbGw9IiNkNGFmMzciLz48cGF0aCBkPSJNNzAgNzBoMTB2MTBINzB6IiBmaWxsPSIjZGZhZjM3Ii8+PC9zdmc+'); background-repeat: repeat;"></div>
            
            <!-- Animated Sun Ray Effect -->
            <div class="absolute top-0 left-1/2 transform -translate-x-1/2 w-96 h-96 opacity-10 pointer-events-none">
                <div class="absolute inset-0 bg-gradient-radial from-ra-gold via-transparent to-transparent animate-gold-pulse" style="background: radial-gradient(circle, rgba(212, 175, 55, 0.3) 0%, transparent 70%);"></div>
            </div>

            <!-- Logo / Brand -->
            <div class="relative z-10 mb-6">
                <a href="/" class="flex flex-col items-center gap-3 group">
                    <div class="text-7xl group-hover:scale-110 transition-transform duration-300">👁️</div>
                    <div class="font-egyptian text-ra-gold text-4xl text-shadow-gold group-hover:text-yellow-400 transition-colors duration-300">
                        Quest of Ra
                    </div>
                    <div class="text-desert-sand/70 text-sm font-egyptian">Enter the Sacred Temple</div>
                </a>
            </div>

            <!-- Auth Card -->
            <div class="w-full sm:max-w-md mt-6 px-6 py-8 quest-card relative z-10">
                {{ $slot }}
            </div>

            <!-- Decorative Elements -->
            <div class="absolute bottom-10 left-10 text-4xl opacity-20 pointer-events-none">𓂀</div>
            <div class="absolute bottom-10 right-10 text-4xl opacity-20 pointer-events-none">𓆣</div>
            <div class="absolute top-20 left-20 text-3xl opacity-15 pointer-events-none">☀️</div>
            <div class="absolute top-20 right-20 text-3xl opacity-15 pointer-events-none">🌙</div>
        </div>
    </body>
</html>
