<div x-data="sidebarData()" 
     @toggle-sidebar.window="sidebarOpen = !sidebarOpen"
     class="relative">
    <!-- Mobile Overlay -->
    <div x-show="sidebarOpen && window.innerWidth < 1024" 
         @click="sidebarOpen = false"
         x-transition:enter="transition-opacity ease-linear duration-300"
         x-transition:enter-start="opacity-0"
         x-transition:enter-end="opacity-100"
         x-transition:leave="transition-opacity ease-linear duration-300"
         x-transition:leave-start="opacity-100"
         x-transition:leave-end="opacity-0"
         class="fixed inset-0 bg-shadow-ink/80 z-40 lg:hidden"
         style="display: none;"></div>

    <!-- Sidebar Navigation -->
    <aside :class="{ 
            'translate-x-0': sidebarOpen || window.innerWidth >= 1024, 
            '-translate-x-full': !sidebarOpen && window.innerWidth < 1024 
           }"
           @click.away="if(window.innerWidth < 1024) sidebarOpen = false"
           class="fixed lg:static inset-y-0 left-0 z-50 w-72 bg-gradient-to-b from-papyrus-dark via-shadow-ink to-papyrus-dark border-r-2 border-ra-gold shadow-gold-glow-lg flex flex-col transition-transform duration-300 ease-in-out">
        
        <!-- Hieroglyph Decoration Top -->
        <div class="relative h-24 bg-gradient-to-b from-ra-gold/20 to-transparent border-b-2 border-ra-gold/30 flex items-center justify-center">
            <div class="absolute inset-0 opacity-10" style="background-image: repeating-linear-gradient(45deg, transparent, transparent 10px, rgba(212, 175, 55, 0.1) 10px, rgba(212, 175, 55, 0.1) 20px);"></div>
            <div class="relative text-center">
                <div class="text-5xl mb-1">👁️</div>
                <div class="font-egyptian text-ra-gold text-xs text-shadow-gold">Temple Navigation</div>
            </div>
        </div>

        <!-- Navigation Menu Items -->
        <nav class="flex-1 overflow-y-auto px-4 py-6 space-y-2 sidebar-scroll">
            <!-- Temple / Dashboard -->
            <a href="{{ route('dashboard') }}" 
               class="flex items-center gap-4 px-4 py-4 rounded-xl border-2 transition-all duration-300 group
                      {{ request()->routeIs('dashboard') 
                         ? 'bg-ra-gold/30 border-ra-gold shadow-gold-glow' 
                         : 'border-ra-gold/20 hover:border-ra-gold hover:bg-ra-gold/10' }}">
                <span class="text-3xl">🏺</span>
                <div class="flex-1">
                    <div class="font-egyptian text-ra-gold text-lg group-hover:text-yellow-400 transition-colors">
                        Temple
                    </div>
                    <div class="text-xs text-desert-sand/70 mt-0.5">Your Sacred Dashboard</div>
                </div>
            </a>

            <!-- Quests -->
            <a href="{{ route('tasks.index') }}" 
               class="flex items-center gap-4 px-4 py-4 rounded-xl border-2 transition-all duration-300 group
                      {{ request()->routeIs('tasks.index') || (request()->routeIs('tasks.*') && !request()->routeIs('tasks.completed'))
                         ? 'bg-ra-gold/30 border-ra-gold shadow-gold-glow' 
                         : 'border-ra-gold/20 hover:border-ra-gold hover:bg-ra-gold/10' }}">
                <span class="text-3xl">🗺️</span>
                <div class="flex-1">
                    <div class="font-egyptian text-ra-gold text-lg group-hover:text-yellow-400 transition-colors">
                        Quests
                    </div>
                    <div class="text-xs text-desert-sand/70 mt-0.5">Your Journey's Path</div>
                </div>
            </a>

            <!-- Completed Quests -->
            <a href="{{ route('tasks.completed') }}" 
               class="flex items-center gap-4 px-4 py-4 rounded-xl border-2 transition-all duration-300 group
                      {{ request()->routeIs('tasks.completed')
                         ? 'bg-green-900/30 border-green-500 shadow-lg' 
                         : 'border-green-500/20 hover:border-green-500 hover:bg-green-900/10' }}">
                <span class="text-3xl">✅</span>
                <div class="flex-1">
                    <div class="font-egyptian text-green-300 text-lg group-hover:text-green-200 transition-colors">
                        Completed Quests
                    </div>
                    <div class="text-xs text-desert-sand/70 mt-0.5">Your Achievements</div>
                </div>
            </a>

            <!-- Scrolls / Categories -->
            <a href="{{ route('categories.index') }}" 
               class="flex items-center gap-4 px-4 py-4 rounded-xl border-2 transition-all duration-300 group
                      {{ request()->routeIs('categories.*') 
                         ? 'bg-ra-gold/30 border-ra-gold shadow-gold-glow' 
                         : 'border-ra-gold/20 hover:border-ra-gold hover:bg-ra-gold/10' }}">
                <span class="text-3xl">📜</span>
                <div class="flex-1">
                    <div class="font-egyptian text-ra-gold text-lg group-hover:text-yellow-400 transition-colors">
                        Quest Scrolls
                    </div>
                    <div class="text-xs text-desert-sand/70 mt-0.5">Organize Your Path</div>
                </div>
            </a>

            <!-- Market of the Gods / Shop -->
            <a href="{{ route('shop.index') }}" 
               class="flex items-center gap-4 px-4 py-4 rounded-xl border-2 transition-all duration-300 group
                      {{ request()->routeIs('shop.*') 
                         ? 'bg-nile-turquoise/30 border-nile-turquoise shadow-turquoise-glow' 
                         : 'border-nile-turquoise/20 hover:border-nile-turquoise hover:bg-nile-turquoise/10' }}">
                <span class="text-3xl">💰</span>
                <div class="flex-1">
                    <div class="font-egyptian text-nile-turquoise text-lg group-hover:text-teal-300 transition-colors">
                        Market of the Gods
                    </div>
                    <div class="text-xs text-desert-sand/70 mt-0.5">Acquire Divine Relics</div>
                </div>
            </a>

            <!-- Blessings / Inventory -->
            <a href="{{ route('inventory.index') }}" 
               class="flex items-center gap-4 px-4 py-4 rounded-xl border-2 transition-all duration-300 group
                      {{ request()->routeIs('inventory.*') 
                         ? 'bg-purple-500/30 border-purple-400 shadow-lg' 
                         : 'border-purple-400/20 hover:border-purple-400 hover:bg-purple-500/10' }}">
                <span class="text-3xl">🧿</span>
                <div class="flex-1">
                    <div class="font-egyptian text-purple-300 text-lg group-hover:text-purple-200 transition-colors">
                        Blessings
                    </div>
                    <div class="text-xs text-desert-sand/70 mt-0.5">Your Sacred Collection</div>
                </div>
            </a>

            <!-- Characters -->
            <a href="{{ route('characters.index') }}" 
               class="flex items-center gap-4 px-4 py-4 rounded-xl border-2 transition-all duration-300 group
                      {{ request()->routeIs('characters.*') 
                         ? 'bg-ra-gold/30 border-ra-gold shadow-gold-glow' 
                         : 'border-ra-gold/20 hover:border-ra-gold hover:bg-ra-gold/10' }}">
                <span class="text-3xl">👤</span>
                <div class="flex-1">
                    <div class="font-egyptian text-ra-gold text-lg group-hover:text-yellow-400 transition-colors">
                        Characters
                    </div>
                    <div class="text-xs text-desert-sand/70 mt-0.5">Your Character Collection</div>
                </div>
            </a>

            <!-- Arena of Horus / Battle -->
            <a href="{{ route('battle.index') }}" 
               class="flex items-center gap-4 px-4 py-4 rounded-xl border-2 transition-all duration-300 group
                      {{ request()->routeIs('battle.*') 
                         ? 'bg-blood-red/30 border-blood-red shadow-lg' 
                         : 'border-blood-red/20 hover:border-blood-red hover:bg-blood-red/10' }}">
                <span class="text-3xl">⚔️</span>
                <div class="flex-1">
                    <div class="font-egyptian text-blood-red text-lg group-hover:text-red-400 transition-colors">
                        Arena of Horus
                    </div>
                    <div class="text-xs text-desert-sand/70 mt-0.5">Face Ancient Foes</div>
                </div>
            </a>

            <!-- Arena 3 -->
            <a href="{{ route('characters.arena-3') }}" 
               class="flex items-center gap-4 px-4 py-4 rounded-xl border-2 transition-all duration-300 group
                      {{ request()->routeIs('characters.arena-3') 
                         ? 'bg-blood-red/30 border-blood-red shadow-lg' 
                         : 'border-blood-red/20 hover:border-blood-red hover:bg-blood-red/10' }}">
                <span class="text-3xl">⚔️</span>
                <div class="flex-1">
                    <div class="font-egyptian text-blood-red text-lg group-hover:text-red-400 transition-colors">
                        Arena 3
                    </div>
                    <div class="text-xs text-desert-sand/70 mt-0.5">Epic Battle Arena</div>
                </div>
            </a>

            <!-- Admin (if admin) -->
            @auth
            @if(Auth::user()->is_admin)
            <a href="{{ route('admin.dashboard') }}" 
               class="flex items-center gap-4 px-4 py-4 rounded-xl border-2 transition-all duration-300 group
                      {{ request()->routeIs('admin.*') 
                         ? 'bg-nile-turquoise/30 border-nile-turquoise shadow-turquoise-glow' 
                         : 'border-nile-turquoise/20 hover:border-nile-turquoise hover:bg-nile-turquoise/10' }}">
                <span class="text-3xl">👑</span>
                <div class="flex-1">
                    <div class="font-egyptian text-nile-turquoise text-lg group-hover:text-teal-300 transition-colors">
                        Admin Temple
                    </div>
                    <div class="text-xs text-desert-sand/70 mt-0.5">Rule the Realm</div>
                </div>
            </a>
            @endif
            @endauth
        </nav>

        <!-- User Info & Actions (Bottom of Sidebar) -->
        @auth
        <div class="border-t-2 border-ra-gold/30 px-4 py-4 space-y-2 bg-papyrus-dark/50">
            <div class="px-2 mb-3">
                <div class="flex items-center gap-2 mb-1">
                    <div class="font-egyptian text-desert-sand text-sm">{{ Auth::user()->name }}</div>
                    @if(Auth::user()->isVip())
                        <span class="bg-ra-gold text-papyrus-dark text-xs font-bold px-2 py-0.5 rounded-full">VIP</span>
                    @endif
                </div>
                <div class="text-xs text-nile-turquoise">{{ Auth::user()->email }}</div>
                <div class="flex items-center gap-4 mt-2 text-xs">
                    <span class="text-desert-sand">💰 {{ number_format(Auth::user()->gold) }} Gold</span>
                    <span class="text-nile-turquoise">💎 {{ number_format(Auth::user()->premium_coins) }} Coins</span>
                </div>
                @if(Auth::user()->isVip() && Auth::user()->vip_expires_at)
                    @php
                        $daysUntilExpiry = now()->diffInDays(Auth::user()->vip_expires_at, false);
                    @endphp
                    @if($daysUntilExpiry <= 7 && $daysUntilExpiry >= 0)
                        <div class="text-xs text-blood-red mt-1">
                            VIP expires in {{ $daysUntilExpiry }} day{{ $daysUntilExpiry !== 1 ? 's' : '' }}
                        </div>
                    @endif
                @endif
            </div>
            
            <a href="{{ route('profile.edit') }}" 
               class="flex items-center gap-3 px-3 py-2 rounded-lg border border-ra-gold/20 hover:bg-ra-gold/10 hover:border-ra-gold text-desert-sand transition-all duration-300">
                <span class="text-xl">⚙️</span>
                <span class="text-sm">Profile Settings</span>
            </a>
            
            <form method="POST" action="{{ route('logout') }}">
                @csrf
                <button type="submit" 
                        class="w-full flex items-center gap-3 px-3 py-2 rounded-lg border border-blood-red/20 hover:bg-blood-red/10 hover:border-blood-red text-desert-sand transition-all duration-300 text-left">
                    <span class="text-xl">🚪</span>
                    <span class="text-sm">Leave the Temple</span>
                </button>
            </form>
        </div>
        @endauth

        <!-- Hieroglyph Decoration Bottom -->
        <div class="h-16 bg-gradient-to-t from-ra-gold/20 to-transparent border-t-2 border-ra-gold/30 flex items-center justify-center relative">
            <div class="absolute inset-0 opacity-10" style="background-image: repeating-linear-gradient(-45deg, transparent, transparent 10px, rgba(212, 175, 55, 0.1) 10px, rgba(212, 175, 55, 0.1) 20px);"></div>
            <div class="relative text-2xl opacity-50">𓂀</div>
        </div>
    </aside>
</div>

<script>
document.addEventListener('alpine:init', () => {
    Alpine.data('sidebarData', () => ({
        sidebarOpen: window.innerWidth >= 1024,
        
        init() {
            if (window.innerWidth >= 1024) {
                this.sidebarOpen = true;
            }
            
            window.addEventListener('resize', () => {
                if (window.innerWidth >= 1024) {
                    this.sidebarOpen = true;
                }
            });
        }
    }));
});
</script>
