<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold flex items-center gap-3">
                <span class="text-4xl">👑</span>
                <span>Membership Plans</span>
            </h2>
            <a href="{{ route('membership.status') }}" class="cartouche-button flex items-center gap-2">
                <span>📋</span>
                <span>My Status</span>
            </a>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            @if(session('success'))
                <div class="quest-card bg-gradient-to-r from-ra-gold/20 to-nile-turquoise/20 border-nile-turquoise mb-4">
                    <span class="block text-desert-sand font-egyptian">{{ session('success') }}</span>
                </div>
            @endif

            @if(session('error'))
                <div class="quest-card bg-gradient-to-r from-blood-red/20 to-red-900/20 border-blood-red mb-4">
                    <span class="block text-desert-sand">{{ session('error') }}</span>
                </div>
            @endif

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                @forelse($memberships as $membership)
                <div class="quest-card border-2 {{ $user->isVip() && $user->membership_id === $membership->id ? 'border-ra-gold shadow-gold-glow-lg' : 'border-ra-gold/30' }} hover:scale-105 transition-all duration-300">
                    <div class="text-center mb-6">
                        <div class="text-5xl mb-2">👑</div>
                        <h3 class="font-egyptian text-2xl text-ra-gold text-shadow-gold mb-2">{{ $membership->name }}</h3>
                        @if($user->isVip() && $user->membership_id === $membership->id)
                            <span class="inline-block bg-ra-gold text-papyrus-dark text-xs font-bold px-3 py-1 rounded-full mb-2">ACTIVE</span>
                        @endif
                    </div>

                    <div class="space-y-4 mb-6">
                        <div class="p-3 bg-ra-gold/10 border border-ra-gold rounded-lg">
                            <div class="text-sm text-desert-sand mb-1">Monthly Price</div>
                            <div class="font-stat text-2xl text-ra-gold">
                                @if($membership->monthly_price)
                                    ${{ number_format($membership->monthly_price, 2) }}/mo
                                @else
                                    N/A
                                @endif
                            </div>
                        </div>

                        <div class="space-y-2 text-sm text-desert-sand">
                            <div class="flex items-center gap-2">
                                <span class="text-nile-turquoise">✨</span>
                                <span>+{{ $membership->xp_bonus_percent }}% XP Bonus</span>
                            </div>
                            <div class="flex items-center gap-2">
                                <span class="text-ra-gold">💰</span>
                                <span>+{{ $membership->gold_bonus_percent }}% Gold Bonus</span>
                            </div>
                            <div class="flex items-center gap-2">
                                <span class="text-nile-turquoise">💎</span>
                                <span>{{ $membership->daily_premium_coins }} Premium Coins Daily</span>
                            </div>
                            <div class="flex items-center gap-2">
                                <span class="text-ra-gold">💰</span>
                                <span>{{ $membership->daily_gold_bonus }} Gold Daily Bonus</span>
                            </div>
                            @if($membership->vip_special_items_access)
                            <div class="flex items-center gap-2">
                                <span class="text-purple-300">👑</span>
                                <span>VIP Exclusive Items Access</span>
                            </div>
                            @endif
                            @if($membership->vip_event_access)
                            <div class="flex items-center gap-2">
                                <span class="text-yellow-400">🎉</span>
                                <span>VIP Event Access</span>
                            </div>
                            @endif
                            @if($membership->battle_cooldown_reduction > 0)
                            <div class="flex items-center gap-2">
                                <span class="text-blood-red">⚔️</span>
                                <span>{{ $membership->battle_cooldown_reduction }}% Battle Cooldown Reduction</span>
                            </div>
                            @endif
                        </div>
                    </div>

                    @if($user->isVip() && $user->membership_id === $membership->id)
                        <a href="{{ route('membership.status') }}" class="w-full bg-nile-turquoise/20 hover:bg-nile-turquoise/30 border border-nile-turquoise text-nile-turquoise text-center py-3 px-4 rounded-lg font-semibold transition-all duration-300 block">
                            View Status
                        </a>
                    @else
                        <form method="POST" action="{{ route('vip.subscribe') }}">
                            @csrf
                            <input type="hidden" name="membership_id" value="{{ $membership->id }}">
                            <select name="period" class="w-full bg-papyrus-dark border border-ra-gold/30 text-desert-sand rounded-lg px-3 py-2 mb-3">
                                <option value="monthly">Monthly - ${{ number_format($membership->monthly_price, 2) }}</option>
                                @if($membership->yearly_price)
                                    <option value="yearly">Yearly - ${{ number_format($membership->yearly_price, 2) }}</option>
                                @endif
                            </select>
                            <button type="submit" class="w-full cartouche-button hover:scale-105 transition-transform duration-300">
                                Subscribe with PayPal
                            </button>
                        </form>
                    @endif
                </div>
                @empty
                <div class="col-span-full quest-card text-center py-12">
                    <div class="text-6xl mb-4">👑</div>
                    <p class="text-desert-sand mb-4 font-egyptian">No membership plans available.</p>
                </div>
                @endforelse
            </div>
        </div>
    </div>
</x-app-layout>

