<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold flex items-center gap-3">
                <span class="text-4xl">👑</span>
                <span>VIP Membership Status</span>
            </h2>
            <a href="{{ route('membership.plans') }}" class="cartouche-button flex items-center gap-2">
                <span>📋</span>
                <span>View Plans</span>
            </a>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-4xl mx-auto sm:px-6 lg:px-8">
            @if(session('success'))
                <div class="quest-card bg-gradient-to-r from-ra-gold/20 to-nile-turquoise/20 border-nile-turquoise mb-4">
                    <span class="block text-desert-sand font-egyptian">{{ session('success') }}</span>
                </div>
            @endif

            @if(session('error'))
                <div class="quest-card bg-gradient-to-r from-blood-red/20 to-red-900/20 border-blood-red mb-4">
                    <span class="block text-desert-sand">{{ session('error') }}</span>
                </div>
            @endif

            @if($isVip && $membership)
                <div class="quest-card border-2 border-ra-gold shadow-gold-glow-lg mb-6">
                    <div class="text-center mb-6">
                        <div class="text-6xl mb-2">👑</div>
                        <h3 class="font-egyptian text-3xl text-ra-gold text-shadow-gold mb-2">{{ $membership->name }}</h3>
                        <span class="inline-block bg-ra-gold text-papyrus-dark text-lg font-bold px-4 py-2 rounded-full">ACTIVE</span>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                        <div class="p-4 bg-ra-gold/10 border border-ra-gold rounded-lg">
                            <div class="text-sm text-desert-sand mb-1">Expiration Date</div>
                            <div class="font-stat text-xl text-ra-gold">
                                @if($user->vip_expires_at)
                                    {{ $user->vip_expires_at->format('F d, Y') }}
                                    @php
                                        $daysUntilExpiry = now()->diffInDays($user->vip_expires_at, false);
                                    @endphp
                                    @if($daysUntilExpiry <= 7 && $daysUntilExpiry >= 0)
                                        <div class="text-xs text-blood-red mt-1">⚠️ {{ $daysUntilExpiry }} day{{ $daysUntilExpiry !== 1 ? 's' : '' }} remaining</div>
                                    @endif
                                @else
                                    Never expires
                                @endif
                            </div>
                        </div>

                        <div class="p-4 bg-nile-turquoise/10 border border-nile-turquoise rounded-lg">
                            <div class="text-sm text-desert-sand mb-1">Daily Rewards</div>
                            <div class="font-stat text-xl text-nile-turquoise">
                                {{ $membership->daily_premium_coins }} Coins + {{ $membership->daily_gold_bonus }} Gold
                            </div>
                            @php
                                $canClaimDaily = !$user->last_vip_reward_claimed_at || !$user->last_vip_reward_claimed_at->isToday();
                            @endphp
                            @if($canClaimDaily)
                                <form method="POST" action="{{ route('rewards.daily-vip') }}" class="mt-2">
                                    @csrf
                                    <button type="submit" class="w-full bg-nile-turquoise/20 hover:bg-nile-turquoise/30 border border-nile-turquoise text-nile-turquoise text-sm py-2 px-4 rounded-lg font-semibold transition-all duration-300">
                                        🎁 Claim Daily Blessing
                                    </button>
                                </form>
                            @else
                                <div class="text-xs text-desert-sand/70 mt-2 text-center">
                                    Already claimed today
                                </div>
                            @endif
                        </div>
                    </div>

                    <div class="space-y-4 mb-6">
                        <h4 class="font-egyptian text-xl text-ra-gold mb-3">Active Benefits</h4>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm text-desert-sand">
                            <div class="flex items-center gap-2 p-3 bg-papyrus-dark/50 rounded-lg">
                                <span class="text-nile-turquoise">✨</span>
                                <span>+{{ $membership->xp_bonus_percent }}% XP Bonus on all quests</span>
                            </div>
                            <div class="flex items-center gap-2 p-3 bg-papyrus-dark/50 rounded-lg">
                                <span class="text-ra-gold">💰</span>
                                <span>+{{ $membership->gold_bonus_percent }}% Gold Bonus on all quests</span>
                            </div>
                            <div class="flex items-center gap-2 p-3 bg-papyrus-dark/50 rounded-lg">
                                <span class="text-nile-turquoise">💎</span>
                                <span>{{ $membership->daily_premium_coins }} Premium Coins daily</span>
                            </div>
                            <div class="flex items-center gap-2 p-3 bg-papyrus-dark/50 rounded-lg">
                                <span class="text-ra-gold">💰</span>
                                <span>{{ $membership->daily_gold_bonus }} Gold daily bonus</span>
                            </div>
                            @if($membership->vip_special_items_access)
                            <div class="flex items-center gap-2 p-3 bg-papyrus-dark/50 rounded-lg">
                                <span class="text-purple-300">👑</span>
                                <span>Access to VIP Exclusive Items</span>
                            </div>
                            @endif
                            @if($membership->vip_event_access)
                            <div class="flex items-center gap-2 p-3 bg-papyrus-dark/50 rounded-lg">
                                <span class="text-yellow-400">🎉</span>
                                <span>Access to VIP Events</span>
                            </div>
                            @endif
                            @if($membership->battle_cooldown_reduction > 0)
                            <div class="flex items-center gap-2 p-3 bg-papyrus-dark/50 rounded-lg">
                                <span class="text-blood-red">⚔️</span>
                                <span>{{ $membership->battle_cooldown_reduction }}% Battle Cooldown Reduction</span>
                            </div>
                            @endif
                        </div>
                    </div>

                    <form method="POST" action="{{ route('membership.cancel') }}" 
                          onsubmit="return confirm('Are you sure you want to cancel your VIP membership? You will lose all VIP benefits immediately.')">
                        @csrf
                        <button type="submit" class="w-full bg-blood-red/20 hover:bg-blood-red/30 border border-blood-red text-blood-red text-center py-3 px-4 rounded-lg font-semibold transition-all duration-300">
                            Cancel Membership
                        </button>
                    </form>
                </div>
            @else
                <div class="quest-card text-center py-12">
                    <div class="text-6xl mb-4">👑</div>
                    <h3 class="font-egyptian text-2xl text-ra-gold mb-4">You are not a VIP member</h3>
                    <p class="text-desert-sand mb-6">Become a VIP member to unlock exclusive benefits and bonuses!</p>
                    <a href="{{ route('membership.plans') }}" class="cartouche-button inline-block">
                        View Membership Plans
                    </a>
                </div>
            @endif
        </div>
    </div>
</x-app-layout>

