<x-app-layout>
    <x-slot name="header">
        <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold flex items-center gap-3">
            <span class="text-4xl">📜</span>
            <span>Edit Scroll Category</span>
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-2xl mx-auto sm:px-6 lg:px-8">
            <div class="quest-card">
                <form method="POST" action="{{ route('scroll-categories.update', $scrollCategory) }}">
                    @csrf
                    @method('PATCH')

                    <div class="mb-6">
                        <label for="title" class="block text-desert-sand font-egyptian font-semibold mb-2">Scroll Category Name</label>
                        <input id="title" name="title" type="text" value="{{ old('title', $scrollCategory->title) }}" required autofocus
                            class="block w-full bg-papyrus-dark border-2 border-ra-gold/30 text-desert-sand rounded-lg px-4 py-2 focus:border-ra-gold focus:ring-2 focus:ring-ra-gold/50 transition-all duration-300">
                        @error('title')
                            <p class="mt-1 text-sm text-blood-red">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="mb-6">
                        <label for="description" class="block text-desert-sand font-egyptian font-semibold mb-2">Description</label>
                        <textarea id="description" name="description" rows="3"
                            class="block w-full bg-papyrus-dark border-2 border-ra-gold/30 text-desert-sand rounded-lg px-4 py-2 focus:border-ra-gold focus:ring-2 focus:ring-ra-gold/50 transition-all duration-300">{{ old('description', $scrollCategory->description) }}</textarea>
                        @error('description')
                            <p class="mt-1 text-sm text-blood-red">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="mb-6">
                        <label for="color" class="block text-desert-sand font-egyptian font-semibold mb-2">Color</label>
                        <div class="flex gap-3 items-center">
                            <input id="color" name="color" type="color" value="{{ old('color', $scrollCategory->color ?: '#d4a65a') }}"
                                class="block w-20 h-12 rounded-lg border-2 border-ra-gold/30 cursor-pointer bg-papyrus-dark"
                                style="appearance: none; -webkit-appearance: none;">
                            <input type="text" 
                                   id="color-text" 
                                   value="{{ old('color', $scrollCategory->color ?: '#d4a65a') }}"
                                   readonly
                                   class="flex-1 bg-papyrus-dark border-2 border-ra-gold/30 text-desert-sand rounded-lg px-4 py-2 focus:border-ra-gold focus:ring-2 focus:ring-ra-gold/50 transition-all duration-300 font-stat">
                        </div>
                        <p class="mt-2 text-xs text-desert-sand/70">Choose a color for your scroll category</p>
                        @error('color')
                            <p class="mt-1 text-sm text-blood-red">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="mb-6">
                        <label for="icon" class="block text-desert-sand font-egyptian font-semibold mb-2">Icon</label>
                        <select id="icon" name="icon"
                            class="block w-full bg-papyrus-dark border-2 border-ra-gold/30 text-desert-sand rounded-lg px-4 py-2 focus:border-ra-gold focus:ring-2 focus:ring-ra-gold/50 transition-all duration-300 text-2xl"
                            style="font-size: 1.5rem; line-height: 2rem;">
                            <option value="">Select an Icon</option>
                            <option value="📜" {{ old('icon', $scrollCategory->icon) == '📜' ? 'selected' : '' }}>📜 Scroll</option>
                            <option value="🗺️" {{ old('icon', $scrollCategory->icon) == '🗺️' ? 'selected' : '' }}>🗺️ Map</option>
                            <option value="📖" {{ old('icon', $scrollCategory->icon) == '📖' ? 'selected' : '' }}>📖 Book</option>
                            <option value="⚔️" {{ old('icon', $scrollCategory->icon) == '⚔️' ? 'selected' : '' }}>⚔️ Swords</option>
                            <option value="🎉" {{ old('icon', $scrollCategory->icon) == '🎉' ? 'selected' : '' }}>🎉 Party</option>
                            <option value="🧘" {{ old('icon', $scrollCategory->icon) == '🧘' ? 'selected' : '' }}>🧘 Meditation</option>
                            <option value="🏺" {{ old('icon', $scrollCategory->icon) == '🏺' ? 'selected' : '' }}>🏺 Vase</option>
                            <option value="👁️" {{ old('icon', $scrollCategory->icon) == '👁️' ? 'selected' : '' }}>👁️ Eye of Ra</option>
                            <option value="🛡️" {{ old('icon', $scrollCategory->icon) == '🛡️' ? 'selected' : '' }}>🛡️ Shield</option>
                            <option value="💰" {{ old('icon', $scrollCategory->icon) == '💰' ? 'selected' : '' }}>💰 Gold</option>
                            <option value="🧿" {{ old('icon', $scrollCategory->icon) == '🧿' ? 'selected' : '' }}>🧿 Amulet</option>
                            <option value="🔮" {{ old('icon', $scrollCategory->icon) == '🔮' ? 'selected' : '' }}>🔮 Crystal Ball</option>
                            <option value="⚡" {{ old('icon', $scrollCategory->icon) == '⚡' ? 'selected' : '' }}>⚡ Lightning</option>
                            <option value="🔥" {{ old('icon', $scrollCategory->icon) == '🔥' ? 'selected' : '' }}>🔥 Fire</option>
                            <option value="💎" {{ old('icon', $scrollCategory->icon) == '💎' ? 'selected' : '' }}>💎 Gem</option>
                            <option value="🌟" {{ old('icon', $scrollCategory->icon) == '🌟' ? 'selected' : '' }}>🌟 Star</option>
                            <option value="🌙" {{ old('icon', $scrollCategory->icon) == '🌙' ? 'selected' : '' }}>🌙 Moon</option>
                            <option value="☀️" {{ old('icon', $scrollCategory->icon) == '☀️' ? 'selected' : '' }}>☀️ Sun</option>
                            <option value="🎯" {{ old('icon', $scrollCategory->icon) == '🎯' ? 'selected' : '' }}>🎯 Target</option>
                            <option value="🏆" {{ old('icon', $scrollCategory->icon) == '🏆' ? 'selected' : '' }}>🏆 Trophy</option>
                            <option value="👑" {{ old('icon', $scrollCategory->icon) == '👑' ? 'selected' : '' }}>👑 Crown</option>
                        </select>
                        <p class="mt-2 text-xs text-desert-sand/70">Choose an icon to represent your scroll category</p>
                        @error('icon')
                            <p class="mt-1 text-sm text-blood-red">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="mb-6">
                        <label for="sort_order" class="block text-desert-sand font-egyptian font-semibold mb-2">Sort Order</label>
                        <input id="sort_order" name="sort_order" type="number" value="{{ old('sort_order', $scrollCategory->sort_order) }}" min="0"
                            class="block w-full bg-papyrus-dark border-2 border-ra-gold/30 text-desert-sand rounded-lg px-4 py-2 focus:border-ra-gold focus:ring-2 focus:ring-ra-gold/50 transition-all duration-300">
                        <p class="mt-2 text-xs text-desert-sand/70">Lower numbers appear first</p>
                        @error('sort_order')
                            <p class="mt-1 text-sm text-blood-red">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="mb-6">
                        <label class="flex items-center gap-2">
                            <input type="checkbox" name="is_active" value="1" {{ old('is_active', $scrollCategory->is_active) ? 'checked' : '' }}
                                class="rounded border-ra-gold text-ra-gold">
                            <span class="text-desert-sand font-egyptian font-semibold">Active</span>
                        </label>
                        <p class="mt-2 text-xs text-desert-sand/70">Inactive scroll categories won't appear in the quest list</p>
                    </div>

                    <div class="flex items-center justify-end gap-4">
                        <a href="{{ route('scroll-categories.index') }}" class="bg-papyrus-dark hover:bg-shadow-ink border-2 border-ra-gold/30 text-desert-sand font-bold py-2 px-6 rounded-lg transition-all duration-300">
                            Cancel
                        </a>
                        <button type="submit" class="cartouche-button">
                            Update Scroll Category
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        // Sync color picker with text input
        document.getElementById('color').addEventListener('input', function(e) {
            document.getElementById('color-text').value = e.target.value.toUpperCase();
        });
        
        document.getElementById('color-text').addEventListener('input', function(e) {
            if (/^#[0-9A-F]{6}$/i.test(e.target.value)) {
                document.getElementById('color').value = e.target.value;
            }
        });
    </script>
</x-app-layout>

