<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold flex items-center gap-3">
                <span class="text-4xl">📜</span>
                <span>Quest Scroll Categories</span>
            </h2>
            <a href="{{ route('scroll-categories.create') }}" class="cartouche-button flex items-center gap-2">
                <span>📜</span>
                <span>New Scroll Category</span>
            </a>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            @if(session('success'))
                <div class="quest-card bg-gradient-to-r from-ra-gold/20 to-nile-turquoise/20 border-nile-turquoise mb-4">
                    <span class="block text-desert-sand font-egyptian">{{ session('success') }}</span>
                </div>
            @endif

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                @forelse($scrollCategories as $scrollCategory)
                <div class="quest-card hover:scale-105 transition-transform duration-300">
                    <div class="flex justify-between items-start mb-4">
                        <div>
                            <h3 class="font-egyptian text-2xl text-ra-gold text-shadow-gold">{{ $scrollCategory->title }}</h3>
                            @if($scrollCategory->description)
                                <p class="text-sm text-desert-sand mt-1">{{ Str::limit($scrollCategory->description, 50) }}</p>
                            @endif
                        </div>
                        @if($scrollCategory->icon)
                        <span class="text-4xl">{{ $scrollCategory->icon }}</span>
                        @endif
                    </div>

                    <div class="flex justify-between items-center mb-4 p-2 bg-papyrus-dark/50 rounded border border-ra-gold/30">
                        <span class="text-desert-sand text-sm">{{ $scrollCategory->tasks()->count() }} quests</span>
                        @if($scrollCategory->color)
                        <div class="w-6 h-6 rounded-full border-2 border-ra-gold" style="background-color: {{ $scrollCategory->color }}"></div>
                        @endif
                    </div>

                    <div class="flex gap-2">
                        <a href="{{ route('scroll-categories.show', $scrollCategory) }}" class="flex-1 bg-nile-turquoise/20 hover:bg-nile-turquoise/30 border border-nile-turquoise text-nile-turquoise text-center py-2 px-4 rounded-lg text-sm font-semibold transition-all duration-300">
                            View
                        </a>
                        <a href="{{ route('scroll-categories.edit', $scrollCategory) }}" class="flex-1 bg-ra-gold/20 hover:bg-ra-gold/30 border border-ra-gold text-ra-gold text-center py-2 px-4 rounded-lg text-sm font-semibold transition-all duration-300">
                            Edit
                        </a>
                        <form method="POST" action="{{ route('scroll-categories.destroy', $scrollCategory) }}" class="flex-1" 
                            onsubmit="return confirm('Delete this scroll category? Quests will not be deleted, but will become uncategorized.')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="w-full bg-blood-red/20 hover:bg-blood-red/30 border border-blood-red text-blood-red text-center py-2 px-4 rounded-lg text-sm font-semibold transition-all duration-300">
                                Delete
                            </button>
                        </form>
                    </div>
                </div>
                @empty
                <div class="col-span-full quest-card text-center py-12">
                    <div class="text-6xl mb-4">📜</div>
                    <p class="text-desert-sand mb-4 font-egyptian">No scroll categories found.</p>
                    <a href="{{ route('scroll-categories.create') }}" class="cartouche-button inline-block">
                        Create Your First Scroll Category!
                    </a>
                </div>
                @endforelse
            </div>
        </div>
    </div>
</x-app-layout>

