<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold flex items-center gap-3">
                <span class="text-4xl">{{ $scrollCategory->icon ?? '📜' }}</span>
                <span>Scroll Category: {{ $scrollCategory->title }}</span>
            </h2>
            <div class="flex gap-2">
                <a href="{{ route('scroll-categories.edit', $scrollCategory) }}" class="bg-ra-gold/20 hover:bg-ra-gold/30 border border-ra-gold text-ra-gold font-bold py-2 px-4 rounded-lg transition-all duration-300">
                    Edit
                </a>
                <a href="{{ route('scroll-categories.index') }}" class="bg-papyrus-dark hover:bg-shadow-ink border border-ra-gold/30 text-desert-sand font-bold py-2 px-4 rounded-lg transition-all duration-300">
                    Back
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="quest-card mb-6">
                <div class="flex items-center gap-4 mb-4">
                    @if($scrollCategory->icon)
                    <span class="text-6xl">{{ $scrollCategory->icon }}</span>
                    @endif
                    <div>
                        <h1 class="font-egyptian text-4xl text-ra-gold text-shadow-gold">{{ $scrollCategory->title }}</h1>
                        @if($scrollCategory->description)
                            <p class="text-desert-sand mt-1">{{ $scrollCategory->description }}</p>
                        @endif
                    </div>
                    @if($scrollCategory->color)
                    <div class="w-12 h-12 rounded-full ml-auto border-2 border-ra-gold" style="background-color: {{ $scrollCategory->color }}"></div>
                    @endif
                </div>
            </div>

            <div class="quest-card">
                <div class="flex justify-between items-center mb-6">
                    <h3 class="font-egyptian text-2xl text-ra-gold">Quests ({{ $scrollCategory->tasks->count() }})</h3>
                    <a href="{{ route('tasks.create') }}?scroll_id={{ $scrollCategory->id }}" class="cartouche-button flex items-center gap-2">
                        <span>📜</span>
                        <span>New Quest</span>
                    </a>
                </div>

                <div class="space-y-3">
                    @forelse($scrollCategory->tasks as $task)
                    <div class="flex justify-between items-center p-4 bg-papyrus-dark/50 border-2 border-ra-gold/20 rounded-lg hover:border-ra-gold hover:bg-papyrus-dark transition-all duration-300">
                        <div class="flex-1">
                            <a href="{{ route('tasks.show', $task) }}" class="font-egyptian text-ra-gold text-lg hover:text-yellow-400 transition-colors duration-300">
                                {{ $task->title }}
                            </a>
                            <div class="text-sm text-desert-sand mt-1 flex items-center gap-3 flex-wrap">
                                <span>✨ {{ $task->points }} Divine Energy</span>
                                @if($task->coins > 0)
                                <span>•</span>
                                <span>💰 {{ $task->coins }} Coins</span>
                                @endif
                                @if($task->difficulty_level)
                                <span>•</span>
                                <span>⚔️ <span class="capitalize">{{ $task->difficulty_level }}</span></span>
                                @endif
                                <span>•</span>
                                <span class="capitalize px-2 py-1 rounded text-xs
                                    {{ $task->status === 'completed' ? 'bg-green-900/30 border border-green-500 text-green-300' : '' }}
                                    {{ $task->status === 'pending' ? 'bg-ra-gold/20 border border-ra-gold text-ra-gold' : '' }}
                                    {{ $task->status === 'skipped' ? 'bg-gray-700/30 border border-gray-500 text-gray-300' : '' }}">
                                    {{ $task->status }}
                                </span>
                                @if($task->due_date)
                                <span>•</span>
                                <span>⏳ Due: {{ $task->due_date->format('M d, Y') }}</span>
                                @endif
                            </div>
                        </div>
                        @if($task->status !== 'completed')
                        <form method="POST" action="{{ route('tasks.complete', $task) }}" class="ml-4">
                            @csrf
                            <button type="submit" class="cartouche-button text-sm">
                                Complete
                            </button>
                        </form>
                        @endif
                    </div>
                    @empty
                    <div class="text-center py-12">
                        <div class="text-6xl mb-4">📜</div>
                        <p class="text-desert-sand mb-4 font-egyptian">No quests in this scroll category yet.</p>
                        <a href="{{ route('tasks.create') }}?scroll_id={{ $scrollCategory->id }}" class="cartouche-button inline-block">
                            Create Your First Quest!
                        </a>
                    </div>
                    @endforelse
                </div>
            </div>
        </div>
    </div>
</x-app-layout>

