<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold flex items-center gap-3">
                <span class="text-4xl">💰</span>
                <span>Market of the Gods</span>
            </h2>
            <div class="flex items-center gap-4">
                <div class="bg-ra-gold/20 border-2 border-ra-gold px-4 py-2 rounded-lg">
                    <span class="font-stat text-ra-gold text-xl">💰 {{ number_format($user->gold) }} Gold</span>
                </div>
                <div class="bg-nile-turquoise/20 border-2 border-nile-turquoise px-4 py-2 rounded-lg">
                    <span class="font-stat text-nile-turquoise text-xl">💎 {{ number_format($user->premium_coins) }} Coins</span>
                </div>
                <a href="{{ route('inventory.index') }}" class="cartouche-button flex items-center gap-2">
                    <span>🧿</span>
                    <span>Blessings</span>
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            @if(session('success'))
                <div class="quest-card bg-gradient-to-r from-ra-gold/20 to-nile-turquoise/20 border-nile-turquoise mb-4">
                    <span class="block text-desert-sand font-egyptian">{{ session('success') }}</span>
                </div>
            @endif

            @if(session('error'))
                <div class="quest-card bg-gradient-to-r from-blood-red/20 to-red-900/20 border-blood-red mb-4">
                    <span class="block text-desert-sand">{{ session('error') }}</span>
                </div>
            @endif

            <!-- Tabs for Item Categories -->
            <div x-data="{ activeTab: 'regular' }" class="mb-6">
                <div class="flex gap-2 border-b-2 border-ra-gold/30 mb-6">
                    <button @click="activeTab = 'regular'" 
                            :class="activeTab === 'regular' ? 'bg-ra-gold/30 border-ra-gold text-ra-gold' : 'bg-papyrus-dark/50 border-ra-gold/20 text-desert-sand'"
                            class="px-6 py-3 border-2 rounded-t-lg font-egyptian transition-all duration-300">
                        Regular Items
                    </button>
                    <button @click="activeTab = 'premium'" 
                            :class="activeTab === 'premium' ? 'bg-nile-turquoise/30 border-nile-turquoise text-nile-turquoise' : 'bg-papyrus-dark/50 border-nile-turquoise/20 text-desert-sand'"
                            class="px-6 py-3 border-2 rounded-t-lg font-egyptian transition-all duration-300">
                        💎 Premium Items
                    </button>
                    <button @click="activeTab = 'vip'" 
                            :class="activeTab === 'vip' ? 'bg-ra-gold/30 border-ra-gold text-ra-gold' : 'bg-papyrus-dark/50 border-ra-gold/20 text-desert-sand'"
                            class="px-6 py-3 border-2 rounded-t-lg font-egyptian transition-all duration-300">
                        👑 VIP Exclusive
                    </button>
                </div>

                <!-- Regular Items Tab -->
                <div x-show="activeTab === 'regular'" x-transition>
                    @include('shop.item-grid', ['items' => $regularItems, 'ownedItemIds' => $ownedItemIds, 'user' => $user, 'isVip' => $isVip])
                </div>

                <!-- Premium Items Tab -->
                <div x-show="activeTab === 'premium'" x-transition>
                    @include('shop.item-grid', ['items' => $premiumItems, 'ownedItemIds' => $ownedItemIds, 'user' => $user, 'isVip' => $isVip])
                </div>

                <!-- VIP Items Tab -->
                <div x-show="activeTab === 'vip'" x-transition>
                    @if($isVip)
                        @include('shop.item-grid', ['items' => $vipItems, 'ownedItemIds' => $ownedItemIds, 'user' => $user, 'isVip' => $isVip])
                    @else
                        <div class="quest-card text-center py-12">
                            <div class="text-6xl mb-4">👑</div>
                            <p class="text-desert-sand mb-4 font-egyptian text-xl">VIP Membership Required</p>
                            <p class="text-desert-sand/70 mb-6">Become a VIP member to access exclusive items!</p>
                            <a href="{{ route('membership.plans') }}" class="cartouche-button inline-block">
                                View VIP Plans
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
