<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold flex items-center gap-3">
                <span class="text-4xl">✅</span>
                <span>Completed Quests</span>
            </h2>
            <a href="{{ route('tasks.index') }}" class="cartouche-button flex items-center gap-2">
                <span>🗺️</span>
                <span>Active Quests</span>
            </a>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            @if(session('success'))
                <div class="quest-card bg-gradient-to-r from-ra-gold/20 to-nile-turquoise/20 border-nile-turquoise mb-6">
                    <span class="block text-desert-sand font-egyptian">{{ session('success') }}</span>
                </div>
            @endif

            <!-- View Switcher -->
            <x-quests.view-switcher :currentView="$viewMode" />

            <!-- Filters -->
            <div class="quest-card mb-6">
                <form method="GET" action="{{ route('tasks.completed') }}" class="flex gap-4 flex-wrap items-end">
                    <input type="hidden" name="view" value="{{ $viewMode }}">
                    
                    <div>
                        <label class="block text-desert-sand/70 text-sm mb-1">Quest Scroll</label>
                        <select name="scroll" class="bg-papyrus-dark border border-ra-gold/30 text-desert-sand rounded-lg px-3 py-2 focus:border-ra-gold focus:ring-2 focus:ring-ra-gold/50">
                            <option value="">All Scrolls</option>
                            @foreach($categories as $category)
                                <option value="{{ $category->id }}" {{ request('scroll') == $category->id ? 'selected' : '' }}>
                                    {{ $category->icon ?? '📜' }} {{ $category->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div>
                        <label class="block text-desert-sand/70 text-sm mb-1">Difficulty</label>
                        <select name="difficulty" class="bg-papyrus-dark border border-ra-gold/30 text-desert-sand rounded-lg px-3 py-2 focus:border-ra-gold focus:ring-2 focus:ring-ra-gold/50">
                            <option value="">All Difficulties</option>
                            <option value="easy" {{ request('difficulty') == 'easy' ? 'selected' : '' }}>Easy</option>
                            <option value="medium" {{ request('difficulty') == 'medium' ? 'selected' : '' }}>Medium</option>
                            <option value="hard" {{ request('difficulty') == 'hard' ? 'selected' : '' }}>Hard</option>
                            <option value="expert" {{ request('difficulty') == 'expert' ? 'selected' : '' }}>Expert</option>
                        </select>
                    </div>

                    <div>
                        <label class="block text-desert-sand/70 text-sm mb-1">Completed Date</label>
                        <select name="completed_date" class="bg-papyrus-dark border border-ra-gold/30 text-desert-sand rounded-lg px-3 py-2 focus:border-ra-gold focus:ring-2 focus:ring-ra-gold/50">
                            <option value="">All Dates</option>
                            <option value="today" {{ request('completed_date') == 'today' ? 'selected' : '' }}>Today</option>
                            <option value="this_week" {{ request('completed_date') == 'this_week' ? 'selected' : '' }}>This Week</option>
                            <option value="this_month" {{ request('completed_date') == 'this_month' ? 'selected' : '' }}>This Month</option>
                        </select>
                    </div>

                    <div class="flex gap-2">
                        <button type="submit" class="bg-nile-turquoise/20 hover:bg-nile-turquoise/30 border border-nile-turquoise text-nile-turquoise font-bold py-2 px-4 rounded-lg transition-all duration-300">
                            Filter
                        </button>
                        <a href="{{ route('tasks.completed', ['view' => $viewMode]) }}" class="bg-papyrus-dark hover:bg-shadow-ink border border-ra-gold/30 text-desert-sand font-bold py-2 px-4 rounded-lg transition-all duration-300">
                            Clear
                        </a>
                    </div>
                </form>
            </div>

            <!-- Completed Quest Scrolls (Categories) -->
            @if($categories->count() > 0)
                <div class="space-y-6">
                    @foreach($categories as $category)
                        @if(request('scroll') && request('scroll') != $category->id)
                            @continue
                        @endif
                        @if($category->tasks->count() > 0 || !request('scroll'))
                            <x-quests.scroll-category :scroll="$category" :viewMode="$viewMode" :isExpanded="!request('scroll') || request('scroll') == $category->id" />
                        @endif
                    @endforeach
                </div>
            @else
                <div class="quest-card text-center py-12">
                    <div class="text-6xl mb-4">✅</div>
                    <p class="text-desert-sand mb-4 font-egyptian">No completed quests found.</p>
                    <a href="{{ route('tasks.index') }}" class="cartouche-button inline-block">
                        View Active Quests
                    </a>
                </div>
            @endif
        </div>
    </div>
</x-app-layout>

