<x-app-layout>
    <x-slot name="header">
        <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold flex items-center gap-3">
            <span class="text-4xl">📜</span>
            <span>Create New Quest</span>
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-2xl mx-auto sm:px-6 lg:px-8">
            @if($errors->any())
                <div class="quest-card bg-red-900/30 border-2 border-red-500 mb-6">
                    <div class="text-blood-red font-semibold mb-2">⚠️ Please fix the following errors:</div>
                    <ul class="list-disc list-inside text-blood-red text-sm space-y-1">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            
            @if(session('error'))
                <div class="quest-card bg-red-900/30 border-2 border-red-500 mb-6">
                    <p class="text-blood-red">{{ session('error') }}</p>
                </div>
            @endif
            
            <div class="quest-card">
                <form method="POST" action="{{ route('tasks.store') }}" id="task-form">
                    @csrf

                    <div class="mb-6">
                        <label for="title" class="block text-desert-sand font-egyptian font-semibold mb-2">Quest Title</label>
                        <input id="title" name="title" type="text" value="{{ old('title') }}" required autofocus
                            class="block w-full bg-papyrus-dark border-2 border-ra-gold/30 text-desert-sand rounded-lg px-4 py-2 focus:border-ra-gold focus:ring-2 focus:ring-ra-gold/50 transition-all duration-300">
                        @error('title')
                            <p class="mt-1 text-sm text-blood-red">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="mb-6">
                        <label for="description" class="block text-desert-sand font-egyptian font-semibold mb-2">Description</label>
                        <textarea id="description" name="description" rows="4"
                            class="block w-full bg-papyrus-dark border-2 border-ra-gold/30 text-desert-sand rounded-lg px-4 py-2 focus:border-ra-gold focus:ring-2 focus:ring-ra-gold/50 transition-all duration-300">{{ old('description') }}</textarea>
                        @error('description')
                            <p class="mt-1 text-sm text-blood-red">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="mb-6">
                        <label for="category_id" class="block text-desert-sand font-egyptian font-semibold mb-2">Quest Scroll</label>
                        <select id="category_id" name="category_id" required
                            class="block w-full bg-papyrus-dark border-2 border-ra-gold/30 text-desert-sand rounded-lg px-4 py-2 focus:border-ra-gold focus:ring-2 focus:ring-ra-gold/50 transition-all duration-300">
                            <option value="">Select a category</option>
                            @foreach($categories as $category)
                                <option value="{{ $category->id }}" {{ old('category_id', $selectedCategoryId ?? '') == $category->id ? 'selected' : '' }}>
                                    {{ $category->name }}
                                </option>
                            @endforeach
                        </select>
                        @error('category_id')
                            <p class="mt-1 text-sm text-blood-red">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="mb-6">
                        <label for="difficulty_level" class="block text-desert-sand font-egyptian font-semibold mb-2">Quest Difficulty</label>
                        <select id="difficulty_level" name="difficulty_level" required
                            class="block w-full bg-papyrus-dark border-2 border-ra-gold/30 text-desert-sand rounded-lg px-4 py-2 focus:border-ra-gold focus:ring-2 focus:ring-ra-gold/50 transition-all duration-300"
                            onchange="updateDifficultyRewards(this.value)">
                            <option value="">Select difficulty</option>
                            <option value="easy" {{ old('difficulty_level', 'medium') == 'easy' ? 'selected' : '' }}>Easy - 10 XP, 5 Coins</option>
                            <option value="medium" {{ old('difficulty_level', 'medium') == 'medium' ? 'selected' : '' }}>Medium - 25 XP, 15 Coins</option>
                            <option value="hard" {{ old('difficulty_level') == 'hard' ? 'selected' : '' }}>Hard - 50 XP, 35 Coins</option>
                            <option value="expert" {{ old('difficulty_level') == 'expert' ? 'selected' : '' }}>Expert - 100 XP, 75 Coins</option>
                        </select>
                        @error('difficulty_level')
                            <p class="mt-1 text-sm text-blood-red">{{ $message }}</p>
                        @enderror
                        <p class="mt-2 text-sm text-desert-sand/70" id="difficulty-info">Select a difficulty level to see rewards</p>
                    </div>

                    <div class="mb-6">
                        <label for="due_date" class="block text-desert-sand font-egyptian font-semibold mb-2">Due Date (Optional)</label>
                        <input id="due_date" name="due_date" type="datetime-local" value="{{ old('due_date') }}"
                            class="block w-full bg-papyrus-dark border-2 border-ra-gold/30 text-desert-sand rounded-lg px-4 py-2 focus:border-ra-gold focus:ring-2 focus:ring-ra-gold/50 transition-all duration-300"
                            onchange="updateReminderOptions()">
                        @error('due_date')
                            <p class="mt-1 text-sm text-blood-red">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Reminders Section -->
                    <div class="mb-6 quest-card">
                        <div class="flex items-center justify-between mb-4">
                            <h3 class="font-egyptian text-xl text-ra-gold">🔔 Reminders</h3>
                            <button type="button" onclick="toggleReminders()" class="text-nile-turquoise hover:text-nile-turquoise/70 text-sm">
                                <span id="reminders-toggle-text">Show</span>
                            </button>
                        </div>
                        <div id="reminders-section" class="hidden space-y-4">
                            <p class="text-sm text-desert-sand/70">Set up reminders to stay on track with your quest. Reminders are color-coded: <span class="text-green-400">Green</span> (plenty of time), <span class="text-yellow-400">Yellow</span> (running out), <span class="text-red-400">Red</span> (urgent).</p>
                            
                            <div id="reminders-container" class="space-y-4">
                                <!-- Reminders will be dynamically added here -->
                            </div>
                            
                            <button type="button" onclick="addReminder()" class="bg-nile-turquoise/20 hover:bg-nile-turquoise/30 border border-nile-turquoise text-nile-turquoise font-bold py-2 px-4 rounded-lg text-sm transition-all duration-300">
                                + Add Reminder
                            </button>
                        </div>
                    </div>

                    <div class="flex items-center justify-end gap-4">
                        <a href="{{ route('tasks.index') }}" class="bg-papyrus-dark hover:bg-shadow-ink border-2 border-ra-gold/30 text-desert-sand font-bold py-2 px-6 rounded-lg transition-all duration-300">
                            Cancel
                        </a>
                        <button type="submit" class="cartouche-button">
                            Create Quest
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        const difficultyLevels = {
            easy: { points: 10, coins: 5, label: 'Easy', desc: 'Simple quests for beginners' },
            medium: { points: 25, coins: 15, label: 'Medium', desc: 'Moderate challenges' },
            hard: { points: 50, coins: 35, label: 'Hard', desc: 'Difficult quests for experienced adventurers' },
            expert: { points: 100, coins: 75, label: 'Expert', desc: 'The most challenging quests' }
        };

        function updateDifficultyRewards(level) {
            const infoEl = document.getElementById('difficulty-info');
            if (level && difficultyLevels[level]) {
                const config = difficultyLevels[level];
                infoEl.innerHTML = `<span class="text-ra-gold font-semibold">${config.label}:</span> ${config.desc}<br><span class="text-nile-turquoise">✨ ${config.points} Divine Energy</span> | <span class="text-ra-gold">💰 ${config.coins} Coins</span>`;
            } else {
                infoEl.textContent = 'Select a difficulty level to see rewards';
            }
        }

        // Initialize on page load
        document.addEventListener('DOMContentLoaded', function() {
            const select = document.getElementById('difficulty_level');
            if (select.value) {
                updateDifficultyRewards(select.value);
            }
            updateReminderOptions();
        });

        // Reminder management
        let reminderIndex = 0;

        function toggleReminders() {
            const section = document.getElementById('reminders-section');
            const toggleText = document.getElementById('reminders-toggle-text');
            section.classList.toggle('hidden');
            toggleText.textContent = section.classList.contains('hidden') ? 'Show' : 'Hide';
        }

        function addReminder() {
            const container = document.getElementById('reminders-container');
            const index = reminderIndex++;
            const categoryId = document.getElementById('category_id').value;
            const category = document.getElementById('category_id').options[document.getElementById('category_id').selectedIndex].text;
            const isRepetitive = category.toLowerCase().includes('daily') || category.toLowerCase().includes('weekly');
            
            const reminderHtml = `
                <div class="reminder-item p-4 bg-papyrus-dark/50 rounded-lg border border-ra-gold/30" data-index="${index}">
                    <div class="flex items-start justify-between mb-3">
                        <div class="flex items-center gap-2">
                            <input type="hidden" name="reminders[${index}][enabled]" value="0">
                            <input type="checkbox" name="reminders[${index}][enabled]" value="1" checked class="reminder-enabled rounded border-ra-gold text-ra-gold">
                            <label class="text-desert-sand font-semibold">Reminder ${index + 1}</label>
                        </div>
                        <button type="button" onclick="removeReminder(${index})" class="text-blood-red hover:text-blood-red/70 text-sm">Remove</button>
                    </div>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-desert-sand/70 text-sm mb-1">Type</label>
                            <select name="reminders[${index}][type]" class="reminder-type w-full bg-papyrus-dark border border-ra-gold/30 text-desert-sand rounded-lg px-3 py-2 text-sm">
                                <option value="green">🟢 Green - Plenty of Time</option>
                                <option value="yellow">🟡 Yellow - Running Out</option>
                                <option value="red">🔴 Red - Urgent</option>
                            </select>
                        </div>
                        
                        <div>
                            <label class="block text-desert-sand/70 text-sm mb-1">Time</label>
                            <input type="time" name="reminders[${index}][time]" value="09:00" class="w-full bg-papyrus-dark border border-ra-gold/30 text-desert-sand rounded-lg px-3 py-2 text-sm">
                        </div>
                        
                        <div>
                            <label class="block text-desert-sand/70 text-sm mb-1">Schedule</label>
                            <select name="reminders[${index}][schedule_type]" class="reminder-schedule w-full bg-papyrus-dark border border-ra-gold/30 text-desert-sand rounded-lg px-3 py-2 text-sm" onchange="updateReminderSchedule(${index})">
                                <option value="daily">Daily</option>
                                <option value="weekly">Weekly</option>
                            </select>
                        </div>
                        
                        <div id="reminder-${index}-schedule-options">
                            <div id="reminder-${index}-days-before" class="mb-2">
                                <label class="block text-desert-sand/70 text-sm mb-1">Days Before Due</label>
                                <input type="number" name="reminders[${index}][days_before]" min="0" value="1" class="w-full bg-papyrus-dark border border-ra-gold/30 text-desert-sand rounded-lg px-3 py-2 text-sm" onchange="updateReminderTimeOptions(${index})">
                            </div>
                            <div id="reminder-${index}-hours-before" class="hidden">
                                <label class="block text-desert-sand/70 text-sm mb-1">Hours Before Due (for same/near days)</label>
                                <input type="number" name="reminders[${index}][hours_before]" min="0" max="48" placeholder="e.g., 2" class="w-full bg-papyrus-dark border border-ra-gold/30 text-desert-sand rounded-lg px-3 py-2 text-sm">
                                <p class="text-xs text-desert-sand/50 mt-1">Use hours for reminders on the same day or within 2 days</p>
                            </div>
                        </div>
                    </div>
                    
                    <div id="reminder-${index}-weekly-days" class="hidden mt-3">
                        <label class="block text-desert-sand/70 text-sm mb-2">Days of Week</label>
                        <div class="flex flex-wrap gap-2">
                            <label class="flex items-center gap-1 text-sm text-desert-sand">
                                <input type="checkbox" name="reminders[${index}][days][]" value="1" class="rounded border-ra-gold text-ra-gold"> Mon
                            </label>
                            <label class="flex items-center gap-1 text-sm text-desert-sand">
                                <input type="checkbox" name="reminders[${index}][days][]" value="2" class="rounded border-ra-gold text-ra-gold"> Tue
                            </label>
                            <label class="flex items-center gap-1 text-sm text-desert-sand">
                                <input type="checkbox" name="reminders[${index}][days][]" value="3" class="rounded border-ra-gold text-ra-gold"> Wed
                            </label>
                            <label class="flex items-center gap-1 text-sm text-desert-sand">
                                <input type="checkbox" name="reminders[${index}][days][]" value="4" class="rounded border-ra-gold text-ra-gold"> Thu
                            </label>
                            <label class="flex items-center gap-1 text-sm text-desert-sand">
                                <input type="checkbox" name="reminders[${index}][days][]" value="5" class="rounded border-ra-gold text-ra-gold"> Fri
                            </label>
                            <label class="flex items-center gap-1 text-sm text-desert-sand">
                                <input type="checkbox" name="reminders[${index}][days][]" value="6" class="rounded border-ra-gold text-ra-gold"> Sat
                            </label>
                            <label class="flex items-center gap-1 text-sm text-desert-sand">
                                <input type="checkbox" name="reminders[${index}][days][]" value="0" class="rounded border-ra-gold text-ra-gold"> Sun
                            </label>
                        </div>
                    </div>
                </div>
            `;
            
            container.insertAdjacentHTML('beforeend', reminderHtml);
            updateReminderSchedule(index);
            updateReminderTimeOptions(index);
        }

        function removeReminder(index) {
            const item = document.querySelector(`.reminder-item[data-index="${index}"]`);
            if (item) {
                item.remove();
            }
        }

        function updateReminderSchedule(index) {
            const scheduleSelect = document.querySelector(`.reminder-item[data-index="${index}"] .reminder-schedule`);
            const scheduleOptions = document.getElementById(`reminder-${index}-schedule-options`);
            const weeklyDays = document.getElementById(`reminder-${index}-weekly-days`);
            
            if (scheduleSelect.value === 'weekly') {
                scheduleOptions.classList.add('hidden');
                weeklyDays.classList.remove('hidden');
            } else {
                scheduleOptions.classList.remove('hidden');
                weeklyDays.classList.add('hidden');
                updateReminderTimeOptions(index);
            }
        }

        function updateReminderTimeOptions(index) {
            const dueDateInput = document.getElementById('due_date');
            const daysBeforeInput = document.querySelector(`.reminder-item[data-index="${index}"] input[name="reminders[${index}][days_before]"]`);
            const hoursBeforeDiv = document.getElementById(`reminder-${index}-hours-before`);
            
            if (!dueDateInput.value || !daysBeforeInput || !hoursBeforeDiv) {
                return;
            }
            
            const dueDate = new Date(dueDateInput.value);
            const now = new Date();
            const daysBefore = parseInt(daysBeforeInput.value) || 0;
            
            // Calculate if the reminder is for same day or within 2 days
            const reminderDate = new Date(dueDate);
            reminderDate.setDate(reminderDate.getDate() - daysBefore);
            
            const daysDiff = Math.ceil((reminderDate - now) / (1000 * 60 * 60 * 24));
            const isSameDay = daysDiff === 0;
            const isNearDays = daysDiff >= 0 && daysDiff <= 2;
            
            // Show hours_before option if same day or near days
            if ((isSameDay || isNearDays) && daysBefore <= 2) {
                hoursBeforeDiv.classList.remove('hidden');
            } else {
                hoursBeforeDiv.classList.add('hidden');
            }
        }

        function updateReminderOptions() {
            const dueDateInput = document.getElementById('due_date');
            
            if (!dueDateInput.value) {
                return;
            }
            
            // Update all existing reminders
            document.querySelectorAll('.reminder-item').forEach(item => {
                const index = item.getAttribute('data-index');
                if (index !== null) {
                    updateReminderTimeOptions(parseInt(index));
                }
            });
        }
    </script>
</x-app-layout>
