<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold flex items-center gap-3">
                <span class="text-4xl">📜</span>
                <span>Quest Scroll Details</span>
            </h2>
            <div class="flex gap-2">
                <a href="{{ route('tasks.edit', $task) }}" class="bg-ra-gold/20 hover:bg-ra-gold/30 border border-ra-gold text-ra-gold font-bold py-2 px-4 rounded-lg transition-all duration-300">
                    Edit
                </a>
                <a href="{{ route('tasks.index') }}" class="bg-papyrus-dark hover:bg-shadow-ink border border-ra-gold/30 text-desert-sand font-bold py-2 px-4 rounded-lg transition-all duration-300">
                    Back
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-4xl mx-auto sm:px-6 lg:px-8 space-y-6">
            @if(session('success'))
                <div class="quest-card bg-gradient-to-r from-ra-gold/20 to-nile-turquoise/20 border-nile-turquoise">
                    <span class="block text-desert-sand font-egyptian">{{ session('success') }}</span>
                </div>
            @endif

            <!-- Quest Info - Scroll Design -->
            <div class="quest-card">
                <div class="flex justify-between items-start mb-6">
                    <div>
                        <h1 class="font-egyptian text-4xl text-ra-gold text-shadow-gold mb-4">{{ $task->title }}</h1>
                        <div class="flex items-center gap-4 text-sm text-desert-sand flex-wrap">
                            <span>📜 Scroll: <span class="text-nile-turquoise font-semibold">{{ $task->category->name }}</span></span>
                            <span>✨ Divine Energy: <span class="text-nile-turquoise font-stat font-semibold">{{ $task->points }}</span></span>
                            @if($task->coins > 0)
                            <span>💰 Coins: <span class="text-ra-gold font-stat font-semibold">{{ $task->coins }}</span></span>
                            @endif
                            @if($task->difficulty_level)
                            <span>⚔️ Difficulty: <span class="text-nile-turquoise font-semibold capitalize">{{ $task->difficulty_level }}</span></span>
                            @endif
                            <span class="px-3 py-1 rounded-full border-2
                                {{ $task->status === 'completed' ? 'bg-green-900/30 border-green-500 text-green-300' : '' }}
                                {{ $task->status === 'pending' ? 'bg-ra-gold/20 border-ra-gold text-ra-gold' : '' }}
                                {{ $task->status === 'skipped' ? 'bg-gray-700/30 border-gray-500 text-gray-300' : '' }}">
                                {{ ucfirst($task->status) }}
                            </span>
                        </div>
                    </div>
                    @if($task->status !== 'completed')
                    <form method="POST" action="{{ route('tasks.complete', $task) }}">
                        @csrf
                        <button type="submit" class="cartouche-button bg-gradient-to-r from-ra-gold to-yellow-500 hover:from-yellow-500 hover:to-ra-gold">
                            Complete Quest
                        </button>
                    </form>
                    @endif
                </div>

                @if($task->description)
                <div class="mb-6 p-4 bg-papyrus-dark/50 rounded-lg border border-ra-gold/30">
                    <p class="text-desert-sand leading-relaxed">{{ $task->description }}</p>
                </div>
                @endif

                <div class="grid grid-cols-2 md:grid-cols-4 gap-4 text-sm">
                    @if($task->difficulty_level)
                    <div class="p-3 bg-papyrus-dark/50 rounded border border-ra-gold/30">
                        <span class="text-desert-sand/70 block mb-1">⚔️ Difficulty:</span>
                        <span class="text-desert-sand font-semibold capitalize">{{ $task->difficulty_level }}</span>
                    </div>
                    @endif
                    @if($task->coins > 0)
                    <div class="p-3 bg-papyrus-dark/50 rounded border border-ra-gold/30">
                        <span class="text-desert-sand/70 block mb-1">💰 Coins:</span>
                        <span class="text-ra-gold font-semibold">{{ $task->coins }}</span>
                    </div>
                    @endif
                    @if($task->due_date)
                    <div class="p-3 bg-papyrus-dark/50 rounded border border-ra-gold/30">
                        <span class="text-desert-sand/70 block mb-1">⏳ Due Date:</span>
                        <span class="text-desert-sand font-semibold">{{ $task->due_date->format('M d, Y H:i') }}</span>
                    </div>
                    @endif

                    @if($task->completed_at)
                    <div class="p-3 bg-green-900/20 rounded border border-green-500/30">
                        <span class="text-green-300/70 block mb-1">✨ Completed:</span>
                        <span class="text-green-300 font-semibold">{{ $task->completed_at->format('M d, Y H:i') }}</span>
                    </div>
                    @endif
                </div>
            </div>

            <!-- Reminders -->
            @if($task->reminders->count() > 0)
            <div class="quest-card">
                <h3 class="font-egyptian text-2xl text-ra-gold mb-4">🔔 Reminders</h3>
                <div class="space-y-3">
                    @foreach($task->reminders as $reminder)
                    <div class="p-4 rounded-lg border-2 {{ $reminder->getColorClass() }}">
                        <div class="flex items-start justify-between">
                            <div class="flex-1">
                                <div class="flex items-center gap-2 mb-2">
                                    <span class="font-semibold">{{ $reminder->getTypeLabel() }}</span>
                                    @if($reminder->schedule_type === 'weekly')
                                        <span class="text-xs text-desert-sand/70">
                                            @php
                                                $days = $reminder->schedule_data['days'] ?? [];
                                                $dayNames = ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'];
                                                $selectedDays = array_map(fn($d) => $dayNames[$d], $days);
                                            @endphp
                                            Weekly on {{ implode(', ', $selectedDays) }}
                                        </span>
                                    @elseif($reminder->schedule_type === 'daily')
                                        @if($reminder->hours_before !== null)
                                            <span class="text-xs text-desert-sand/70">{{ $reminder->hours_before }} hour(s) before due</span>
                                            @if($reminder->days_before !== null)
                                                <span class="text-xs text-desert-sand/70"> ({{ $reminder->days_before }} day(s) before)</span>
                                            @endif
                                        @elseif($reminder->days_before !== null)
                                            <span class="text-xs text-desert-sand/70">{{ $reminder->days_before }} day(s) before due</span>
                                        @else
                                            <span class="text-xs text-desert-sand/70">Daily</span>
                                        @endif
                                    @endif
                                </div>
                                <div class="text-sm text-desert-sand/70">
                                    <span>⏰ Time: {{ \Carbon\Carbon::parse($reminder->reminder_time)->format('g:i A') }}</span>
                                    @if($reminder->sent_count > 0)
                                        <span class="ml-3">Sent: {{ $reminder->sent_count }} time(s)</span>
                                    @endif
                                    @if($reminder->last_sent_at)
                                        <span class="ml-3">Last: {{ $reminder->last_sent_at->diffForHumans() }}</span>
                                    @endif
                                </div>
                            </div>
                            <div class="flex items-center gap-2">
                                @if($reminder->is_active)
                                    <span class="px-2 py-1 text-xs rounded bg-green-900/30 text-green-300 border border-green-500">Active</span>
                                @else
                                    <span class="px-2 py-1 text-xs rounded bg-gray-900/30 text-gray-300 border border-gray-500">Inactive</span>
                                @endif
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
            @endif

            <!-- Checklist -->
            <div class="quest-card">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="font-egyptian text-2xl text-ra-gold">Quest Checklist</h3>
                    <button onclick="document.getElementById('checklist-form').classList.toggle('hidden')" 
                            class="bg-nile-turquoise/20 hover:bg-nile-turquoise/30 border border-nile-turquoise text-nile-turquoise font-bold py-2 px-4 rounded-lg text-sm transition-all duration-300">
                        Add Item
                    </button>
                </div>

                <form id="checklist-form" method="POST" action="{{ route('tasks.checklists.store', $task) }}" class="hidden mb-4">
                    @csrf
                    <div class="flex gap-2">
                        <input type="text" name="title" placeholder="Checklist item..." 
                            class="flex-1 bg-papyrus-dark border-2 border-ra-gold/30 text-desert-sand rounded-lg px-4 py-2 focus:border-ra-gold focus:ring-2 focus:ring-ra-gold/50" 
                            required>
                        <button type="submit" class="cartouche-button">
                            Add
                        </button>
                    </div>
                </form>

                <div class="space-y-2">
                    @forelse($task->checklists as $checklist)
                    <div class="flex items-center gap-3 p-3 bg-papyrus-dark/50 hover:bg-papyrus-dark rounded-lg border border-ra-gold/20 transition-all duration-300">
                        <form method="POST" action="{{ route('tasks.checklists.toggle', [$task, $checklist]) }}" class="inline">
                            @csrf
                            <input type="checkbox" {{ $checklist->completed ? 'checked' : '' }} 
                                onchange="this.form.submit()" 
                                class="rounded border-ra-gold text-ra-gold focus:ring-ra-gold">
                        </form>
                        <span class="flex-1 text-desert-sand {{ $checklist->completed ? 'line-through text-desert-sand/50' : '' }}">
                            {{ $checklist->title }}
                        </span>
                        <form method="POST" action="{{ route('tasks.checklists.destroy', [$task, $checklist]) }}" class="inline" 
                            onsubmit="return confirm('Delete this checklist item?')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="text-blood-red hover:text-blood-red/70">Delete</button>
                        </form>
                    </div>
                    @empty
                    <p class="text-desert-sand/70 italic">No checklist items yet. Add one above!</p>
                    @endforelse
                </div>
            </div>

            <!-- Comments -->
            <div class="quest-card">
                <h3 class="font-egyptian text-2xl text-ra-gold mb-4">Hieroglyphic Notes</h3>

                <form method="POST" action="{{ route('tasks.comments.store', $task) }}" class="mb-6">
                    @csrf
                    <div class="flex gap-2">
                        <textarea name="text" placeholder="Add a note..." 
                            class="flex-1 bg-papyrus-dark border-2 border-ra-gold/30 text-desert-sand rounded-lg px-4 py-2 focus:border-ra-gold focus:ring-2 focus:ring-ra-gold/50" 
                            rows="2" required></textarea>
                        <button type="submit" class="cartouche-button self-start">
                            Post
                        </button>
                    </div>
                </form>

                <div class="space-y-4">
                    @forelse($task->comments as $comment)
                    <div class="border-l-4 border-nile-turquoise pl-4 py-2 bg-papyrus-dark/30 rounded-r-lg">
                        <div class="flex justify-between items-start mb-1">
                            <span class="font-egyptian text-ra-gold font-semibold">{{ $comment->user->name }}</span>
                            <span class="text-xs text-desert-sand/70">{{ $comment->created_at->diffForHumans() }}</span>
                        </div>
                        <p class="text-desert-sand mt-1">{{ $comment->text }}</p>
                        @if($comment->user_id === auth()->id() || auth()->user()->is_admin)
                        <form method="POST" action="{{ route('tasks.comments.destroy', [$task, $comment]) }}" class="mt-2" 
                            onsubmit="return confirm('Delete this comment?')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="text-blood-red hover:text-blood-red/70 text-sm">Delete</button>
                        </form>
                        @endif
                    </div>
                    @empty
                    <p class="text-desert-sand/70 italic">No notes yet. Be the first to comment!</p>
                    @endforelse
                </div>
            </div>

            <!-- Images -->
            <div class="quest-card">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="font-egyptian text-2xl text-ra-gold">Quest Images</h3>
                    <form method="POST" action="{{ route('tasks.images.store', $task) }}" enctype="multipart/form-data" class="inline">
                        @csrf
                        <input type="file" name="image" accept="image/*" required onchange="this.form.submit()" class="hidden" id="image-upload">
                        <label for="image-upload" class="cartouche-button cursor-pointer inline-block">
                            Upload Image
                        </label>
                    </form>
                </div>

                <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                    @forelse($task->images as $image)
                    <div class="relative group">
                        <img src="{{ asset('storage/' . $image->path) }}" alt="{{ $image->original_name }}" 
                            class="w-full h-32 object-cover rounded-lg border-2 border-ra-gold/30 hover:border-ra-gold transition-all duration-300">
                        <form method="POST" action="{{ route('tasks.images.destroy', [$task, $image]) }}" 
                            onsubmit="return confirm('Delete this image?')" 
                            class="absolute top-2 right-2 opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="bg-blood-red text-white px-2 py-1 rounded text-xs hover:bg-blood-red/80">×</button>
                        </form>
                    </div>
                    @empty
                    <p class="text-desert-sand/70 italic col-span-full">No images yet.</p>
                    @endforelse
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
