<?php

use App\Http\Controllers\Api\BattleController;
use App\Http\Controllers\Api\MobController;
use App\Http\Controllers\Api\ShopController;
use App\Http\Controllers\Api\QuestController;
use Illuminate\Support\Facades\Route;

Route::middleware('auth:sanctum')->group(function () {
    // Battle routes
    Route::post('/battle/start', [BattleController::class, 'start']);
    Route::post('/battle/turn', [BattleController::class, 'turn']);
    Route::get('/battle/result/{battle_id}', [BattleController::class, 'result']);
    Route::get('/battle/{battle_id}', [BattleController::class, 'show']);
    
    // Mob routes
    Route::get('/mobs', [MobController::class, 'index']);
    Route::get('/mobs/{id}', [MobController::class, 'show']);
    Route::get('/mobs/for-level/{level}', [MobController::class, 'forLevel']);
    
    // Shop routes
    Route::get('/shop/items', [ShopController::class, 'index']);
    Route::post('/shop/buy', [ShopController::class, 'buy']);
    Route::get('/shop/items/{id}', [ShopController::class, 'show']);
    
    // Quest routes
    Route::get('/quests', [QuestController::class, 'index']);
});

