<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\TaskController;
use App\Http\Controllers\TaskChecklistController;
use App\Http\Controllers\TaskCommentController;
use App\Http\Controllers\TaskImageController;
use App\Http\Controllers\ShopController;
use App\Http\Controllers\InventoryController;
use App\Http\Controllers\BattleController;
use App\Http\Controllers\MembershipController;
use App\Http\Controllers\RewardController;
use App\Http\Controllers\CoinsController;
use App\Http\Controllers\WebhookController;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return redirect()->route('dashboard');
});

Route::get('/dashboard', [DashboardController::class, 'index'])
    ->middleware(['auth', 'verified'])
    ->name('dashboard');

Route::middleware('auth')->group(function () {
    // Profile routes
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    // Categories (Quest Scrolls)
    Route::resource('categories', CategoryController::class);

    // Tasks - Define specific routes BEFORE resource route
    Route::get('/tasks/completed', [TaskController::class, 'completed'])->name('tasks.completed');
    Route::post('/tasks/{task}/complete', [TaskController::class, 'complete'])->name('tasks.complete');
    Route::resource('tasks', TaskController::class);

    // Task Checklists
    Route::post('/tasks/{task}/checklists', [TaskChecklistController::class, 'store'])->name('tasks.checklists.store');
    Route::put('/tasks/{task}/checklists/{checklist}', [TaskChecklistController::class, 'update'])->name('tasks.checklists.update');
    Route::post('/tasks/{task}/checklists/{checklist}/toggle', [TaskChecklistController::class, 'toggle'])->name('tasks.checklists.toggle');
    Route::delete('/tasks/{task}/checklists/{checklist}', [TaskChecklistController::class, 'destroy'])->name('tasks.checklists.destroy');

    // Task Comments
    Route::post('/tasks/{task}/comments', [TaskCommentController::class, 'store'])->name('tasks.comments.store');
    Route::delete('/tasks/{task}/comments/{comment}', [TaskCommentController::class, 'destroy'])->name('tasks.comments.destroy');

    // Task Images
    Route::post('/tasks/{task}/images', [TaskImageController::class, 'store'])->name('tasks.images.store');
    Route::delete('/tasks/{task}/images/{image}', [TaskImageController::class, 'destroy'])->name('tasks.images.destroy');

    // Shop
    Route::get('/shop', [ShopController::class, 'index'])->name('shop.index');
    Route::post('/shop/purchase/{item}', [ShopController::class, 'purchase'])->name('shop.purchase');

    // Inventory
    Route::get('/inventory', [InventoryController::class, 'index'])->name('inventory.index');
    Route::post('/inventory/{userItem}/equip', [InventoryController::class, 'equip'])->name('inventory.equip');
    Route::post('/inventory/{userItem}/unequip', [InventoryController::class, 'unequip'])->name('inventory.unequip');

    // Characters
    Route::get('/characters', [\App\Http\Controllers\CharacterController::class, 'index'])->name('characters.index');
    Route::get('/characters/test-animations', [\App\Http\Controllers\CharacterController::class, 'testAnimations'])->name('characters.test-animations');
    Route::get('/characters/test-fight', [\App\Http\Controllers\CharacterController::class, 'testFight'])->name('characters.test-fight');
    Route::get('/characters/arena-fight', [\App\Http\Controllers\CharacterController::class, 'arenaFight'])->name('characters.arena-fight');
    Route::get('/characters/arena-fight-2', [\App\Http\Controllers\CharacterController::class, 'arenaFight2'])->name('characters.arena-fight-2');
    Route::get('/characters/arena-3', [\App\Http\Controllers\CharacterController::class, 'arenaFight3'])->name('characters.arena-3');
    Route::post('/characters/arena-victory', [\App\Http\Controllers\CharacterController::class, 'arenaVictory'])->name('characters.arena-victory');
    Route::post('/characters/{character}/purchase', [\App\Http\Controllers\CharacterController::class, 'purchase'])->name('characters.purchase');
    Route::post('/characters/{character}/equip', [\App\Http\Controllers\CharacterController::class, 'equip'])->name('characters.equip');
    Route::post('/characters/unequip', [\App\Http\Controllers\CharacterController::class, 'unequip'])->name('characters.unequip');

    // Battle
    Route::get('/battle', [BattleController::class, 'index'])->name('battle.index');
    Route::post('/battle/{mobId}/start', [BattleController::class, 'start'])->name('battle.start');
    Route::get('/battle/{battle}', [BattleController::class, 'show'])->name('battle.show');
    Route::post('/battle/{battle}/attack', [BattleController::class, 'attack'])->name('battle.attack');
    Route::get('/battle/history', [BattleController::class, 'history'])->name('battle.history');

    // Membership
    Route::get('/membership/plans', [MembershipController::class, 'plans'])->name('membership.plans');
    Route::post('/vip/subscribe', [MembershipController::class, 'subscribe'])->name('vip.subscribe');
    Route::get('/vip/success', [MembershipController::class, 'vipSuccess'])->name('vip.success');
    Route::get('/vip/cancel', [MembershipController::class, 'vipCancel'])->name('vip.cancel');
    Route::post('/membership/cancel', [MembershipController::class, 'cancel'])->name('membership.cancel');
    Route::get('/membership/status', [MembershipController::class, 'status'])->name('membership.status');

    // Coin Pack Payments
    Route::get('/coins', [CoinsController::class, 'index'])->name('coins.index');
    Route::post('/coins/buy', [CoinsController::class, 'buy'])->name('coins.buy');
    Route::get('/coins/success', [CoinsController::class, 'success'])->name('coins.success');
    Route::get('/coins/cancel', [CoinsController::class, 'cancel'])->name('coins.cancel');

    // Rewards
    Route::post('/rewards/daily-vip', [RewardController::class, 'claimDailyVipRewards'])->name('rewards.daily-vip');

    // Shop updates
    Route::post('/shop/premium/{item}', [ShopController::class, 'buyPremiumItem'])->name('shop.premium.purchase');

    // Admin Routes
    Route::middleware('admin')->prefix('admin')->name('admin.')->group(function () {
        Route::get('/', [\App\Http\Controllers\Admin\AdminController::class, 'index'])->name('dashboard');
        Route::get('/users', [\App\Http\Controllers\Admin\AdminController::class, 'users'])->name('users');
        Route::post('/users/{user}/toggle-admin', [\App\Http\Controllers\Admin\AdminController::class, 'toggleAdmin'])->name('users.toggle-admin');
        
        Route::resource('items', \App\Http\Controllers\Admin\ItemController::class);
        Route::resource('enemies', \App\Http\Controllers\Admin\EnemyController::class);
        Route::resource('mobs', \App\Http\Controllers\Admin\MobController::class);
        Route::resource('characters', \App\Http\Controllers\Admin\CharacterController::class);
        Route::resource('arena3-backgrounds', \App\Http\Controllers\Admin\Arena3BackgroundController::class);
        Route::get('arena3-logs', [\App\Http\Controllers\Admin\Arena3LogsController::class, 'index'])->name('arena3-logs.index');
    });
});

// Webhooks (no auth middleware)
Route::post('/webhook/paypal', [WebhookController::class, 'paypal'])->name('webhook.paypal');

require __DIR__.'/auth.php';
