<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex justify-between items-center">
            <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold">
                <?php echo e(__('Enemy Management')); ?>

            </h2>
            <div class="flex gap-2">
                <a href="<?php echo e(route('admin.enemies.create')); ?>" class="cartouche-button bg-gradient-to-r from-blood-red to-red-700">
                    New Enemy
                </a>
                <a href="<?php echo e(route('admin.dashboard')); ?>" class="cartouche-button">
                    Back
                </a>
            </div>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <?php if(session('success')): ?>
                <div class="quest-card bg-gradient-to-r from-nile-turquoise/20 to-green-500/20 border-nile-turquoise mb-6">
                    <span class="block text-desert-sand font-egyptian"><?php echo e(session('success')); ?></span>
                </div>
            <?php endif; ?>

            <div class="quest-card">
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-ra-gold/30">
                        <thead>
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Name</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Level</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Stats</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">HP</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Rewards</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Drop Item</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-ra-gold/20">
                            <?php $__empty_1 = true; $__currentLoopData = $enemies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $enemy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="hover:bg-papyrus-dark/50 transition-colors">
                                <td class="px-6 py-4 whitespace-nowrap text-desert-sand"><?php echo e($enemy->name); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-nile-turquoise font-stat"><?php echo e($enemy->level); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-desert-sand">
                                    ⚔️ <?php echo e($enemy->attack); ?> 🛡️ <?php echo e($enemy->defense); ?>

                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-blood-red font-stat"><?php echo e($enemy->hp); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-desert-sand">
                                    XP: <span class="text-nile-turquoise"><?php echo e($enemy->xp_reward); ?></span><br>
                                    Gold: <span class="text-ra-gold"><?php echo e($enemy->gold_reward); ?></span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-desert-sand">
                                    <?php echo e($enemy->dropItem ? $enemy->dropItem->name : 'None'); ?>

                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="flex gap-2">
                                        <a href="<?php echo e(route('admin.enemies.edit', $enemy)); ?>" class="text-nile-turquoise hover:text-teal-300 text-sm transition-colors">Edit</a>
                                        <form method="POST" action="<?php echo e(route('admin.enemies.destroy', $enemy)); ?>" class="inline" 
                                            onsubmit="return confirm('Delete this enemy?')">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="text-blood-red hover:text-red-400 text-sm transition-colors">Delete</button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="px-6 py-4 text-center text-desert-sand">No enemies found.</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>

                    <div class="mt-4">
                        <?php echo e($enemies->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>

<?php /**PATH C:\laragon\www\quest-of-ra\resources\views/admin/enemies/index.blade.php ENDPATH**/ ?>