<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold flex items-center gap-3">
            <span class="text-4xl">👑</span>
            <span>Admin Temple</span>
        </h2>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-6">
            <?php if(session('success')): ?>
                <div class="quest-card bg-gradient-to-r from-ra-gold/20 to-nile-turquoise/20 border-nile-turquoise">
                    <span class="block text-desert-sand font-egyptian"><?php echo e(session('success')); ?></span>
                </div>
            <?php endif; ?>

            <!-- Stats Grid -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <div class="quest-card">
                    <h3 class="font-egyptian text-lg text-ra-gold mb-3">Users</h3>
                    <p class="font-stat text-3xl text-nile-turquoise mb-2"><?php echo e($totalUsers); ?></p>
                    <p class="text-sm text-desert-sand">Total Users</p>
                    <div class="mt-3 space-y-1 text-sm text-desert-sand">
                        <p><?php echo e($activeUsers); ?> active this week</p>
                        <p><?php echo e($totalAdmins); ?> admins</p>
                    </div>
                </div>

                <div class="quest-card">
                    <h3 class="font-egyptian text-lg text-ra-gold mb-3">Quests</h3>
                    <p class="font-stat text-3xl text-green-400 mb-2"><?php echo e($completedTasks); ?> / <?php echo e($totalTasks); ?></p>
                    <p class="text-sm text-desert-sand"><?php echo e(number_format($completionRate, 1)); ?>% Completion Rate</p>
                    <p class="text-sm text-desert-sand mt-3"><?php echo e($tasksToday); ?> completed today</p>
                </div>

                <div class="quest-card">
                    <h3 class="font-egyptian text-lg text-ra-gold mb-3">Battles</h3>
                    <p class="font-stat text-3xl text-blood-red mb-2"><?php echo e($totalBattles); ?></p>
                    <p class="text-sm text-desert-sand"><?php echo e(number_format($winRate, 1)); ?>% Win Rate</p>
                    <p class="text-sm text-desert-sand mt-3"><?php echo e($battlesWon); ?> victories</p>
                </div>
            </div>

            <!-- Game Stats -->
            <div class="quest-card">
                <h3 class="font-egyptian text-xl text-ra-gold mb-4">Average Game Stats</h3>
                <div class="grid grid-cols-3 gap-4">
                    <div class="text-center p-3 bg-papyrus-dark/50 rounded border border-nile-turquoise/30">
                        <div class="font-stat text-2xl text-nile-turquoise mb-1"><?php echo e(number_format($avgXP)); ?></div>
                        <div class="text-xs text-desert-sand">Average Divine Energy</div>
                    </div>
                    <div class="text-center p-3 bg-papyrus-dark/50 rounded border border-ra-gold/30">
                        <div class="font-stat text-2xl text-ra-gold mb-1"><?php echo e(number_format($avgGold)); ?></div>
                        <div class="text-xs text-desert-sand">Average Sacred Gold</div>
                    </div>
                    <div class="text-center p-3 bg-papyrus-dark/50 rounded border border-purple-400/30">
                        <div class="font-stat text-2xl text-purple-300 mb-1"><?php echo e(number_format($avgLevel, 1)); ?></div>
                        <div class="text-xs text-desert-sand">Average Rank</div>
                    </div>
                </div>
            </div>

            <!-- Leaderboard -->
            <div class="quest-card">
                <h3 class="font-egyptian text-xl text-ra-gold mb-4">Top Champions</h3>
                <div class="space-y-2">
                    <?php $__currentLoopData = $leaderboard; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="flex justify-between items-center p-3 bg-papyrus-dark/50 hover:bg-papyrus-dark rounded-lg border border-ra-gold/20 transition-all duration-300">
                        <div class="flex items-center gap-3">
                            <span class="font-egyptian text-ra-gold w-8">#<?php echo e($index + 1); ?></span>
                            <span class="text-desert-sand"><?php echo e($user->name); ?></span>
                        </div>
                        <div class="flex gap-4 text-sm">
                            <span class="font-stat text-nile-turquoise">Rank <?php echo e($user->level); ?></span>
                            <span class="text-desert-sand"><?php echo e(number_format($user->xp)); ?> ✨</span>
                            <span class="text-ra-gold">💰 <?php echo e(number_format($user->gold)); ?></span>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>

            <!-- Popular Items -->
            <?php if($popularItems->count() > 0): ?>
            <div class="quest-card">
                <h3 class="font-egyptian text-xl text-ra-gold mb-4">Most Popular Relics</h3>
                <div class="space-y-2">
                    <?php $__currentLoopData = $popularItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="flex justify-between items-center p-3 bg-papyrus-dark/50 hover:bg-papyrus-dark rounded-lg border border-ra-gold/20 transition-all duration-300">
                        <span class="text-desert-sand"><?php echo e($item->name); ?></span>
                        <span class="text-sm text-nile-turquoise font-stat"><?php echo e($item->user_items_count); ?> owners</span>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <?php endif; ?>

            <!-- Category Stats -->
            <?php if($categoryStats->count() > 0): ?>
            <div class="quest-card">
                <h3 class="font-egyptian text-xl text-ra-gold mb-4">Scroll Completion Rates</h3>
                <div class="space-y-3">
                    <?php $__currentLoopData = $categoryStats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div>
                        <div class="flex justify-between mb-1 text-desert-sand">
                            <span><?php echo e($cat->name); ?></span>
                            <span class="text-sm font-stat text-nile-turquoise"><?php echo e(number_format($cat->completion_rate, 1)); ?>%</span>
                        </div>
                        <div class="w-full bg-shadow-ink rounded-full h-3 border border-ra-gold/30 overflow-hidden">
                            <div class="bg-gradient-to-r from-nile-turquoise to-teal-400 h-3 rounded-full transition-all duration-500" style="width: <?php echo e(min(100, $cat->completion_rate)); ?>%"></div>
                        </div>
                        <div class="text-xs text-desert-sand/70 mt-1">
                            <?php echo e($cat->completed_tasks); ?> / <?php echo e($cat->total_tasks); ?> quests
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <?php endif; ?>

            <!-- Quick Links -->
            <div class="quest-card">
                <h3 class="font-egyptian text-xl text-ra-gold mb-4">Admin Actions</h3>
                <div class="grid grid-cols-2 md:grid-cols-6 gap-4">
                    <a href="<?php echo e(route('admin.users')); ?>" class="cartouche-button text-center">
                        Manage Users
                    </a>
                    <a href="<?php echo e(route('admin.items.index')); ?>" class="cartouche-button bg-gradient-to-r from-nile-turquoise to-teal-500 text-center">
                        Manage Relics
                    </a>
                    <a href="<?php echo e(route('admin.enemies.index')); ?>" class="cartouche-button bg-gradient-to-r from-blood-red to-red-700 text-center">
                        Manage Foes
                    </a>
                    <a href="<?php echo e(route('admin.mobs.index')); ?>" class="cartouche-button bg-gradient-to-r from-purple-600 to-purple-800 text-center">
                        Manage Mobs
                    </a>
                    <a href="<?php echo e(route('admin.characters.index')); ?>" class="cartouche-button bg-gradient-to-r from-ra-gold to-yellow-600 text-center">
                        Manage Characters
                    </a>
                    <a href="<?php echo e(route('admin.arena3-backgrounds.index')); ?>" class="cartouche-button bg-gradient-to-r from-green-600 to-emerald-700 text-white text-center hover:from-green-700 hover:to-emerald-800">
                        Arena 3 Backgrounds
                    </a>
                    <a href="<?php echo e(route('admin.arena3-logs.index')); ?>" class="cartouche-button bg-gradient-to-r from-purple-600 to-indigo-700 text-center">
                        Arena 3 Logs
                    </a>
                    <a href="<?php echo e(route('dashboard')); ?>" class="bg-papyrus-dark hover:bg-shadow-ink border-2 border-ra-gold/30 text-desert-sand font-bold py-2 px-4 rounded-lg text-center transition-all duration-300">
                        User Temple
                    </a>
                </div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\laragon\www\quest-of-ra\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>