<?php
use Illuminate\Support\Facades\Storage;
?>
<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex justify-between items-center">
            <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold">
                <?php echo e(__('Arena 3 Backgrounds')); ?>

            </h2>
            <div class="flex gap-2">
                <a href="<?php echo e(route('admin.arena3-backgrounds.create')); ?>" class="cartouche-button bg-gradient-to-r from-ra-gold to-yellow-600">
                    New Background
                </a>
                <a href="<?php echo e(route('admin.dashboard')); ?>" class="cartouche-button">
                    Back
                </a>
            </div>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <?php if(session('success')): ?>
                <div class="quest-card bg-gradient-to-r from-nile-turquoise/20 to-green-500/20 border-nile-turquoise mb-6">
                    <span class="block text-desert-sand font-egyptian"><?php echo e(session('success')); ?></span>
                </div>
            <?php endif; ?>

            <div class="quest-card">
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-ra-gold/30">
                        <thead>
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Preview</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Name</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Unlock</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Cost</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Status</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-ra-gold/20">
                            <?php $__empty_1 = true; $__currentLoopData = $backgrounds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $background): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="hover:bg-papyrus-dark/50 transition-colors">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <?php if($background->image_path): ?>
                                        <img src="<?php echo e(Storage::url($background->image_path)); ?>" alt="<?php echo e($background->name); ?>" class="w-24 h-16 object-cover rounded border border-ra-gold/30">
                                    <?php else: ?>
                                        <div class="w-24 h-16 bg-papyrus-dark border border-ra-gold/30 rounded flex items-center justify-center text-xs text-desert-sand/50">No Image</div>
                                    <?php endif; ?>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm font-egyptian text-desert-sand"><?php echo e($background->name); ?></div>
                                    <?php if($background->is_default): ?>
                                        <span class="text-xs text-ra-gold">⭐ Default</span>
                                    <?php endif; ?>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-desert-sand">
                                    <?php if($background->unlock_level): ?>
                                        Level <?php echo e($background->unlock_level); ?>

                                    <?php else: ?>
                                        <span class="text-desert-sand/70">Shop Only</span>
                                    <?php endif; ?>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-desert-sand">
                                    <?php if($background->cost_gold): ?>
                                        <span class="text-yellow-400">💰 <?php echo e(number_format($background->cost_gold)); ?> Gold</span>
                                    <?php endif; ?>
                                    <?php if($background->cost_premium): ?>
                                        <?php if($background->cost_gold): ?> <br> <?php endif; ?>
                                        <span class="text-purple-400">💎 <?php echo e(number_format($background->cost_premium)); ?> Premium</span>
                                    <?php endif; ?>
                                    <?php if(!$background->cost_gold && !$background->cost_premium): ?>
                                        <span class="text-green-400">Free</span>
                                    <?php endif; ?>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <?php if($background->is_active): ?>
                                        <span class="px-2 py-1 text-xs rounded bg-green-500/20 text-green-400 border border-green-500/30">Active</span>
                                    <?php else: ?>
                                        <span class="px-2 py-1 text-xs rounded bg-red-500/20 text-red-400 border border-red-500/30">Inactive</span>
                                    <?php endif; ?>
                                    <?php if($background->is_vip_only): ?>
                                        <span class="px-2 py-1 text-xs rounded bg-purple-500/20 text-purple-400 border border-purple-500/30 mt-1 block">VIP Only</span>
                                    <?php endif; ?>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                    <div class="flex gap-2">
                                        <a href="<?php echo e(route('admin.arena3-backgrounds.edit', $background)); ?>" class="text-nile-turquoise hover:text-nile-turquoise/80">Edit</a>
                                        <form method="POST" action="<?php echo e(route('admin.arena3-backgrounds.destroy', $background)); ?>" class="inline" onsubmit="return confirm('Are you sure you want to delete this background?');">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="text-blood-red hover:text-blood-red/80">Delete</button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" class="px-6 py-4 text-center text-desert-sand">
                                    No backgrounds found. <a href="<?php echo e(route('admin.arena3-backgrounds.create')); ?>" class="text-ra-gold hover:underline">Create one</a>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <div class="mt-4">
                    <?php echo e($backgrounds->links()); ?>

                </div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>

<?php /**PATH C:\laragon\www\quest-of-ra\resources\views/admin/arena3-backgrounds/index.blade.php ENDPATH**/ ?>