<?php if(auth()->guard()->check()): ?>
<?php
    $user = Auth::user()->load('character');
    $battleService = app(\App\Services\BattleService::class);
    $gameService = app(\App\Services\GameService::class);
    
    // Get user stats
    $totalStats = $gameService->getUserTotalStats($user);
    
    // Calculate battle cooldown
    $canBattle = $battleService->canStartBattle($user);
    $cooldownRemaining = 0;
    $cooldownUntil = null;
    
    if (!$canBattle && $user->last_battle_at) {
        $cooldownSeconds = $battleService->getBattleCooldown($user);
        $cooldownUntil = $user->last_battle_at->copy()->addSeconds($cooldownSeconds);
        $now = now();
        if ($now->lessThan($cooldownUntil)) {
            $cooldownRemaining = $now->diffInSeconds($cooldownUntil);
        } else {
            $cooldownRemaining = 0;
        }
    }
    
    // Get current HP
    $currentHP = $user->current_hp ?? $totalStats['hp'];
    $maxHP = $totalStats['hp'];
    $hpPercent = $maxHP > 0 ? min(100, max(0, ($currentHP / $maxHP) * 100)) : 0;
    
    // Calculate total power (attack + defense + hp + stamina)
    $totalPower = ($totalStats['attack'] ?? 0) + ($totalStats['defense'] ?? 0) + ($totalStats['hp'] ?? 0) + ($totalStats['stamina'] ?? 0);
    
    // Calculate HP regen countdown
    $hpRegenCountdown = 60; // Default 60 seconds
    if ($user->last_hp_regen_at) {
        $lastHpRegen = $user->last_hp_regen_at instanceof \Carbon\Carbon 
            ? $user->last_hp_regen_at 
            : \Carbon\Carbon::parse($user->last_hp_regen_at);
        $secondsSinceRegen = now()->diffInSeconds($lastHpRegen);
        $hpRegenCountdown = max(0, 60 - $secondsSinceRegen);
    }
    $nextHpRegenAt = $user->last_hp_regen_at 
        ? (\Carbon\Carbon::parse($user->last_hp_regen_at)->addMinute()->timestamp) 
        : (now()->addMinute()->timestamp);
?>

<div x-data="{
    cooldownRemaining: <?php echo e($cooldownRemaining); ?>,
    canBattle: <?php echo e($canBattle ? 'true' : 'false'); ?>,
    cooldownUntil: <?php echo e($cooldownUntil ? $cooldownUntil->timestamp : 'null'); ?>,
    hpRegenCountdown: <?php echo e($hpRegenCountdown); ?>,
    currentHP: <?php echo e($currentHP); ?>,
    maxHP: <?php echo e($maxHP); ?>,
    nextHpRegenAt: <?php echo e($nextHpRegenAt); ?>,
    hpPercent: <?php echo e($hpPercent); ?>,
    totalPower: <?php echo e($totalPower); ?>,
    userLevel: <?php echo e($user->level); ?>,
    init() {
        // Update cooldown timer
        if (this.cooldownUntil) {
            this.updateCooldown();
            setInterval(() => this.updateCooldown(), 1000);
        }
        
        // Update HP regen timer
        this.updateHpRegen();
        setInterval(() => this.updateHpRegen(), 1000);
    },
    updateCooldown() {
        if (this.cooldownUntil) {
            const now = Math.floor(Date.now() / 1000);
            const until = parseInt(this.cooldownUntil);
            this.cooldownRemaining = Math.max(0, until - now);
            if (this.cooldownRemaining <= 0) {
                this.canBattle = true;
                this.cooldownRemaining = 0;
                this.cooldownUntil = null;
            }
        }
    },
    updateHpRegen() {
        if (this.nextHpRegenAt) {
            const now = Math.floor(Date.now() / 1000);
            const until = parseInt(this.nextHpRegenAt);
            this.hpRegenCountdown = Math.max(0, until - now);
            
            // Check if HP should regenerate (every 60 seconds)
            if (this.hpRegenCountdown <= 0 && this.currentHP < this.maxHP) {
                this.currentHP = Math.min(this.maxHP, this.currentHP + 1);
                this.hpPercent = (this.currentHP / this.maxHP) * 100;
                this.nextHpRegenAt = now + 60; // Next regen in 60 seconds
                this.hpRegenCountdown = 60;
            }
        }
    },
    formatTime(seconds) {
        if (seconds <= 0) return 'Ready';
        const mins = Math.floor(seconds / 60);
        const secs = seconds % 60;
        return `${mins}:${secs.toString().padStart(2, '0')}`;
    }
}"
class="bg-gradient-to-r from-papyrus-dark via-shadow-ink to-papyrus-dark border-b-2 border-ra-gold shadow-gold-glow">
    <div class="px-4 sm:px-6 lg:px-8 py-2">
        <div class="flex flex-wrap items-center justify-between gap-4 text-sm">
            <!-- Left Side - Stats -->
            <div class="flex flex-wrap items-center gap-4">
                <!-- Power & Level (Prominent) -->
                <div class="flex items-center gap-3">
                    <div class="flex items-center gap-1 px-2 py-1 bg-ra-gold/20 border border-ra-gold/50 rounded">
                        <span class="text-desert-sand/70 text-xs">⚡</span>
                        <span class="font-stat text-ra-gold text-sm whitespace-nowrap" x-text="`Power: ${totalPower}`"></span>
                    </div>
                    <div class="flex items-center gap-1 px-2 py-1 bg-nile-turquoise/20 border border-nile-turquoise/50 rounded">
                        <span class="text-desert-sand/70 text-xs">⭐</span>
                        <span class="font-stat text-nile-turquoise text-sm whitespace-nowrap" x-text="`Rank ${userLevel}`"></span>
                    </div>
                </div>

                <!-- HP Bar (Small) -->
                <div class="flex items-center gap-2">
                    <span class="text-desert-sand/70 text-xs whitespace-nowrap">❤️</span>
                    <div class="flex items-center gap-1.5">
                        <div class="relative w-16 h-2 bg-shadow-ink rounded-full border border-nile-turquoise/30 overflow-hidden">
                            <div class="absolute inset-0 bg-gradient-to-r from-nile-turquoise to-teal-400 transition-all duration-300" 
                                 :style="`width: ${hpPercent}%`"></div>
                        </div>
                        <span class="font-stat text-nile-turquoise text-xs whitespace-nowrap" x-text="`${currentHP}/${maxHP}`"></span>
                        <span class="text-desert-sand/70 text-xs" x-text="hpRegenCountdown > 0 ? formatTime(hpRegenCountdown) : ''"></span>
                    </div>
                </div>

                <!-- Stats (Hidden on mobile) -->
                <div class="hidden md:flex items-center gap-4">
                    <div class="flex items-center gap-1">
                        <span class="text-desert-sand/70">⚔️</span>
                        <span class="font-stat text-blood-red text-xs"><?php echo e($totalStats['attack']); ?></span>
                    </div>
                    <div class="flex items-center gap-1">
                        <span class="text-desert-sand/70">🛡️</span>
                        <span class="font-stat text-nile-turquoise text-xs"><?php echo e($totalStats['defense']); ?></span>
                    </div>
                    <div class="flex items-center gap-1">
                        <span class="text-desert-sand/70">💪</span>
                        <span class="font-stat text-purple-300 text-xs"><?php echo e($totalStats['stamina']); ?></span>
                    </div>
                </div>
            </div>

            <!-- Right Side - Cooldown & Currency -->
            <div class="flex flex-wrap items-center gap-4">
                <!-- Battle Cooldown -->
                <div class="flex items-center gap-2">
                    <span class="text-desert-sand/70">⚔️</span>
                    <div class="flex items-center gap-2">
                        <template x-if="canBattle">
                            <span class="font-stat text-green-400 whitespace-nowrap">Ready</span>
                        </template>
                        <template x-if="!canBattle">
                            <span class="font-stat text-blood-red whitespace-nowrap" x-text="formatTime(cooldownRemaining)"></span>
                        </template>
                    </div>
                </div>

                <!-- Currency -->
                <div class="flex items-center gap-4">
                    <div class="flex items-center gap-1">
                        <span class="text-ra-gold">💰</span>
                        <span class="font-stat text-ra-gold"><?php echo e(number_format($user->gold)); ?></span>
                    </div>
                    <div class="flex items-center gap-1">
                        <span class="text-nile-turquoise">💎</span>
                        <span class="font-stat text-nile-turquoise"><?php echo e(number_format($user->premium_coins)); ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<?php /**PATH C:\xampp\htdocs\inkieaskanger\resources\views/components/user-stats-bar.blade.php ENDPATH**/ ?>