<?php
use Illuminate\Support\Facades\Storage;
?>
<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex justify-between items-center">
            <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold">
                <?php echo e(__('Character Management')); ?>

            </h2>
            <div class="flex gap-2">
                <a href="<?php echo e(route('admin.characters.create')); ?>" class="cartouche-button bg-gradient-to-r from-ra-gold to-yellow-600">
                    New Character
                </a>
                <a href="<?php echo e(route('admin.dashboard')); ?>" class="cartouche-button">
                    Back
                </a>
            </div>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <?php if(session('success')): ?>
                <div class="quest-card bg-gradient-to-r from-nile-turquoise/20 to-green-500/20 border-nile-turquoise mb-6">
                    <span class="block text-desert-sand font-egyptian"><?php echo e(session('success')); ?></span>
                </div>
            <?php endif; ?>

            <div class="quest-card">
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-ra-gold/30">
                        <thead>
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Image</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Name</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Unlock</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Cost</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Bonuses</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Rarity</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Status</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-ra-gold/20">
                            <?php $__empty_1 = true; $__currentLoopData = $characters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $character): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="hover:bg-papyrus-dark/50 transition-colors">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <?php if($character->image_normal): ?>
                                        <img src="<?php echo e(Storage::url($character->image_normal)); ?>" alt="<?php echo e($character->name); ?>" class="w-16 h-16 object-cover rounded border border-ra-gold/30">
                                    <?php else: ?>
                                        <div class="w-16 h-16 bg-gradient-to-br from-ra-gold/20 to-yellow-600/20 border border-ra-gold/30 rounded flex items-center justify-center">
                                            <span class="text-2xl">👤</span>
                                        </div>
                                    <?php endif; ?>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="font-egyptian text-ra-gold"><?php echo e($character->name); ?></div>
                                    <?php if($character->description): ?>
                                        <div class="text-xs text-desert-sand/70 mt-1"><?php echo e(Str::limit($character->description, 50)); ?></div>
                                    <?php endif; ?>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <?php if($character->unlock_level): ?>
                                        <span class="text-nile-turquoise">Rank <?php echo e($character->unlock_level); ?></span>
                                    <?php else: ?>
                                        <span class="text-desert-sand/50">Shop Only</span>
                                    <?php endif; ?>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm">
                                    <?php if($character->cost_gold): ?>
                                        <div class="text-ra-gold">💰 <?php echo e(number_format($character->cost_gold)); ?></div>
                                    <?php endif; ?>
                                    <?php if($character->cost_premium): ?>
                                        <div class="text-nile-turquoise">💎 <?php echo e(number_format($character->cost_premium)); ?></div>
                                    <?php endif; ?>
                                    <?php if(!$character->cost_gold && !$character->cost_premium): ?>
                                        <span class="text-desert-sand/50">Free</span>
                                    <?php endif; ?>
                                    <?php if($character->is_vip_only): ?>
                                        <div class="text-yellow-400 text-xs mt-1">VIP Only</div>
                                    <?php endif; ?>
                                </td>
                                <td class="px-6 py-4 text-xs">
                                    <?php if($character->hp_bonus > 0): ?>
                                        <div class="text-nile-turquoise">+<?php echo e($character->hp_bonus); ?> HP</div>
                                    <?php endif; ?>
                                    <?php if($character->attack_bonus > 0): ?>
                                        <div class="text-blood-red">+<?php echo e($character->attack_bonus); ?> Attack</div>
                                    <?php endif; ?>
                                    <?php if($character->defense_bonus > 0): ?>
                                        <div class="text-nile-turquoise">+<?php echo e($character->defense_bonus); ?> Defense</div>
                                    <?php endif; ?>
                                    <?php if($character->stamina_bonus > 0): ?>
                                        <div class="text-purple-300">+<?php echo e($character->stamina_bonus); ?> Stamina</div>
                                    <?php endif; ?>
                                    <?php if(!$character->hp_bonus && !$character->attack_bonus && !$character->defense_bonus && !$character->stamina_bonus): ?>
                                        <span class="text-desert-sand/50">None</span>
                                    <?php endif; ?>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="px-2 py-1 text-xs rounded border
                                        <?php if($character->rarity === 'legendary'): ?> border-yellow-400 text-yellow-400
                                        <?php elseif($character->rarity === 'epic'): ?> border-purple-400 text-purple-400
                                        <?php elseif($character->rarity === 'rare'): ?> border-blue-400 text-blue-400
                                        <?php else: ?> border-gray-400 text-gray-400
                                        <?php endif; ?>">
                                        <?php echo e(ucfirst($character->rarity)); ?>

                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <?php if($character->is_active): ?>
                                        <span class="px-2 py-1 text-xs bg-green-900/50 text-green-300 rounded">Active</span>
                                    <?php else: ?>
                                        <span class="px-2 py-1 text-xs bg-red-900/50 text-red-300 rounded">Inactive</span>
                                    <?php endif; ?>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                    <div class="flex gap-2">
                                        <a href="<?php echo e(route('admin.characters.edit', $character)); ?>" class="text-nile-turquoise hover:text-teal-300">Edit</a>
                                        <form method="POST" action="<?php echo e(route('admin.characters.destroy', $character)); ?>" class="inline" onsubmit="return confirm('Are you sure you want to delete this character?');">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="text-blood-red hover:text-red-400">Delete</button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="8" class="px-6 py-4 text-center text-desert-sand">
                                    No characters found. <a href="<?php echo e(route('admin.characters.create')); ?>" class="text-ra-gold hover:underline">Create one</a>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <div class="mt-4">
                    <?php echo e($characters->links()); ?>

                </div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>

<?php /**PATH C:\laragon\www\quest-of-ra\resources\views/admin/characters/index.blade.php ENDPATH**/ ?>