<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['currentView' => 'cards']));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['currentView' => 'cards']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<?php
    $viewModes = [
        'cards' => ['icon' => '🃏', 'label' => 'Cards'],
        'table' => ['icon' => '📊', 'label' => 'Table'],
        'list' => ['icon' => '📋', 'label' => 'List'],
        'compact' => ['icon' => '📝', 'label' => 'Compact'],
        'kanban' => ['icon' => '📌', 'label' => 'Kanban'],
    ];
?>

<div class="view-switcher bg-papyrus-dark/50 rounded-lg p-3 border border-ra-gold/30 mb-6">
    <div class="flex items-center justify-between flex-wrap gap-3">
        <div class="flex items-center gap-2">
            <span class="text-desert-sand font-egyptian font-semibold">View Mode:</span>
        </div>
        <div class="flex gap-2 flex-wrap">
            <?php $__currentLoopData = $viewModes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mode => $config): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <button type="button" 
                        onclick="setViewMode('<?php echo e($mode); ?>')"
                        class="view-mode-btn px-4 py-2 rounded-lg border-2 text-sm font-semibold transition-all duration-300
                            <?php echo e($currentView === $mode 
                                ? 'bg-ra-gold border-ra-gold text-papyrus-dark shadow-gold-glow' 
                                : 'bg-papyrus-dark border-ra-gold/30 text-desert-sand hover:border-ra-gold hover:bg-papyrus-dark/70'); ?>">
                    <span class="mr-2"><?php echo e($config['icon']); ?></span>
                    <?php echo e($config['label']); ?>

                </button>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>

<script>
    function setViewMode(mode) {
        // Store in localStorage
        localStorage.setItem('quest_view_mode', mode);
        
        // Update URL parameter
        const url = new URL(window.location);
        url.searchParams.set('view', mode);
        window.location.href = url.toString();
    }
    
    // Load saved view mode on page load
    document.addEventListener('DOMContentLoaded', function() {
        const savedMode = localStorage.getItem('quest_view_mode');
        const urlParams = new URLSearchParams(window.location.search);
        const urlMode = urlParams.get('view');
        
        if (urlMode && urlMode !== '<?php echo e($currentView); ?>') {
            // View mode from URL takes precedence
            setViewMode(urlMode);
        } else if (savedMode && savedMode !== '<?php echo e($currentView); ?>') {
            // Apply saved mode if no URL parameter
            setViewMode(savedMode);
        }
    });
</script>

<?php /**PATH C:\laragon\www\quest-of-ra\resources\views/components/quests/view-switcher.blade.php ENDPATH**/ ?>