<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <?php $__env->startPush('head'); ?>
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Press+Start+2P&display=swap" rel="stylesheet">
    <?php $__env->stopPush(); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex justify-between items-center">
            <h2 class="text-3xl text-ra-gold text-shadow-gold flex items-center gap-3" style="font-family: 'Press Start 2P', monospace !important;">
                <span class="text-4xl">⚔️</span>
                <span>Fight Animation </span>
            </h2>
            <div class="flex gap-2">
                <a href="<?php echo e(route('characters.test-animations')); ?>" class="cartouche-button">
                    Character 
                </a>
                <a href="<?php echo e(route('characters.index')); ?>" class="cartouche-button">
                    Back to Characters
                </a>
            </div>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="quest-card mb-6">
                <p class="text-desert-sand mb-4">
                     fight animations with character (facing right) and mob (facing left) side by side.
                </p>
                <div class="grid grid-cols-2 md:grid-cols-4 gap-2 text-sm">
                    <div class="bg-nile-turquoise/20 border border-nile-turquoise rounded p-2">
                        <span class="font-bold text-nile-turquoise">Character</span> - Facing right (→)
                    </div>
                    <div class="bg-blood-red/20 border border-blood-red rounded p-2">
                        <span class="font-bold text-blood-red">Mob</span> - Facing left (←)
                    </div>
                    <div class="bg-ra-gold/20 border border-ra-gold rounded p-2">
                        <span class="font-bold text-ra-gold">PNG Sequence</span> - Image sequences
                    </div>
                    <div class="bg-green-600/20 border border-green-600 rounded p-2">
                        <span class="font-bold text-green-400">Available</span> - Animation exists
                    </div>
                </div>
            </div>

            <?php
                // Pre-encode character and mob data to avoid JSON parsing issues in x-data
                $charactersData = [];
                foreach ($characters as $char) {
                    $charactersData[$char->slug] = [
                        'slug' => $char->slug,
                        'name' => $char->name,
                        'states' => $char->getAllAnimationStates(),
                        'attack_power' => $char->attack ?? 50 // Default attack power
                    ];
                }
                $mobsData = [];
                foreach ($mobs as $mobItem) {
                    $mobsData[$mobItem->slug] = [
                        'slug' => $mobItem->slug,
                        'name' => $mobItem->name,
                        'states' => [
                            'png' => $mobItem->getPngSequenceStates('left')
                        ],
                        'attack_power' => $mobItem->attack ?? 40 // Default attack power
                    ];
                }
            ?>

            <!-- Character and Mob Selection and Fight Arena -->
            <div 
                data-characters='<?php echo json_encode($charactersData, 15, 512) ?>'
                data-mobs='<?php echo json_encode($mobsData, 15, 512) ?>'
                x-data="{
                     selectedCharacterSlug: '',
                     selectedMobSlug: '',
                     selectedBackgroundId: <?php echo e($selectedBackground ? $selectedBackground->id : 'null'); ?>,
                     characterState: 'idle',
                     mobState: 'idle',
                     character: null,
                     mob: null,
                     characterStates: [],
                     mobStates: [],
                     charactersData: JSON.parse($el.dataset.characters || '{}'),
                     mobsData: JSON.parse($el.dataset.mobs || '{}'),
                     
                     updateCharacter() {
                         if (!this.selectedCharacterSlug) {
                             this.character = null;
                             this.characterStates = [];
                             return;
                         }
                         
                         // Get character data
                         if (this.charactersData[this.selectedCharacterSlug]) {
                             this.character = this.charactersData[this.selectedCharacterSlug];
                             this.characterStates = this.character.states.png || [];
                         } else {
                             this.character = null;
                             this.characterStates = [];
                             return;
                         }
                         
                         // Reset to idle
                         this.characterState = 'idle';
                         this.triggerCharacterAnimation('idle');
                     },
                     
                     updateMob() {
                         if (!this.selectedMobSlug) {
                             this.mob = null;
                             this.mobStates = [];
                             return;
                         }
                         
                         // Get mob data
                         if (this.mobsData[this.selectedMobSlug]) {
                             this.mob = this.mobsData[this.selectedMobSlug];
                             this.mobStates = this.mob.states.png || [];
                         } else {
                             this.mob = null;
                             this.mobStates = [];
                             return;
                         }
                         
                         // Reset to idle
                         this.mobState = 'idle';
                         this.triggerMobAnimation('idle');
                     },
                     
                     triggerCharacterAnimation(state) {
                         this.characterState = state;
                         window.dispatchEvent(new CustomEvent('character-animation-state-change', {
                             detail: {
                                 characterSlug: this.selectedCharacterSlug,
                                 state: state
                             }
                         }));
                     },
                     
                     triggerMobAnimation(state) {
                         this.mobState = state;
                         window.dispatchEvent(new CustomEvent('mob-animation-state-change', {
                             detail: {
                                 mobSlug: this.selectedMobSlug,
                                 state: state
                             }
                         }));
                     },
                     
                     triggerBoth(state) {
                         this.triggerCharacterAnimation(state);
                         this.triggerMobAnimation(state);
                     },
                     
                     triggerCharacterWin() {
                         this.triggerCharacterAnimation('win');
                         this.triggerMobAnimation('lose');
                     },
                     
                     triggerMobWin() {
                         this.triggerCharacterAnimation('lose');
                         this.triggerMobAnimation('win');
                     }
                }">
                
                <!-- Character and Mob Selection -->
                <div class="quest-card mb-6">
                    <h3 class="font-egyptian text-2xl text-ra-gold mb-4">Select Characters</h3>
                    <?php if($characters->isEmpty() || $mobs->isEmpty()): ?>
                        <div class="bg-papyrus-dark/50 border-2 border-ra-gold/30 rounded-lg p-6 text-center">
                            <p class="text-desert-sand mb-2">
                                <?php if($characters->isEmpty() && $mobs->isEmpty()): ?>
                                    <strong class="text-ra-gold">No characters or mobs with animation folders found.</strong><br>
                                    <span class="text-sm">Please add PNG sequence animations to at least one character and one mob.</span>
                                <?php elseif($characters->isEmpty()): ?>
                                    <strong class="text-nile-turquoise">No characters with animation folders found.</strong><br>
                                    <span class="text-sm">Please add PNG sequence animations to at least one character.</span>
                                <?php else: ?>
                                    <strong class="text-blood-red">No mobs with animation folders found.</strong><br>
                                    <span class="text-sm">Please add PNG sequence animations to at least one mob.</span>
                                <?php endif; ?>
                            </p>
                            <p class="text-desert-sand/70 text-xs mt-4">
                                Characters and mobs without animation folders are automatically excluded from this  page.
                            </p>
                        </div>
                    <?php else: ?>
                        <div class="grid grid-cols-2 gap-6 mb-6">
                            <!-- Character Selection -->
                            <div>
                                <label class="block text-desert-sand font-semibold mb-2">Character:</label>
                                <select 
                                    x-model="selectedCharacterSlug"
                                    @change="updateCharacter()"
                                    class="w-full bg-papyrus-dark border border-ra-gold/30 rounded-lg px-4 py-2 text-desert-sand">
                                    <option value="">Select Character...</option>
                                    <?php $__currentLoopData = $characters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $character): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($character->slug); ?>"><?php echo e($character->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            
                            <!-- Mob Selection -->
                            <div>
                                <label class="block text-desert-sand font-semibold mb-2">Mob:</label>
                                <select 
                                    x-model="selectedMobSlug"
                                    @change="updateMob()"
                                    class="w-full bg-papyrus-dark border border-blood-red/30 rounded-lg px-4 py-2 text-desert-sand">
                                    <option value="">Select Mob...</option>
                                    <?php $__currentLoopData = $mobs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mob): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($mob->slug); ?>"><?php echo e($mob->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        
                        <!-- Background Selection (Arena 3 only) -->
                        <div class="mb-6">
                            <label class="block text-desert-sand font-semibold mb-2">Arena 3 Background:</label>
                            <select 
                                x-model="selectedBackgroundId"
                                class="w-full bg-papyrus-dark border border-nile-turquoise/30 rounded-lg px-4 py-2 text-desert-sand">
                                <option value="">Select Background...</option>
                                <?php $__currentLoopData = $allBackgrounds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(in_array($bg->id, $ownedBackgroundIds)): ?>
                                        <option value="<?php echo e($bg->id); ?>" <?php echo e($selectedBackground && $selectedBackground->id == $bg->id ? 'selected' : ''); ?>>
                                            <?php echo e($bg->name); ?> ✓
                                        </option>
                                    <?php else: ?>
                                        <option value="<?php echo e($bg->id); ?>" disabled>
                                            <?php echo e($bg->name); ?> 🔒 (Locked)
                                        </option>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <p class="text-sm text-desert-sand/70 mt-1">Select a background for Arena 3. Locked backgrounds are not available.</p>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Enter Arena Buttons -->
                <div class="text-center mb-6" x-show="selectedCharacterSlug && selectedMobSlug">
                    <div class="flex gap-4 justify-center flex-wrap">
                        <a 
                            :href="'/characters/arena-3?character=' + selectedCharacterSlug + '&mob=' + selectedMobSlug + (selectedBackgroundId && selectedBackgroundId !== null ? '&background=' + selectedBackgroundId : '')"
                            class="inline-block px-8 py-3 bg-blood-red text-shadow-ink font-egyptian text-lg rounded-lg hover:bg-blood-red/80 transition-all border-2 border-blood-red/50 shadow-lg">
                            ⚔️ Enter Arena  ⚔️
                        </a>
                    </div>
                </div>

                <!-- Fight Arena -->
                <?php if(!$characters->isEmpty() && !$mobs->isEmpty()): ?>
                <div class="quest-card">
                
                <!-- Animation Display -->
                <div class="grid grid-cols-2 gap-8 mb-6">
                    <!-- Character Side (Right Facing) -->
                    <div class="text-center">
                        <h3 class="font-egyptian text-xl text-nile-turquoise mb-3" x-text="character ? character.name : 'No Character Selected'"></h3>
                        <div class="w-full max-w-md mx-auto">
                            <?php $__currentLoopData = $characters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $char): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div x-show="selectedCharacterSlug === '<?php echo e($char->slug); ?>'" style="display: none;">
                                    <?php if (isset($component)) { $__componentOriginala07a35e3652b0e27c6b884e53e6e34e4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginala07a35e3652b0e27c6b884e53e6e34e4 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.character-animation','data' => ['character' => $char,'state' => 'idle','direction' => 'right','class' => 'w-full rounded-lg border-4 border-nile-turquoise shadow-turquoise-glow','autoplay' => true]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('character-animation'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['character' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($char),'state' => 'idle','direction' => 'right','class' => 'w-full rounded-lg border-4 border-nile-turquoise shadow-turquoise-glow','autoplay' => true]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginala07a35e3652b0e27c6b884e53e6e34e4)): ?>
<?php $attributes = $__attributesOriginala07a35e3652b0e27c6b884e53e6e34e4; ?>
<?php unset($__attributesOriginala07a35e3652b0e27c6b884e53e6e34e4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginala07a35e3652b0e27c6b884e53e6e34e4)): ?>
<?php $component = $__componentOriginala07a35e3652b0e27c6b884e53e6e34e4; ?>
<?php unset($__componentOriginala07a35e3652b0e27c6b884e53e6e34e4); ?>
<?php endif; ?>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <div x-show="!selectedCharacterSlug" class="w-full h-64 bg-papyrus-dark/50 rounded-lg flex items-center justify-center border-2 border-nile-turquoise/30">
                                <span class="text-desert-sand/50">Select a character</span>
                            </div>
                        </div>
                        
                        <!-- Character State Controls -->
                        <div class="mt-4" x-show="character">
                            <label class="block text-desert-sand font-semibold mb-2 text-sm">Character State:</label>
                            <div class="flex flex-wrap gap-2 justify-center">
                                <?php $__currentLoopData = $allStates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <button 
                                        @click="triggerCharacterAnimation('<?php echo e($state); ?>')"
                                        :class="characterState === '<?php echo e($state); ?>' 
                                            ? 'bg-nile-turquoise text-shadow-ink border-2 border-nile-turquoise' 
                                            : 'bg-papyrus-dark border border-nile-turquoise/30 hover:bg-papyrus-dark/80'"
                                        class="px-3 py-1 rounded-lg text-xs font-semibold transition-all text-desert-sand">
                                        <?php echo e(str_replace('_', ' ', $state)); ?>

                                    </button>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Mob Side (Left Facing) -->
                    <div class="text-center">
                        <h3 class="font-egyptian text-xl text-blood-red mb-3" x-text="mob ? mob.name : 'No Mob Selected'"></h3>
                        <div class="w-full max-w-md mx-auto">
                            <?php $__currentLoopData = $mobs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mobItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div x-show="selectedMobSlug === '<?php echo e($mobItem->slug); ?>'" style="display: none;">
                                    <?php if (isset($component)) { $__componentOriginal05285777a7f5eb539227554ea6a13dae = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal05285777a7f5eb539227554ea6a13dae = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.mob-animation','data' => ['mob' => $mobItem,'state' => 'idle','direction' => 'left','class' => 'w-full rounded-lg border-4 border-blood-red shadow-gold-glow','autoplay' => true]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('mob-animation'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['mob' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($mobItem),'state' => 'idle','direction' => 'left','class' => 'w-full rounded-lg border-4 border-blood-red shadow-gold-glow','autoplay' => true]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal05285777a7f5eb539227554ea6a13dae)): ?>
<?php $attributes = $__attributesOriginal05285777a7f5eb539227554ea6a13dae; ?>
<?php unset($__attributesOriginal05285777a7f5eb539227554ea6a13dae); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal05285777a7f5eb539227554ea6a13dae)): ?>
<?php $component = $__componentOriginal05285777a7f5eb539227554ea6a13dae; ?>
<?php unset($__componentOriginal05285777a7f5eb539227554ea6a13dae); ?>
<?php endif; ?>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <div x-show="!selectedMobSlug" class="w-full h-64 bg-papyrus-dark/50 rounded-lg flex items-center justify-center border-2 border-blood-red/30">
                                <span class="text-desert-sand/50">Select a mob</span>
                            </div>
                        </div>
                        
                        <!-- Mob State Controls -->
                        <div class="mt-4" x-show="mob">
                            <label class="block text-desert-sand font-semibold mb-2 text-sm">Mob State:</label>
                            <div class="flex flex-wrap gap-2 justify-center">
                                <?php $__currentLoopData = $allStates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <button 
                                        @click="triggerMobAnimation('<?php echo e($state); ?>')"
                                        :class="mobState === '<?php echo e($state); ?>' 
                                            ? 'bg-blood-red text-shadow-ink border-2 border-blood-red' 
                                            : 'bg-papyrus-dark border border-blood-red/30 hover:bg-papyrus-dark/80'"
                                        class="px-3 py-1 rounded-lg text-xs font-semibold transition-all text-desert-sand">
                                        <?php echo e(str_replace('_', ' ', $state)); ?>

                                    </button>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Synchronized Actions -->
                <div class="mt-6 p-4 bg-papyrus-dark/30 rounded-lg border-2 border-ra-gold/30">
                    <h4 class="font-egyptian text-lg text-ra-gold mb-3 text-center">Synchronized Actions</h4>
                    <div class="flex flex-wrap gap-2 justify-center">
                        <button 
                            @click="triggerBoth('idle')"
                            class="px-4 py-2 bg-nile-turquoise/20 hover:bg-nile-turquoise/30 border border-nile-turquoise rounded-lg text-desert-sand font-semibold transition-all">
                            Both Idle
                        </button>
                        <button 
                            @click="triggerBoth('attack')"
                            class="px-4 py-2 bg-blood-red/20 hover:bg-blood-red/30 border border-blood-red rounded-lg text-desert-sand font-semibold transition-all">
                            Both Attack
                        </button>
                        <button 
                            @click="triggerBoth('magic')"
                            class="px-4 py-2 bg-purple-600/20 hover:bg-purple-600/30 border border-purple-600 rounded-lg text-desert-sand font-semibold transition-all">
                            Both Magic
                        </button>
                        <button 
                            @click="triggerCharacterWin()"
                            class="px-4 py-2 bg-ra-gold/20 hover:bg-ra-gold/30 border border-ra-gold rounded-lg text-desert-sand font-semibold transition-all">
                            Character Wins
                        </button>
                        <button 
                            @click="triggerMobWin()"
                            class="px-4 py-2 bg-blood-red/20 hover:bg-blood-red/30 border border-blood-red rounded-lg text-desert-sand font-semibold transition-all">
                            Mob Wins
                        </button>
                    </div>
                </div>
                
                <!-- Folder Structure Info -->
                <div class="mt-6 p-4 bg-papyrus-dark/30 rounded-lg border-2 border-ra-gold/30">
                    <h4 class="font-egyptian text-lg text-ra-gold mb-3">Expected Folder Structure</h4>
                    <div class="grid grid-cols-2 gap-4 text-sm">
                        <div>
                            <div class="font-semibold text-nile-turquoise mb-2">Character (Right Facing):</div>
                            <div class="text-desert-sand font-mono text-xs bg-shadow-ink p-2 rounded">
                                /assets/characters/{slug}/<br>
                                ├── idle/right/01.png, 02.png...<br>
                                ├── fight/right/01.png, 02.png...<br>
                                └── (or without /right/ for base)
                            </div>
                        </div>
                        <div>
                            <div class="font-semibold text-blood-red mb-2">Mob (Left Facing):</div>
                            <div class="text-desert-sand font-mono text-xs bg-shadow-ink p-2 rounded">
                                /assets/mobs/{slug}/<br>
                                ├── idle/left/01.png, 02.png...<br>
                                ├── attack/left/01.png, 02.png...<br>
                                └── (or without /left/ for base)
                            </div>
                        </div>
                    </div>
                </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>

<?php /**PATH C:\laragon\www\quest-of-ra\resources\views/characters/test-fight.blade.php ENDPATH**/ ?>