<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames(([
    'character',
    'state' => 'idle',
    'direction' => 'right', // 'left' or 'right' - right faces mob (default)
    'class' => '',
    'autoplay' => true,
    'showControls' => false,
    'fallbackImage' => null,
    'loading' => true,
    'lowQualityMode' => null, // null = auto-detect, true/false = force
]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter(([
    'character',
    'state' => 'idle',
    'direction' => 'right', // 'left' or 'right' - right faces mob (default)
    'class' => '',
    'autoplay' => true,
    'showControls' => false,
    'fallbackImage' => null,
    'loading' => true,
    'lowQualityMode' => null, // null = auto-detect, true/false = force
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<?php
    // Get looping states from config
    $loopingStates = config('character_animations.looping_states', ['idle', 'magic']);
    $isLooping = in_array($state, $loopingStates);
    
    // Check if PNG sequence exists (with direction support)
    $hasPngSequence = $character->hasPngSequence($state, $direction);
    $pngSequence = $hasPngSequence ? $character->getPngSequence($state, $direction) : [];
    
    // Get fallback image
    $fallbackImg = null;
    if ($fallbackImage) {
        $fallbackImg = $fallbackImage;
    } elseif ($character->image_normal) {
        $fallbackImg = $character->image_normal;
    } elseif ($hasPngSequence && count($pngSequence) > 0) {
        // Use first frame as fallback
        $fallbackImg = $pngSequence[0];
    }
    
    // Pre-calculate values for JavaScript
    $lowQualityModeValue = $lowQualityMode === null ? null : ($lowQualityMode ? true : false);
    $autoReturnValue = in_array($state, config('character_animations.auto_return_states', []));
    $isLoopingJson = json_encode($isLooping);
    $autoReturnValueJson = json_encode($autoReturnValue);
    $lowQualityModeValueJson = json_encode($lowQualityModeValue);
    $loadingJson = json_encode($loading);
    $loopingStatesJson = json_encode(config('character_animations.looping_states', []));
    $autoReturnStatesJson = json_encode(config('character_animations.auto_return_states', []));
    $stayOnLastFrameStatesJson = json_encode(config('character_animations.stay_on_last_frame_states', []));
    $pngSequenceJson = json_encode($pngSequence);
?>

<div 
    class="character-animation-wrapper relative <?php echo e($class); ?>"
    data-character-slug="<?php echo e($character->slug); ?>"
    data-initial-state="<?php echo e($state); ?>"
    data-direction="<?php echo e($direction); ?>"
    data-png-sequence='<?php echo json_encode($pngSequence, 15, 512) ?>'
    data-has-png-sequence="<?php echo e($hasPngSequence ? 'true' : 'false'); ?>"
    data-is-looping="<?php echo e($isLooping ? 'true' : 'false'); ?>"
    data-auto-return="<?php echo e($autoReturnValue ? 'true' : 'false'); ?>"
    data-low-quality-mode="<?php echo e($lowQualityModeValue === null ? 'null' : ($lowQualityModeValue ? 'true' : 'false')); ?>"
    x-data="characterAnimation({
        initialState: $el.dataset.initialState,
        characterSlug: $el.dataset.characterSlug,
        direction: $el.dataset.direction || 'right',
        looping: $el.dataset.isLooping === 'true',
        autoReturn: $el.dataset.autoReturn === 'true',
        lowQualityMode: $el.dataset.lowQualityMode === 'null' ? null : ($el.dataset.lowQualityMode === 'true'),
        hasPngSequence: $el.dataset.hasPngSequence === 'true',
        pngSequence: JSON.parse($el.dataset.pngSequence || '[]')
    })"
    @animation-state-change.window="handleStateChange($event.detail)"
    x-bind:data-state="state"
>
    <!-- Loading Animation -->
    <div 
        x-show="loading" 
        x-cloak
        class="character-animation-loading absolute inset-0 flex items-center justify-center bg-papyrus-dark/50 rounded-lg z-10"
        style="display: none;"
    >
        <div class="flex flex-col items-center gap-2">
            <div class="animate-spin rounded-full h-8 w-8 border-b-2 border-ra-gold"></div>
            <span class="text-xs text-desert-sand/70">Loading animation...</span>
        </div>
    </div>

    <!-- PNG Sequence Animation Canvas -->
    <?php if($hasPngSequence && count($pngSequence) > 0): ?>
        <canvas 
            x-ref="sequenceCanvas"
            class="character-sequence max-w-full h-auto <?php echo e($showControls ? '' : 'pointer-events-none'); ?>"
            :class="{ 'opacity-0': loading && !showFallback }"
            style="background: transparent;"
        ></canvas>
    <?php elseif($fallbackImg): ?>
        <!-- Fallback Image -->
        <img 
            src="<?php echo e(str_starts_with($fallbackImg, '/') ? $fallbackImg : Storage::url($fallbackImg)); ?>" 
            alt="<?php echo e($character->name); ?>" 
            class="character-fallback-image max-w-full h-auto"
        >
    <?php else: ?>
        <!-- No animation available -->
        <div class="w-full h-64 bg-papyrus-dark/50 rounded-lg flex items-center justify-center border-2 border-ra-gold/30">
            <span class="text-desert-sand/50">No animation available</span>
        </div>
    <?php endif; ?>

    <!-- Fallback image overlay (shown on error) -->
    <?php if($fallbackImg): ?>
        <img 
            x-show="showFallback"
            x-cloak
            src="<?php echo e(str_starts_with($fallbackImg, '/') ? $fallbackImg : Storage::url($fallbackImg)); ?>" 
            alt="<?php echo e($character->name); ?>" 
            class="character-fallback-image max-w-full h-auto absolute inset-0 z-20"
            style="display: none;"
        >
    <?php endif; ?>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('alpine:init', () => {
    Alpine.data('characterAnimation', (config) => ({
        state: config.initialState,
        characterSlug: config.characterSlug,
        isLooping: config.looping,
        autoReturn: config.autoReturn,
        hasPngSequence: config.hasPngSequence || false,
        pngSequence: config.pngSequence || [],
        loading: <?php echo $loadingJson; ?>,
        showFallback: false,
        currentFrame: 0,
        sequenceInterval: null,
        sequenceImages: [],
        
        init() {
            // Listen for global animation state changes
            window.addEventListener('character-animation-state-change', (e) => {
                this.handleStateChange(e.detail);
            });
            
            // Watch for external state prop changes
            this.$watch('state', (newState) => {
                if (newState !== this.state) {
                    this.updateSequence();
                }
            });
            
            // Initialize animation
            this.$nextTick(() => {
                // Check if element is already visible
                const isVisible = () => {
                    const rect = this.$el.getBoundingClientRect();
                    return rect.width > 0 && rect.height > 0 && 
                           window.getComputedStyle(this.$el).display !== 'none' &&
                           window.getComputedStyle(this.$el).visibility !== 'hidden';
                };
                
                const initAnimation = () => {
                    if (this.hasPngSequence && this.pngSequence.length > 0) {
                        this.initSequence();
                    } else {
                        this.loading = false;
                    }
                };
                
                // If already visible, initialize immediately
                if (isVisible()) {
                    setTimeout(initAnimation, 50);
                } else {
                    // Use IntersectionObserver to detect when component becomes visible
                    if ('IntersectionObserver' in window) {
                        const observer = new IntersectionObserver((entries) => {
                            entries.forEach(entry => {
                                if (entry.isIntersecting) {
                                    initAnimation();
                                    observer.disconnect();
                                }
                            });
                        }, { threshold: 0.1 });
                        
                        observer.observe(this.$el);
                        
                        // Fallback timeout in case observer doesn't fire
                        setTimeout(() => {
                            if (isVisible()) {
                                initAnimation();
                                observer.disconnect();
                            }
                        }, 1000);
                    } else {
                        // Fallback for browsers without IntersectionObserver
                        setTimeout(initAnimation, 200);
                    }
                }
            });
        },
        
        destroy() {
            // Cleanup sequence animation
            this.stopSequence();
        },
        
        handleStateChange(event) {
            if (event.characterSlug === this.characterSlug || !event.characterSlug) {
                const oldState = this.state;
                
                // If state hasn't actually changed, don't reload
                if (oldState === event.state) {
                    return;
                }
                
                this.state = event.state;
                
                // Always reload sequence for new state (don't reuse old sequence)
                // Stop current animation and clear everything
                this.stopSequence();
                this.sequenceImages = [];
                this.currentFrame = 0;
                this.pngSequence = []; // Clear old sequence - important!
                this.loading = true;
                
                // Discover sequence for new state (with direction support)
                const folderMap = {
                    'attack': 'fight',
                };
                const folderName = folderMap[this.state] || this.state;
                
                // Try direction-specific folder first, then fallback to base
                const testPathDirection = `/assets/characters/${this.characterSlug}/${folderName}/${this.direction}/01.png`;
                const testPathBase = `/assets/characters/${this.characterSlug}/${folderName}/01.png`;
                
                // Try to load first frame to check if sequence exists (try direction first)
                const img = new Image();
                img.onload = () => {
                    // PNG sequence exists for this state
                    this.hasPngSequence = true;
                    this.loadSequenceForState(this.state);
                };
                img.onerror = () => {
                    // Try base folder (no direction)
                    const imgBase = new Image();
                    imgBase.onload = () => {
                        this.hasPngSequence = true;
                        this.loadSequenceForState(this.state);
                    };
                    imgBase.onerror = () => {
                        // No PNG sequence
                        this.hasPngSequence = false;
                        this.pngSequence = [];
                        this.stopSequence();
                        this.loading = false;
                    };
                    imgBase.src = testPathBase;
                };
                img.src = testPathDirection;
            }
        },
        
        loadSequenceForState(state) {
            const folderMap = {
                'attack': 'fight',
            };
            const folderName = folderMap[state] || state;
            
            // Try to find PNG files sequentially, stop after finding a gap
            // Check direction-specific folder first, then fallback to base folder
            const frames = [];
            let currentFrame = 1;
            let consecutiveErrors = 0;
            const maxConsecutiveErrors = 3; // Stop after 3 consecutive missing frames
            let useDirectionFolder = true; // Try direction folder first
            
            const checkNextFrame = () => {
                if (consecutiveErrors >= maxConsecutiveErrors) {
                    // Found gap, stop checking
                    if (frames.length > 0) {
                        frames.sort(); // Ensure proper order
                        this.pngSequence = frames;
                        this.updateSequence();
                    } else {
                        // Try base folder if direction folder had no frames
                        if (useDirectionFolder) {
                            useDirectionFolder = false;
                            consecutiveErrors = 0;
                            currentFrame = 1;
                            checkNextFrame();
                        } else {
                            this.hasPngSequence = false;
                            this.loading = false;
                        }
                    }
                    return;
                }
                
                // Build path with or without direction
                const directionPath = useDirectionFolder ? `/${this.direction}` : '';
                const framePath = `/assets/characters/${this.characterSlug}/${folderName}${directionPath}/${currentFrame.toString().padStart(2, '0')}.png`;
                const img = new Image();
                
                img.onload = () => {
                    frames.push(framePath);
                    consecutiveErrors = 0; // Reset error count on success
                    currentFrame++;
                    checkNextFrame(); // Check next frame
                };
                
                img.onerror = () => {
                    consecutiveErrors++;
                    if (consecutiveErrors >= maxConsecutiveErrors) {
                        // Found gap, stop checking
                        if (frames.length > 0) {
                            frames.sort();
                            this.pngSequence = frames;
                            this.updateSequence();
                        } else {
                            // Try base folder if direction folder had no frames
                            if (useDirectionFolder) {
                                useDirectionFolder = false;
                                consecutiveErrors = 0;
                                currentFrame = 1;
                                checkNextFrame();
                            } else {
                                this.hasPngSequence = false;
                                this.loading = false;
                            }
                        }
                    } else {
                        currentFrame++;
                        checkNextFrame(); // Continue checking
                    }
                };
                
                img.src = framePath;
            };
            
            // Start checking from frame 1
            checkNextFrame();
        },
        
        initSequence() {
            const canvas = this.$refs.sequenceCanvas;
            if (!canvas || this.pngSequence.length === 0) {
                this.loading = false;
                return;
            }
            
            this.loading = true;
            this.currentFrame = 0;
            this.sequenceImages = [];
            
            // Preload all images
            let loadedCount = 0;
            const totalFrames = this.pngSequence.length;
            
            if (totalFrames === 0) {
                this.loading = false;
                return;
            }
            
            this.pngSequence.forEach((src, index) => {
                const img = new Image();
                img.onload = () => {
                    loadedCount++;
                    if (loadedCount === totalFrames) {
                        this.loading = false;
                        this.startSequence();
                    }
                };
                img.onerror = () => {
                    console.warn(`Failed to load sequence frame ${index}: ${src}`);
                    loadedCount++;
                    if (loadedCount === totalFrames) {
                        this.loading = false;
                        if (this.sequenceImages.length > 0) {
                            this.startSequence();
                        } else {
                            this.showFallback = true;
                        }
                    }
                };
                img.src = src;
                this.sequenceImages.push(img);
            });
        },
        
        startSequence() {
            const canvas = this.$refs.sequenceCanvas;
            if (!canvas || this.sequenceImages.length === 0) return;
            
            // Set canvas size to first image size
            const firstImg = this.sequenceImages[0];
            canvas.width = firstImg.width;
            canvas.height = firstImg.height;
            
            // Draw first frame
            this.drawFrame(0);
            
            // Start animation loop (30 FPS = ~33ms per frame)
            const frameDelay = 33;
            this.currentFrame = 0;
            
            const animate = () => {
                if (this.currentFrame < this.sequenceImages.length) {
                    this.drawFrame(this.currentFrame);
                    this.currentFrame++;
                    
                    if (this.currentFrame >= this.sequenceImages.length) {
                        // Check if looping
                        const loopingStates = <?php echo $loopingStatesJson; ?>;
                        if (this.isLooping || loopingStates.includes(this.state)) {
                            this.currentFrame = 0; // Loop
                        } else {
                            // Check auto-return or stay on last frame
                            const autoReturnStates = <?php echo $autoReturnStatesJson; ?>;
                            const stayOnLastFrameStates = <?php echo $stayOnLastFrameStatesJson; ?>;
                            
                            if (autoReturnStates.includes(this.state)) {
                                // Return to idle after animation
                                setTimeout(() => {
                                    this.state = 'idle';
                                    this.handleStateChange({ state: 'idle', characterSlug: this.characterSlug });
                                }, 500);
                            } else if (stayOnLastFrameStates.includes(this.state)) {
                                // Stay on last frame
                                this.currentFrame = this.sequenceImages.length - 1;
                            }
                            return; // Stop animation
                        }
                    }
                    
                    this.sequenceInterval = setTimeout(animate, frameDelay);
                }
            };
            
            this.sequenceInterval = setTimeout(animate, frameDelay);
        },
        
        drawFrame(frameIndex) {
            const canvas = this.$refs.sequenceCanvas;
            if (!canvas || !this.sequenceImages[frameIndex]) return;
            
            const ctx = canvas.getContext('2d');
            ctx.clearRect(0, 0, canvas.width, canvas.height);
            ctx.drawImage(this.sequenceImages[frameIndex], 0, 0);
        },
        
        stopSequence() {
            if (this.sequenceInterval) {
                clearTimeout(this.sequenceInterval);
                this.sequenceInterval = null;
            }
        },
        
        updateSequence() {
            this.stopSequence();
            if (this.hasPngSequence && this.pngSequence.length > 0) {
                this.initSequence();
            } else {
                // Only try to discover if we don't have a sequence
                this.loadSequenceForState(this.state);
            }
        }
    }));
});
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH C:\laragon\www\quest-of-ra\resources\views/components/character-animation.blade.php ENDPATH**/ ?>