<?php
use Illuminate\Support\Facades\Storage;
?>
<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold flex items-center gap-3">
            <span class="text-4xl">👤</span>
            <span>Character Collection</span>
        </h2>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <?php if(session('success')): ?>
                <div class="mb-6 p-4 bg-green-900/50 border-2 border-green-500 rounded-lg text-green-300">
                    <p class="font-egyptian"><?php echo e(session('success')); ?></p>
                </div>
            <?php endif; ?>
            
            <?php if(session('error')): ?>
                <div class="mb-6 p-4 bg-red-900/50 border-2 border-red-500 rounded-lg text-red-300">
                    <p class="font-egyptian"><?php echo e(session('error')); ?></p>
                </div>
            <?php endif; ?>

            <!-- Currently Equipped Character -->
            <?php if($user->character): ?>
            <div class="quest-card mb-6 border-ra-gold border-2">
                <h3 class="font-egyptian text-xl text-ra-gold mb-4">Currently Equipped</h3>
                <div class="flex items-center gap-4">
                    <div class="w-24 h-24">
                        <?php if (isset($component)) { $__componentOriginala07a35e3652b0e27c6b884e53e6e34e4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginala07a35e3652b0e27c6b884e53e6e34e4 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.character-animation','data' => ['character' => $user->character,'state' => 'idle','class' => 'w-24 h-24 rounded-lg border-2 border-ra-gold']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('character-animation'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['character' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($user->character),'state' => 'idle','class' => 'w-24 h-24 rounded-lg border-2 border-ra-gold']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginala07a35e3652b0e27c6b884e53e6e34e4)): ?>
<?php $attributes = $__attributesOriginala07a35e3652b0e27c6b884e53e6e34e4; ?>
<?php unset($__attributesOriginala07a35e3652b0e27c6b884e53e6e34e4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginala07a35e3652b0e27c6b884e53e6e34e4)): ?>
<?php $component = $__componentOriginala07a35e3652b0e27c6b884e53e6e34e4; ?>
<?php unset($__componentOriginala07a35e3652b0e27c6b884e53e6e34e4); ?>
<?php endif; ?>
                    </div>
                    <div class="flex-1">
                        <h4 class="font-egyptian text-lg text-ra-gold"><?php echo e($user->character->name); ?></h4>
                        <p class="text-desert-sand text-sm"><?php echo e($user->character->description); ?></p>
                        <?php if($user->character->hp_bonus || $user->character->attack_bonus || $user->character->defense_bonus): ?>
                        <div class="flex gap-2 mt-2 text-xs">
                            <?php if($user->character->hp_bonus > 0): ?>
                                <span class="text-nile-turquoise">+<?php echo e($user->character->hp_bonus); ?> HP</span>
                            <?php endif; ?>
                            <?php if($user->character->attack_bonus > 0): ?>
                                <span class="text-blood-red">+<?php echo e($user->character->attack_bonus); ?> Attack</span>
                            <?php endif; ?>
                            <?php if($user->character->defense_bonus > 0): ?>
                                <span class="text-nile-turquoise">+<?php echo e($user->character->defense_bonus); ?> Defense</span>
                            <?php endif; ?>
                        </div>
                        <?php endif; ?>
                    </div>
                    <form method="POST" action="<?php echo e(route('characters.unequip')); ?>">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="cartouche-button bg-papyrus-dark hover:bg-shadow-ink">
                            Unequip
                        </button>
                    </form>
                </div>
            </div>
            <?php endif; ?>

            <!-- Owned Characters -->
            <?php if($ownedCharacters->count() > 0): ?>
            <div class="quest-card mb-6">
                <h3 class="font-egyptian text-xl text-ra-gold mb-4">Your Characters</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                    <?php $__currentLoopData = $ownedCharacters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $character): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="border-2 <?php echo e($user->character_id === $character->id ? 'border-ra-gold bg-ra-gold/10' : 'border-ra-gold/30'); ?> rounded-lg p-4">
                        <div class="w-full h-48 mb-3">
                            <?php if (isset($component)) { $__componentOriginala07a35e3652b0e27c6b884e53e6e34e4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginala07a35e3652b0e27c6b884e53e6e34e4 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.character-animation','data' => ['character' => $character,'state' => 'idle','class' => 'w-full h-48 rounded-lg border border-ra-gold/30']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('character-animation'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['character' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($character),'state' => 'idle','class' => 'w-full h-48 rounded-lg border border-ra-gold/30']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginala07a35e3652b0e27c6b884e53e6e34e4)): ?>
<?php $attributes = $__attributesOriginala07a35e3652b0e27c6b884e53e6e34e4; ?>
<?php unset($__attributesOriginala07a35e3652b0e27c6b884e53e6e34e4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginala07a35e3652b0e27c6b884e53e6e34e4)): ?>
<?php $component = $__componentOriginala07a35e3652b0e27c6b884e53e6e34e4; ?>
<?php unset($__componentOriginala07a35e3652b0e27c6b884e53e6e34e4); ?>
<?php endif; ?>
                        </div>
                        <h4 class="font-egyptian text-lg text-ra-gold mb-1"><?php echo e($character->name); ?></h4>
                        <p class="text-desert-sand text-xs mb-2"><?php echo e(Str::limit($character->description ?? '', 60)); ?></p>
                        <?php if($character->hp_bonus || $character->attack_bonus || $character->defense_bonus): ?>
                        <div class="flex flex-wrap gap-1 mb-3 text-xs">
                            <?php if($character->hp_bonus > 0): ?>
                                <span class="px-2 py-1 bg-nile-turquoise/20 text-nile-turquoise rounded">+<?php echo e($character->hp_bonus); ?> HP</span>
                            <?php endif; ?>
                            <?php if($character->attack_bonus > 0): ?>
                                <span class="px-2 py-1 bg-blood-red/20 text-blood-red rounded">+<?php echo e($character->attack_bonus); ?> Attack</span>
                            <?php endif; ?>
                            <?php if($character->defense_bonus > 0): ?>
                                <span class="px-2 py-1 bg-nile-turquoise/20 text-nile-turquoise rounded">+<?php echo e($character->defense_bonus); ?> Defense</span>
                            <?php endif; ?>
                        </div>
                        <?php endif; ?>
                        <?php if($user->character_id !== $character->id): ?>
                        <form method="POST" action="<?php echo e(route('characters.equip', $character)); ?>">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="w-full cartouche-button text-sm">
                                Equip
                            </button>
                        </form>
                        <?php else: ?>
                        <div class="w-full text-center py-2 text-ra-gold font-egyptian text-sm">
                            ✓ Equipped
                        </div>
                        <?php endif; ?>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <?php endif; ?>

            <!-- Shop Characters -->
            <?php if($shopCharacters->count() > 0): ?>
            <div class="quest-card mb-6">
                <h3 class="font-egyptian text-xl text-ra-gold mb-4">Available Characters</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                    <?php $__currentLoopData = $shopCharacters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $character): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="border-2 border-ra-gold/30 rounded-lg p-4">
                        <div class="w-full h-48 mb-3">
                            <?php if (isset($component)) { $__componentOriginala07a35e3652b0e27c6b884e53e6e34e4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginala07a35e3652b0e27c6b884e53e6e34e4 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.character-animation','data' => ['character' => $character,'state' => 'idle','class' => 'w-full h-48 rounded-lg border border-ra-gold/30']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('character-animation'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['character' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($character),'state' => 'idle','class' => 'w-full h-48 rounded-lg border border-ra-gold/30']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginala07a35e3652b0e27c6b884e53e6e34e4)): ?>
<?php $attributes = $__attributesOriginala07a35e3652b0e27c6b884e53e6e34e4; ?>
<?php unset($__attributesOriginala07a35e3652b0e27c6b884e53e6e34e4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginala07a35e3652b0e27c6b884e53e6e34e4)): ?>
<?php $component = $__componentOriginala07a35e3652b0e27c6b884e53e6e34e4; ?>
<?php unset($__componentOriginala07a35e3652b0e27c6b884e53e6e34e4); ?>
<?php endif; ?>
                        </div>
                        <h4 class="font-egyptian text-lg text-ra-gold mb-1"><?php echo e($character->name); ?></h4>
                        <p class="text-desert-sand text-xs mb-2"><?php echo e(Str::limit($character->description ?? '', 60)); ?></p>
                        <?php if($character->hp_bonus || $character->attack_bonus || $character->defense_bonus): ?>
                        <div class="flex flex-wrap gap-1 mb-3 text-xs">
                            <?php if($character->hp_bonus > 0): ?>
                                <span class="px-2 py-1 bg-nile-turquoise/20 text-nile-turquoise rounded">+<?php echo e($character->hp_bonus); ?> HP</span>
                            <?php endif; ?>
                            <?php if($character->attack_bonus > 0): ?>
                                <span class="px-2 py-1 bg-blood-red/20 text-blood-red rounded">+<?php echo e($character->attack_bonus); ?> Attack</span>
                            <?php endif; ?>
                            <?php if($character->defense_bonus > 0): ?>
                                <span class="px-2 py-1 bg-nile-turquoise/20 text-nile-turquoise rounded">+<?php echo e($character->defense_bonus); ?> Defense</span>
                            <?php endif; ?>
                        </div>
                        <?php endif; ?>
                        <div class="mb-3">
                            <?php if($character->unlock_level): ?>
                                <p class="text-desert-sand text-xs mb-1">Unlocks at Rank <?php echo e($character->unlock_level); ?></p>
                            <?php endif; ?>
                            <?php if($character->cost_gold): ?>
                                <p class="text-ra-gold text-sm font-stat">💰 <?php echo e(number_format($character->cost_gold)); ?> Gold</p>
                            <?php endif; ?>
                            <?php if($character->cost_premium): ?>
                                <p class="text-nile-turquoise text-sm font-stat">💎 <?php echo e(number_format($character->cost_premium)); ?> Premium Coins</p>
                            <?php endif; ?>
                            <?php if($character->is_vip_only): ?>
                                <p class="text-yellow-400 text-xs">VIP Only</p>
                            <?php endif; ?>
                        </div>
                        <?php if($character->isPurchasable() && (!$character->is_vip_only || $user->isVip())): ?>
                        <form method="POST" action="<?php echo e(route('characters.purchase', $character)); ?>">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="w-full cartouche-button text-sm">
                                Purchase
                            </button>
                        </form>
                        <?php elseif($character->unlock_level && $user->level >= $character->unlock_level): ?>
                        <div class="w-full text-center py-2 text-green-400 font-egyptian text-sm">
                            ✓ Unlocked (Equip from Your Characters)
                        </div>
                        <?php else: ?>
                        <div class="w-full text-center py-2 text-desert-sand/70 font-egyptian text-xs">
                            Locked
                        </div>
                        <?php endif; ?>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <?php endif; ?>

            <!-- Locked Characters -->
            <?php if($lockedCharacters->count() > 0): ?>
            <div class="quest-card">
                <h3 class="font-egyptian text-xl text-ra-gold mb-4">Locked Characters</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                    <?php $__currentLoopData = $lockedCharacters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $character): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="border-2 border-shadow-ink/30 rounded-lg p-4 opacity-60">
                        <?php if($character->image_normal): ?>
                            <img src="<?php echo e($character->image_normal); ?>" alt="<?php echo e($character->name); ?>" 
                                 class="w-full h-48 object-cover rounded-lg mb-3 border border-shadow-ink/30 grayscale">
                        <?php else: ?>
                            <div class="w-full h-48 bg-gradient-to-br from-shadow-ink/20 to-papyrus-dark/20 border border-shadow-ink/30 rounded-lg mb-3 flex items-center justify-center">
                                <span class="text-6xl">🔒</span>
                            </div>
                        <?php endif; ?>
                        <h4 class="font-egyptian text-lg text-desert-sand/70 mb-1"><?php echo e($character->name); ?></h4>
                        <p class="text-desert-sand/50 text-xs mb-2"><?php echo e(Str::limit($character->description ?? '', 60)); ?></p>
                        <div class="text-center">
                            <p class="text-desert-sand/70 text-xs">Requires Rank <?php echo e($character->unlock_level); ?></p>
                            <p class="text-desert-sand/50 text-xs mt-1">Your Rank: <?php echo e($user->level); ?></p>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>

<?php /**PATH C:\xampp\htdocs\inkieaskanger\resources\views/characters/index.blade.php ENDPATH**/ ?>