<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold">
            <?php echo e(__('Arena 3 Combat Logs')); ?>

        </h2>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="quest-card mb-6">
                <p class="text-desert-sand mb-4">
                    View logs to verify that characters and mobs are using the stats configured in the admin panel.
                    Logs show base stats, bonuses, and final calculated values for Arena 3.
                </p>
                <a href="<?php echo e(route('admin.dashboard')); ?>" class="cartouche-button bg-papyrus-dark hover:bg-shadow-ink">
                    ← Back to Admin Dashboard
                </a>
            </div>

            <?php if(empty($logs)): ?>
                <div class="quest-card">
                    <p class="text-desert-sand text-center py-8">
                        No Arena 3 logs found yet. Enter Arena 3 to generate logs.
                    </p>
                </div>
            <?php else: ?>
                <div class="space-y-4">
                    <?php $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="quest-card">
                            <div class="flex items-center justify-between mb-3">
                                <h3 class="font-egyptian text-lg <?php echo e($log['type'] === 'Character' ? 'text-nile-turquoise' : 'text-blood-red'); ?>">
                                    <?php echo e($log['type']); ?> Stats - <?php echo e($log['data']['character_name'] ?? $log['data']['mob_name'] ?? 'Unknown'); ?>

                                </h3>
                                <span class="text-xs text-desert-sand/70"><?php echo e($log['timestamp']); ?></span>
                            </div>
                            
                            <?php if($log['type'] === 'Character'): ?>
                                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                                    <div class="bg-papyrus-dark/50 p-4 rounded border border-nile-turquoise/30">
                                        <div class="text-sm font-egyptian text-nile-turquoise mb-2">HP</div>
                                        <div class="text-xs text-desert-sand/70">Base: <?php echo e($log['data']['base_hp'] ?? 'N/A'); ?></div>
                                        <div class="text-xs text-desert-sand/70">Bonus: <?php echo e($log['data']['hp_bonus'] ?? 0); ?></div>
                                        <div class="text-lg font-bold text-nile-turquoise mt-1">Final: <?php echo e($log['data']['final_hp'] ?? 'N/A'); ?></div>
                                    </div>
                                    <div class="bg-papyrus-dark/50 p-4 rounded border border-blood-red/30">
                                        <div class="text-sm font-egyptian text-blood-red mb-2">Attack</div>
                                        <div class="text-xs text-desert-sand/70">Base: <?php echo e($log['data']['base_attack'] ?? 'N/A'); ?></div>
                                        <div class="text-xs text-desert-sand/70">Bonus: <?php echo e($log['data']['attack_bonus'] ?? 0); ?></div>
                                        <div class="text-lg font-bold text-blood-red mt-1">Final: <?php echo e($log['data']['final_attack'] ?? 'N/A'); ?></div>
                                    </div>
                                    <div class="bg-papyrus-dark/50 p-4 rounded border border-ra-gold/30">
                                        <div class="text-sm font-egyptian text-ra-gold mb-2">Defense</div>
                                        <div class="text-xs text-desert-sand/70">Base: <?php echo e($log['data']['base_defense'] ?? 'N/A'); ?></div>
                                        <div class="text-xs text-desert-sand/70">Bonus: <?php echo e($log['data']['defense_bonus'] ?? 0); ?></div>
                                        <div class="text-lg font-bold text-ra-gold mt-1">Final: <?php echo e($log['data']['final_defense'] ?? 'N/A'); ?></div>
                                    </div>
                                </div>
                                <div class="mt-3 text-xs text-desert-sand/70">
                                    Character ID: <?php echo e($log['data']['character_id'] ?? 'N/A'); ?> | 
                                    Slug: <?php echo e($log['data']['character_slug'] ?? 'N/A'); ?>

                                </div>
                            <?php else: ?>
                                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                                    <div class="bg-papyrus-dark/50 p-4 rounded border border-nile-turquoise/30">
                                        <div class="text-sm font-egyptian text-nile-turquoise mb-2">HP</div>
                                        <div class="text-xs text-desert-sand/70">Original: <?php echo e($log['data']['original_hp'] ?? 'N/A'); ?></div>
                                        <div class="text-xs text-desert-sand/70 <?php echo e($log['data']['hp_was_balanced'] ?? false ? 'text-yellow-400' : 'text-green-400'); ?>">
                                            <?php echo e($log['data']['hp_was_balanced'] ?? false ? '⚖️ Balanced' : '✓ Used as-is'); ?>

                                        </div>
                                        <div class="text-xs text-desert-sand/70">Ratio: <?php echo e($log['data']['hp_ratio'] ?? 'N/A'); ?></div>
                                        <div class="text-lg font-bold text-nile-turquoise mt-1">Final: <?php echo e($log['data']['final_hp'] ?? 'N/A'); ?></div>
                                    </div>
                                    <div class="bg-papyrus-dark/50 p-4 rounded border border-blood-red/30">
                                        <div class="text-sm font-egyptian text-blood-red mb-2">Attack</div>
                                        <div class="text-xs text-desert-sand/70">Original: <?php echo e($log['data']['original_attack'] ?? 'N/A'); ?></div>
                                        <div class="text-xs text-desert-sand/70 <?php echo e($log['data']['attack_was_balanced'] ?? false ? 'text-yellow-400' : 'text-green-400'); ?>">
                                            <?php echo e($log['data']['attack_was_balanced'] ?? false ? '⚖️ Balanced' : '✓ Used as-is'); ?>

                                        </div>
                                        <div class="text-xs text-desert-sand/70">Ratio: <?php echo e($log['data']['attack_ratio'] ?? 'N/A'); ?></div>
                                        <div class="text-lg font-bold text-blood-red mt-1">Final: <?php echo e($log['data']['final_attack'] ?? 'N/A'); ?></div>
                                    </div>
                                    <div class="bg-papyrus-dark/50 p-4 rounded border border-ra-gold/30">
                                        <div class="text-sm font-egyptian text-ra-gold mb-2">Defense</div>
                                        <div class="text-xs text-desert-sand/70">Original: <?php echo e($log['data']['original_defense'] ?? 'N/A'); ?></div>
                                        <div class="text-xs text-desert-sand/70 <?php echo e($log['data']['defense_was_balanced'] ?? false ? 'text-yellow-400' : 'text-green-400'); ?>">
                                            <?php echo e($log['data']['defense_was_balanced'] ?? false ? '⚖️ Balanced' : '✓ Used as-is'); ?>

                                        </div>
                                        <div class="text-xs text-desert-sand/70">Ratio: <?php echo e($log['data']['defense_ratio'] ?? 'N/A'); ?></div>
                                        <div class="text-lg font-bold text-ra-gold mt-1">Final: <?php echo e($log['data']['final_defense'] ?? 'N/A'); ?></div>
                                    </div>
                                </div>
                                <div class="mt-3 text-xs text-desert-sand/70">
                                    Mob ID: <?php echo e($log['data']['mob_id'] ?? 'N/A'); ?> | 
                                    Slug: <?php echo e($log['data']['mob_slug'] ?? 'N/A'); ?>

                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>

<?php /**PATH C:\laragon\www\quest-of-ra\resources\views/admin/arena3-logs/index.blade.php ENDPATH**/ ?>