<?php
use Illuminate\Support\Facades\Storage;
?>
<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold">
            <?php echo e(__('Edit Mob')); ?>: <?php echo e($mob->name); ?>

        </h2>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-4xl mx-auto sm:px-6 lg:px-8">
            <div class="quest-card">
                <form method="POST" action="<?php echo e(route('admin.mobs.update', $mob)); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                        <div>
                            <label for="name" class="block text-sm font-egyptian text-ra-gold mb-2">Mob Name</label>
                            <input type="text" id="name" name="name" value="<?php echo e(old('name', $mob->name)); ?>" required
                                class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-blood-red text-sm mt-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div>
                            <label for="level" class="block text-sm font-egyptian text-ra-gold mb-2">Level</label>
                            <input type="number" id="level" name="level" value="<?php echo e(old('level', $mob->level)); ?>" min="1" max="80" required
                                class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                            <?php $__errorArgs = ['level'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-blood-red text-sm mt-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <!-- Combat Stats for Arena 3 -->
                    <div class="mb-6">
                        <h3 class="font-egyptian text-xl text-ra-gold mb-4">Combat Stats (Used in Arena 3)</h3>
                        <p class="text-sm text-desert-sand mb-4">
                            These stats control the mob's HP, Attack, and Defense in Arena 3. 
                            Stats will be automatically balanced to be within 10% of the character's stats for fair fights.
                        </p>
                        <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                            <div>
                                <label for="hp" class="block text-sm font-egyptian text-nile-turquoise mb-2">HP</label>
                                <input type="number" id="hp" name="hp" value="<?php echo e(old('hp', $mob->hp)); ?>" min="1" required
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-nile-turquoise/30 rounded text-desert-sand focus:border-nile-turquoise focus:outline-none">
                                <p class="text-xs text-desert-sand/70 mt-1">Mob's health points</p>
                                <?php $__errorArgs = ['hp'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-blood-red text-sm mt-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div>
                                <label for="attack" class="block text-sm font-egyptian text-blood-red mb-2">Attack</label>
                                <input type="number" id="attack" name="attack" value="<?php echo e(old('attack', $mob->attack)); ?>" min="1" required
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-blood-red/30 rounded text-desert-sand focus:border-blood-red focus:outline-none">
                                <p class="text-xs text-desert-sand/70 mt-1">Mob's attack power</p>
                                <?php $__errorArgs = ['attack'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-blood-red text-sm mt-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div>
                                <label for="defense" class="block text-sm font-egyptian text-ra-gold mb-2">Defense</label>
                                <input type="number" id="defense" name="defense" value="<?php echo e(old('defense', $mob->defense)); ?>" min="0" required
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                                <p class="text-xs text-desert-sand/70 mt-1">Mob's defense value</p>
                                <?php $__errorArgs = ['defense'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-blood-red text-sm mt-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        <div>
                            <label for="speed" class="block text-sm font-egyptian text-ra-gold mb-2">Speed</label>
                            <input type="number" id="speed" name="speed" value="<?php echo e(old('speed', $mob->speed)); ?>" min="1" required
                                class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                        </div>
                    </div>

                    <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-6">
                        <div>
                            <label for="luck" class="block text-sm font-egyptian text-ra-gold mb-2">Luck</label>
                            <input type="number" id="luck" name="luck" value="<?php echo e(old('luck', $mob->luck)); ?>" min="0" max="20" required
                                class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                        </div>
                        <div>
                            <label for="xp_reward" class="block text-sm font-egyptian text-ra-gold mb-2">XP Reward</label>
                            <input type="number" id="xp_reward" name="xp_reward" value="<?php echo e(old('xp_reward', $mob->xp_reward)); ?>" min="0" required
                                class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                        </div>
                        <div>
                            <label for="gold_reward" class="block text-sm font-egyptian text-ra-gold mb-2">Gold Reward</label>
                            <input type="number" id="gold_reward" name="gold_reward" value="<?php echo e(old('gold_reward', $mob->gold_reward)); ?>" min="0" required
                                class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                        </div>
                        <div>
                            <label for="premium_coin_chance" class="block text-sm font-egyptian text-ra-gold mb-2">Premium Coin Chance</label>
                            <input type="number" id="premium_coin_chance" name="premium_coin_chance" value="<?php echo e(old('premium_coin_chance', $mob->premium_coin_chance)); ?>" step="0.0001" min="0" max="1"
                                class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                        <div>
                            <label for="rarity" class="block text-sm font-egyptian text-ra-gold mb-2">Rarity</label>
                            <select id="rarity" name="rarity" required
                                class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                                <option value="common" <?php echo e(old('rarity', $mob->rarity) == 'common' ? 'selected' : ''); ?>>Common</option>
                                <option value="rare" <?php echo e(old('rarity', $mob->rarity) == 'rare' ? 'selected' : ''); ?>>Rare</option>
                                <option value="epic" <?php echo e(old('rarity', $mob->rarity) == 'epic' ? 'selected' : ''); ?>>Epic</option>
                                <option value="legendary" <?php echo e(old('rarity', $mob->rarity) == 'legendary' ? 'selected' : ''); ?>>Legendary</option>
                            </select>
                        </div>
                        <div>
                            <label for="ai_type" class="block text-sm font-egyptian text-ra-gold mb-2">AI Type</label>
                            <select id="ai_type" name="ai_type" required
                                class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                                <option value="passive" <?php echo e(old('ai_type', $mob->ai_type) == 'passive' ? 'selected' : ''); ?>>Passive</option>
                                <option value="aggressive" <?php echo e(old('ai_type', $mob->ai_type) == 'aggressive' ? 'selected' : ''); ?>>Aggressive</option>
                                <option value="strategic" <?php echo e(old('ai_type', $mob->ai_type) == 'strategic' ? 'selected' : ''); ?>>Strategic</option>
                            </select>
                        </div>
                    </div>

                    <!-- Image Uploads -->
                    <div class="mb-6">
                        <h3 class="font-egyptian text-xl text-ra-gold mb-4">Battle Images</h3>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                            <div>
                                <label for="image_normal" class="block text-sm font-egyptian text-ra-gold mb-2">Normal Image</label>
                                <?php if($mob->image_normal): ?>
                                    <div class="mb-2">
                                        <img src="<?php echo e(Storage::url($mob->image_normal)); ?>" alt="Normal" class="w-32 h-32 object-cover rounded border border-ra-gold/30">
                                    </div>
                                <?php endif; ?>
                                <input type="file" id="image_normal" name="image_normal" accept="image/*"
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                                <p class="text-xs text-desert-sand mt-1">Shown during battle</p>
                            </div>
                            <div>
                                <label for="image_win" class="block text-sm font-egyptian text-ra-gold mb-2">Win Image</label>
                                <?php if($mob->image_win): ?>
                                    <div class="mb-2">
                                        <img src="<?php echo e(Storage::url($mob->image_win)); ?>" alt="Win" class="w-32 h-32 object-cover rounded border border-ra-gold/30">
                                    </div>
                                <?php endif; ?>
                                <input type="file" id="image_win" name="image_win" accept="image/*"
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                                <p class="text-xs text-desert-sand mt-1">Shown when mob wins</p>
                            </div>
                            <div>
                                <label for="image_loss" class="block text-sm font-egyptian text-ra-gold mb-2">Loss Image</label>
                                <?php if($mob->image_loss): ?>
                                    <div class="mb-2">
                                        <img src="<?php echo e(Storage::url($mob->image_loss)); ?>" alt="Loss" class="w-32 h-32 object-cover rounded border border-ra-gold/30">
                                    </div>
                                <?php endif; ?>
                                <input type="file" id="image_loss" name="image_loss" accept="image/*"
                                    class="w-full px-4 py-2 bg-papyrus-dark border border-ra-gold/30 rounded text-desert-sand focus:border-ra-gold focus:outline-none">
                                <p class="text-xs text-desert-sand mt-1">Shown when mob loses</p>
                            </div>
                        </div>
                    </div>

                    <div class="flex items-center justify-end gap-4">
                        <a href="<?php echo e(route('admin.mobs.index')); ?>" class="cartouche-button bg-papyrus-dark hover:bg-shadow-ink">
                            Cancel
                        </a>
                        <button type="submit" class="cartouche-button bg-gradient-to-r from-blood-red to-red-700">
                            Update Mob
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\laragon\www\quest-of-ra\resources\views/admin/mobs/edit.blade.php ENDPATH**/ ?>