<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['tasks', 'scrollColor' => '#d4a65a']));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['tasks', 'scrollColor' => '#d4a65a']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
    <?php $__currentLoopData = $tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="quest-card-papyrus bg-[#fdf2d2] border-2 rounded-lg p-4 hover:shadow-lg transition-all duration-300"
             style="border-color: <?php echo e($scrollColor); ?>;">
            <div class="flex justify-between items-start mb-3">
                <h4 class="font-egyptian text-lg text-ra-gold font-bold flex-1"><?php echo e($task->title); ?></h4>
                <span class="px-2 py-1 text-xs rounded border capitalize
                    <?php echo e($task->status === 'completed' ? 'bg-green-900/30 border-green-500 text-green-300' : ''); ?>

                    <?php echo e($task->status === 'pending' ? 'bg-ra-gold/20 border-ra-gold text-ra-gold' : ''); ?>

                    <?php echo e($task->status === 'skipped' ? 'bg-gray-700/30 border-gray-500 text-gray-300' : ''); ?>">
                    <?php echo e($task->status); ?>

                </span>
            </div>

            <?php if($task->description): ?>
                <p class="text-desert-sand/70 text-sm mb-3 line-clamp-2"><?php echo e(Str::limit($task->description, 100)); ?></p>
            <?php endif; ?>

            <div class="flex items-center gap-4 mb-3 text-sm">
                <div class="flex items-center gap-1">
                    <span class="text-nile-turquoise">✨</span>
                    <span class="text-desert-sand font-semibold"><?php echo e($task->points); ?> XP</span>
                </div>
                <?php if($task->coins > 0): ?>
                <div class="flex items-center gap-1">
                    <span class="text-ra-gold">💰</span>
                    <span class="text-desert-sand font-semibold"><?php echo e($task->coins); ?></span>
                </div>
                <?php endif; ?>
                <?php if($task->difficulty_level): ?>
                <div class="flex items-center gap-1">
                    <span class="text-desert-sand/70 capitalize text-xs">⚔️ <?php echo e($task->difficulty_level); ?></span>
                </div>
                <?php endif; ?>
            </div>

            <?php if($task->category): ?>
                <div class="mb-3">
                    <span class="px-2 py-1 text-xs rounded bg-papyrus-dark/50 text-desert-sand border border-ra-gold/30">
                        <?php echo e($task->category->name); ?>

                    </span>
                </div>
            <?php endif; ?>

            <div class="flex gap-2">
                <a href="<?php echo e(route('tasks.show', $task)); ?>" 
                   class="flex-1 bg-nile-turquoise/20 hover:bg-nile-turquoise/30 border border-nile-turquoise text-nile-turquoise text-center py-2 px-4 rounded-lg text-sm font-semibold transition-all duration-300">
                    View
                </a>
                <?php if($task->status !== 'completed'): ?>
                <form method="POST" action="<?php echo e(route('tasks.complete', $task)); ?>" class="flex-1">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="w-full bg-ra-gold hover:bg-ra-gold/80 text-papyrus-dark py-2 px-4 rounded-lg text-sm font-bold transition-all duration-300 shadow-gold-glow">
                        Complete
                    </button>
                </form>
                <?php endif; ?>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

<?php /**PATH C:\xampp\htdocs\inkieaskanger\resources\views/components/quests/views/cards.blade.php ENDPATH**/ ?>