<?php
    $egyptianNames = [
        'Sword' => 'Sword of Horus',
        'Scarab' => 'Scarab Amulet',
        'Cloak' => "Ra's Cloak",
        'Shield' => 'Eye of Anubis Shield',
        'Staff' => "Osiris's Staff",
        'Armor' => 'Pharaoh\'s Armor',
        'Ring' => 'Cleopatra\'s Ring',
        'Potion' => 'Elixir of the Nile',
    ];
?>

<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
    <?php $__empty_1 = true; $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
    <div class="quest-card hover:scale-105 transition-transform duration-300 <?php echo e(in_array($item->id, $ownedItemIds) ? 'opacity-60' : ''); ?> <?php echo e($item->is_vip_only && !$isVip ? 'opacity-50' : ''); ?>" 
         x-data="{ hovering: false }"
         @mouseenter="hovering = true"
         @mouseleave="hovering = false">
        <!-- Stone Tablet Effect -->
        <div class="relative">
            <?php if($item->image_url): ?>
            <img src="<?php echo e($item->image_url); ?>" alt="<?php echo e($item->name); ?>" class="w-full h-48 object-cover rounded-lg border-2 border-ra-gold mb-4">
            <?php else: ?>
            <div class="w-full h-48 bg-gradient-to-br from-shadow-ink to-papyrus-dark border-2 border-ra-gold rounded-lg mb-4 flex items-center justify-center">
                <span class="text-6xl"><?php echo e($item->type === 'weapon' ? '⚔️' : ($item->type === 'armor' ? '🛡️' : ($item->type === 'potion' ? '🧪' : '🔧'))); ?></span>
            </div>
            <?php endif; ?>
            
            <!-- VIP Badge -->
            <?php if($item->is_vip_only): ?>
            <div class="absolute top-2 right-2 bg-ra-gold text-papyrus-dark text-xs font-bold px-2 py-1 rounded-full">
                👑 VIP
            </div>
            <?php endif; ?>
            
            <!-- Premium Badge -->
            <?php if($item->is_premium): ?>
            <div class="absolute top-2 right-2 bg-nile-turquoise text-papyrus-dark text-xs font-bold px-2 py-1 rounded-full">
                💎 Premium
            </div>
            <?php endif; ?>
            
            <!-- Hover Hieroglyph Animation -->
            <div x-show="hovering" 
                 x-transition
                 class="absolute inset-0 bg-gradient-to-br from-ra-gold/5 to-nile-turquoise/5 rounded-lg pointer-events-none"
                 style="background-image: repeating-linear-gradient(45deg, transparent, transparent 10px, rgba(212, 175, 55, 0.05) 10px, rgba(212, 175, 55, 0.05) 20px);">
            </div>
        </div>

        <div class="relative z-10">
            <h3 class="font-egyptian text-xl text-ra-gold text-shadow-gold mb-2">
                <?php echo e($egyptianNames[$item->name] ?? $item->name); ?>

            </h3>
            <span class="inline-block px-3 py-1 text-xs rounded-full mb-3 border-2
                <?php echo e($item->type === 'weapon' ? 'bg-blood-red/20 border-blood-red text-blood-red' : ''); ?>

                <?php echo e($item->type === 'armor' ? 'bg-nile-turquoise/20 border-nile-turquoise text-nile-turquoise' : ''); ?>

                <?php echo e($item->type === 'potion' ? 'bg-green-500/20 border-green-500 text-green-300' : ''); ?>

                <?php echo e($item->type === 'tool' ? 'bg-purple-500/20 border-purple-500 text-purple-300' : ''); ?>">
                <?php echo e(ucfirst($item->type)); ?>

            </span>

            <div class="text-sm space-y-2 mb-4 text-desert-sand">
                <?php if($item->attack > 0): ?>
                <div class="flex items-center gap-2">
                    <span>⚔️</span>
                    <span>Strength: <span class="font-stat text-blood-red">+<?php echo e($item->attack); ?></span></span>
                </div>
                <?php endif; ?>
                <?php if($item->defense > 0): ?>
                <div class="flex items-center gap-2">
                    <span>🛡️</span>
                    <span>Resilience: <span class="font-stat text-nile-turquoise">+<?php echo e($item->defense); ?></span></span>
                </div>
                <?php endif; ?>
                <?php if($item->magic > 0): ?>
                <div class="flex items-center gap-2">
                    <span>✨</span>
                    <span>Wisdom: <span class="font-stat text-purple-300">+<?php echo e($item->magic); ?></span></span>
                </div>
                <?php endif; ?>
                <?php if($item->stamina > 0): ?>
                <div class="flex items-center gap-2">
                    <span>❤️</span>
                    <span>Endurance: <span class="font-stat text-pink-300">+<?php echo e($item->stamina); ?></span></span>
                </div>
                <?php endif; ?>
            </div>

            <div class="flex justify-between items-center mb-4 p-2 bg-papyrus-dark/50 rounded border border-ra-gold/30">
                <?php if($item->is_premium && $item->premium_coins_cost): ?>
                    <span class="font-stat text-nile-turquoise text-lg">💎 <?php echo e(number_format($item->premium_coins_cost)); ?></span>
                <?php else: ?>
                    <span class="font-stat text-ra-gold text-lg">💰 <?php echo e(number_format($item->cost)); ?></span>
                <?php endif; ?>
                <span class="text-xs text-desert-sand">Rank <?php echo e($item->required_level); ?>+</span>
            </div>

            <?php if(in_array($item->id, $ownedItemIds)): ?>
            <button disabled class="w-full bg-shadow-ink border-2 border-ra-gold/30 text-desert-sand/50 font-bold py-3 px-4 rounded-lg cursor-not-allowed">
                Already Blessed
            </button>
            <?php elseif($item->is_vip_only && !$isVip): ?>
            <button disabled class="w-full bg-shadow-ink border-2 border-blood-red/30 text-blood-red/50 font-bold py-3 px-4 rounded-lg cursor-not-allowed">
                VIP Required
            </button>
            <?php elseif($user->level < $item->required_level): ?>
            <button disabled class="w-full bg-shadow-ink border-2 border-blood-red/30 text-blood-red/50 font-bold py-3 px-4 rounded-lg cursor-not-allowed">
                Rank <?php echo e($item->required_level); ?> Required
            </button>
            <?php elseif($item->is_premium && $item->premium_coins_cost && $user->premium_coins < $item->premium_coins_cost): ?>
            <button disabled class="w-full bg-shadow-ink border-2 border-blood-red/30 text-blood-red/50 font-bold py-3 px-4 rounded-lg cursor-not-allowed">
                Insufficient Premium Coins
            </button>
            <?php elseif(!$item->is_premium && $user->gold < $item->cost): ?>
            <button disabled class="w-full bg-shadow-ink border-2 border-blood-red/30 text-blood-red/50 font-bold py-3 px-4 rounded-lg cursor-not-allowed">
                Insufficient Gold
            </button>
            <?php else: ?>
            <form method="POST" action="<?php echo e(route('shop.purchase', $item)); ?>">
                <?php echo csrf_field(); ?>
                <button type="submit" class="w-full cartouche-button hover:scale-105 transition-transform duration-300">
                    Acquire Relic
                </button>
            </form>
            <?php endif; ?>
        </div>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
    <div class="col-span-full quest-card text-center py-12">
        <div class="text-6xl mb-4">🏺</div>
        <p class="text-desert-sand mb-4 font-egyptian">The market is empty, traveler.</p>
    </div>
    <?php endif; ?>
</div>

<?php /**PATH C:\laragon\www\quest-of-ra\resources\views/shop/item-grid.blade.php ENDPATH**/ ?>