<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title>Quest of Ra - <?php echo e(config('app.name', 'Laravel')); ?></title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Cinzel+Decorative:wght@400;700&family=Noto+Serif:wght@400;600;700&family=Orbitron:wght@400;600;700&display=swap" rel="stylesheet">
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Scripts -->
        <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    </head>
    <body class="font-sans antialiased" style="background: linear-gradient(to bottom, #1a0e0a, #2d1b0f);">
        <div class="min-h-screen bg-papyrus-dark relative flex">
            <!-- Hieroglyph Pattern Overlay -->
            <div class="fixed inset-0 opacity-5 pointer-events-none" style="background-image: url('data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTAwIiBoZWlnaHQ9IjEwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48cmVjdCB3aWR0aD0iMTAwIiBoZWlnaHQ9IjEwMCIgZmlsbD0iIzFhMGUwYSIvPjxwYXRoIGQ9Ik0yMCAyMGgxMHYxMEgyMHoiIGZpbGw9IiNkNGFmMzciLz48cGF0aCBkPSJNNzAgNzBoMTB2MTBINzB6IiBmaWxsPSIjZGZhZjM3Ii8+PC9zdmc+'); background-repeat: repeat;"></div>
            
            <?php echo $__env->make('layouts.navigation', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <!-- Main Content Area -->
            <div class="flex-1 flex flex-col min-w-0">
                <!-- Top Bar (for logo and user menu on mobile/desktop) -->
                <header class="bg-gradient-to-r from-papyrus-dark via-shadow-ink to-papyrus-dark border-b-2 border-ra-gold shadow-gold-glow">
                    <div class="px-4 sm:px-6 lg:px-8 py-4">
                        <div class="flex justify-between items-center">
                            <!-- Logo -->
                            <div class="flex items-center gap-3">
                                <a href="<?php echo e(route('dashboard')); ?>" class="flex items-center gap-2">
                                    <span class="text-4xl">👁️</span>
                                    <span class="font-egyptian text-ra-gold text-2xl text-shadow-gold">Quest of Ra</span>
                                </a>
                            </div>

                            <!-- User Menu (Desktop) -->
                            <?php if(auth()->guard()->check()): ?>
                            <div class="hidden lg:flex items-center">
                                <?php if (isset($component)) { $__componentOriginaldf8083d4a852c446488d8d384bbc7cbe = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaldf8083d4a852c446488d8d384bbc7cbe = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dropdown','data' => ['align' => 'right','width' => '48']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dropdown'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['align' => 'right','width' => '48']); ?>
                                     <?php $__env->slot('trigger', null, []); ?> 
                                        <button class="inline-flex items-center px-4 py-2 border-2 border-ra-gold/30 rounded-lg text-sm leading-4 font-medium bg-papyrus-dark text-desert-sand hover:bg-ra-gold/10 hover:border-ra-gold focus:outline-none transition ease-in-out duration-150">
                                            <div class="font-egyptian"><?php echo e(Auth::user()->name); ?></div>
                                            <div class="ms-2">
                                                <svg class="fill-current h-4 w-4 text-ra-gold" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                                                    <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                                                </svg>
                                            </div>
                                        </button>
                                     <?php $__env->endSlot(); ?>

                                     <?php $__env->slot('content', null, []); ?> 
                                        <?php if (isset($component)) { $__componentOriginal68cb1971a2b92c9735f83359058f7108 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal68cb1971a2b92c9735f83359058f7108 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dropdown-link','data' => ['href' => route('profile.edit')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dropdown-link'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['href' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(route('profile.edit'))]); ?>
                                            <?php echo e(__('Profile')); ?>

                                         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal68cb1971a2b92c9735f83359058f7108)): ?>
<?php $attributes = $__attributesOriginal68cb1971a2b92c9735f83359058f7108; ?>
<?php unset($__attributesOriginal68cb1971a2b92c9735f83359058f7108); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal68cb1971a2b92c9735f83359058f7108)): ?>
<?php $component = $__componentOriginal68cb1971a2b92c9735f83359058f7108; ?>
<?php unset($__componentOriginal68cb1971a2b92c9735f83359058f7108); ?>
<?php endif; ?>

                                        <form method="POST" action="<?php echo e(route('logout')); ?>">
                                            <?php echo csrf_field(); ?>
                                            <?php if (isset($component)) { $__componentOriginal68cb1971a2b92c9735f83359058f7108 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal68cb1971a2b92c9735f83359058f7108 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dropdown-link','data' => ['href' => route('logout'),'onclick' => 'event.preventDefault();
                                                                this.closest(\'form\').submit();']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dropdown-link'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['href' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(route('logout')),'onclick' => 'event.preventDefault();
                                                                this.closest(\'form\').submit();']); ?>
                                                <?php echo e(__('Log Out')); ?>

                                             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal68cb1971a2b92c9735f83359058f7108)): ?>
<?php $attributes = $__attributesOriginal68cb1971a2b92c9735f83359058f7108; ?>
<?php unset($__attributesOriginal68cb1971a2b92c9735f83359058f7108); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal68cb1971a2b92c9735f83359058f7108)): ?>
<?php $component = $__componentOriginal68cb1971a2b92c9735f83359058f7108; ?>
<?php unset($__componentOriginal68cb1971a2b92c9735f83359058f7108); ?>
<?php endif; ?>
                                        </form>
                                     <?php $__env->endSlot(); ?>
                                 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaldf8083d4a852c446488d8d384bbc7cbe)): ?>
<?php $attributes = $__attributesOriginaldf8083d4a852c446488d8d384bbc7cbe; ?>
<?php unset($__attributesOriginaldf8083d4a852c446488d8d384bbc7cbe); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaldf8083d4a852c446488d8d384bbc7cbe)): ?>
<?php $component = $__componentOriginaldf8083d4a852c446488d8d384bbc7cbe; ?>
<?php unset($__componentOriginaldf8083d4a852c446488d8d384bbc7cbe); ?>
<?php endif; ?>
                            </div>

                            <!-- Mobile Menu Toggle -->
                            <button x-data 
                                    @click="$dispatch('toggle-sidebar')" 
                                    class="lg:hidden inline-flex items-center justify-center p-3 rounded-lg border-2 border-ra-gold/30 bg-ra-gold/10 text-ra-gold hover:bg-ra-gold/20 hover:border-ra-gold focus:outline-none transition duration-150 ease-in-out shadow-gold-glow">
                                <svg class="h-6 w-6" stroke="currentColor" fill="none" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                                </svg>
                            </button>
                            <?php endif; ?>
                        </div>
                    </div>
                </header>

                <!-- User Stats Bar (always visible) -->
                <?php if (isset($component)) { $__componentOriginale235c3b6fc19052b835328ad32682b27 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale235c3b6fc19052b835328ad32682b27 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.user-stats-bar','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user-stats-bar'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale235c3b6fc19052b835328ad32682b27)): ?>
<?php $attributes = $__attributesOriginale235c3b6fc19052b835328ad32682b27; ?>
<?php unset($__attributesOriginale235c3b6fc19052b835328ad32682b27); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale235c3b6fc19052b835328ad32682b27)): ?>
<?php $component = $__componentOriginale235c3b6fc19052b835328ad32682b27; ?>
<?php unset($__componentOriginale235c3b6fc19052b835328ad32682b27); ?>
<?php endif; ?>

                <!-- Page Heading -->
                <?php if(isset($header)): ?>
                    <div class="bg-gradient-to-r from-papyrus-dark via-shadow-ink to-papyrus-dark border-b-2 border-ra-gold shadow-gold-glow">
                        <div class="px-4 sm:px-6 lg:px-8 py-4">
                            <?php echo e($header); ?>

                        </div>
                    </div>
                <?php endif; ?>

                <!-- Page Content -->
                <main class="relative z-10 flex-1">
                    <?php echo e($slot); ?>

                </main>
            </div>
        </div>
        
        <!-- Character Animation Config -->
        <script>
            window.characterAnimationConfig = {
                states: <?php echo json_encode(config('character_animations.states', []), 512) ?>,
                loopingStates: <?php echo json_encode(config('character_animations.looping_states', []), 512) ?>,
                nonLoopingStates: <?php echo json_encode(config('character_animations.non_looping_states', []), 512) ?>,
                autoReturnStates: <?php echo json_encode(config('character_animations.auto_return_states', []), 512) ?>,
                stayOnLastFrameStates: <?php echo json_encode(config('character_animations.stay_on_last_frame_states', []), 512) ?>,
                defaultState: <?php echo json_encode(config('character_animations.default_state', 'idle'), 512) ?>,
                videoFormats: <?php echo json_encode(config('character_animations.video_formats', ['mp4', 'webm'])) ?>
            };
        </script>
        
        <?php echo $__env->yieldPushContent('scripts'); ?>
    </body>
</html>
<?php /**PATH C:\xampp\htdocs\inkieaskanger\resources\views/layouts/app.blade.php ENDPATH**/ ?>