<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex justify-between items-center">
            <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold flex items-center gap-3">
                <span class="text-4xl">🎬</span>
                <span>Character Animation Test</span>
            </h2>
            <a href="<?php echo e(route('characters.index')); ?>" class="cartouche-button">
                Back to Characters
            </a>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="quest-card mb-6">
                <p class="text-desert-sand mb-4">
                    Test all animation states for each character using PNG sequences.
                </p>
                <div class="grid grid-cols-2 md:grid-cols-3 gap-2 text-sm">
                    <div class="bg-ra-gold/20 border border-ra-gold rounded p-2">
                        <span class="font-bold text-ra-gold">PNG Sequence</span> - Image sequences (01.png, 02.png, ...)
                    </div>
                    <div class="bg-green-600/20 border border-green-600 rounded p-2">
                        <span class="font-bold text-green-400">Available</span> - Animation exists
                    </div>
                    <div class="bg-blood-red/20 border border-blood-red rounded p-2">
                        <span class="font-bold text-blood-red">Missing</span> - No animation found
                    </div>
                </div>
            </div>

            <?php $__currentLoopData = $characters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $charData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $character = $charData['character'];
                    $states = $charData['states'];
                    $pngStates = $states['png'] ?? [];
                    $allCharacterStates = $pngStates;
                    $initialState = !empty($allCharacterStates) ? $allCharacterStates[0] : 'idle';
                ?>

                <div class="quest-card mb-6" 
                     data-character-slug="<?php echo e($character->slug); ?>"
                     data-png-states='<?php echo json_encode($pngStates, 15, 512) ?>'
                     x-data="{
                         selectedState: '<?php echo e($initialState); ?>',
                         characterSlug: $el.dataset.characterSlug,
                         pngStates: JSON.parse($el.dataset.pngStates || '[]'),
                         get hasPng() {
                             return this.pngStates.includes(this.selectedState);
                         },
                         changeState(newState) {
                             this.selectedState = newState;
                             window.dispatchEvent(new CustomEvent('character-animation-state-change', {
                                 detail: {
                                     characterSlug: this.characterSlug,
                                     state: newState
                                 }
                             }));
                         }
                     }"
                     x-init="$watch('selectedState', (newState) => {
                         window.dispatchEvent(new CustomEvent('character-animation-state-change', {
                             detail: {
                                 characterSlug: '<?php echo e($character->slug); ?>',
                                 state: newState
                             }
                         }));
                     })">
                    <!-- Character Header -->
                    <div class="flex items-center justify-between mb-4 pb-4 border-b-2 border-ra-gold/30">
                        <div>
                            <h3 class="font-egyptian text-2xl text-ra-gold mb-1"><?php echo e($character->name); ?></h3>
                            <p class="text-desert-sand text-sm"><?php echo e($character->description ?? 'No description'); ?></p>
                        </div>
                        <div class="text-right">
                            <div class="text-sm text-desert-sand">
                                <span class="text-ra-gold"><?php echo e(count($pngStates)); ?></span> PNG sequences
                            </div>
                        </div>
                    </div>

                    <!-- State Selector -->
                    <div class="mb-4">
                        <label class="block text-desert-sand font-semibold mb-2">Select Animation State:</label>
                        <div class="grid grid-cols-3 md:grid-cols-5 gap-2">
                            <?php $__currentLoopData = $allStates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $hasPng = in_array($state, $pngStates);
                                    $isAvailable = $hasPng;
                                ?>
                                <?php
                                    $buttonClass = $isAvailable 
                                        ? 'bg-papyrus-dark border border-ra-gold/30 hover:bg-papyrus-dark/80' 
                                        : 'bg-shadow-ink border border-blood-red/30 opacity-50';
                                ?>
                                <button 
                                    @click="changeState('<?php echo e($state); ?>')"
                                    :class="selectedState === '<?php echo e($state); ?>' 
                                        ? 'bg-ra-gold text-shadow-ink border-2 border-ra-gold' 
                                        : '<?php echo e($buttonClass); ?>'"
                                    class="px-3 py-2 rounded-lg text-sm font-semibold transition-all text-desert-sand"
                                    :disabled="<?php echo e(!$isAvailable ? 'true' : 'false'); ?>">
                                    <div class="flex items-center justify-center gap-1">
                                        <?php if($hasPng): ?>
                                            <span class="text-ra-gold" title="Has PNG sequence">📸</span>
                                        <?php endif; ?>
                                        <span class="text-xs"><?php echo e(str_replace('_', ' ', $state)); ?></span>
                                    </div>
                                </button>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <!-- Animation Display -->
                    <div class="bg-papyrus-dark/50 rounded-lg p-6 border-2 border-ra-gold/30">
                        <div class="text-center mb-4">
                            <div class="inline-flex items-center gap-2 px-4 py-2 bg-papyrus-dark rounded-lg">
                                <span class="text-desert-sand font-semibold">Current State:</span>
                                <span class="text-ra-gold font-egyptian text-lg" x-text="selectedState.replace('_', ' ')"></span>
                                <span x-show="hasPng" class="text-ra-gold" title="PNG sequence available">📸</span>
                            </div>
                        </div>

                        <!-- Animation Container -->
                        <div class="flex justify-center">
                            <div class="w-full max-w-md">
                                <?php if (isset($component)) { $__componentOriginala07a35e3652b0e27c6b884e53e6e34e4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginala07a35e3652b0e27c6b884e53e6e34e4 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.character-animation','data' => ['character' => $character,'state' => !empty($allCharacterStates) ? $allCharacterStates[0] : 'idle','class' => 'w-full rounded-lg border-4 border-ra-gold shadow-gold-glow','autoplay' => true,'xRef' => 'characterAnimation']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('character-animation'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['character' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($character),'state' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(!empty($allCharacterStates) ? $allCharacterStates[0] : 'idle'),'class' => 'w-full rounded-lg border-4 border-ra-gold shadow-gold-glow','autoplay' => true,'x-ref' => 'characterAnimation']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginala07a35e3652b0e27c6b884e53e6e34e4)): ?>
<?php $attributes = $__attributesOriginala07a35e3652b0e27c6b884e53e6e34e4; ?>
<?php unset($__attributesOriginala07a35e3652b0e27c6b884e53e6e34e4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginala07a35e3652b0e27c6b884e53e6e34e4)): ?>
<?php $component = $__componentOriginala07a35e3652b0e27c6b884e53e6e34e4; ?>
<?php unset($__componentOriginala07a35e3652b0e27c6b884e53e6e34e4); ?>
<?php endif; ?>
                            </div>
                        </div>

                        <!-- State Info -->
                        <div class="mt-4">
                            <div class="bg-papyrus-dark/50 rounded p-3 border border-ra-gold/20">
                                <div class="font-semibold text-desert-sand mb-1">PNG Sequence:</div>
                                <div x-show="hasPng" class="text-ra-gold">
                                    <div>✓ Folder: <span x-text="'/assets/characters/' + characterSlug + '/' + (selectedState === 'attack' ? 'fight' : selectedState)"></span></div>
                                    <div class="text-xs mt-1">(01.png, 02.png, 03.png, ...)</div>
                                </div>
                                <div x-show="!hasPng" class="text-blood-red">
                                    ✗ No PNG sequence found
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- All States Summary -->
                    <div class="mt-4 p-4 bg-papyrus-dark/30 rounded-lg">
                        <h4 class="font-egyptian text-lg text-ra-gold mb-2">Available States Summary:</h4>
                        <div class="grid grid-cols-2 md:grid-cols-4 gap-2 text-xs">
                            <?php $__currentLoopData = $allStates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $hasPng = in_array($state, $pngStates);
                                ?>
                                <div class="flex items-center gap-1 p-2 rounded <?php echo e($hasPng ? 'bg-green-900/20 border border-green-600/30' : 'bg-red-900/20 border border-red-600/30'); ?>">
                                    <?php if($hasPng): ?>
                                        <span class="text-ra-gold">📸</span>
                                    <?php endif; ?>
                                    <span class="text-desert-sand"><?php echo e(str_replace('_', ' ', $state)); ?></span>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <?php if($characters->isEmpty()): ?>
                <div class="quest-card text-center">
                    <p class="text-desert-sand text-xl">No characters found.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>

<?php /**PATH C:\laragon\www\quest-of-ra\resources\views/characters/test-animations.blade.php ENDPATH**/ ?>