<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['scroll', 'viewMode' => 'cards', 'isExpanded' => true]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['scroll', 'viewMode' => 'cards', 'isExpanded' => true]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<?php
    // Use category properties for scroll display
    $scrollColor = $scroll->color ?? '#d4a65a';
    $scrollIcon = $scroll->icon ?? '📜';
    $scrollTitle = $scroll->name ?? $scroll->title ?? 'Unnamed Scroll';
    $scrollDescription = $scroll->description ?? null;
?>

<div class="scroll-category mb-6" x-data="{ expanded: <?php echo e($isExpanded ? 'true' : 'false'); ?> }">
    <!-- Scroll Header - Papyrus Style -->
    <div class="scroll-header bg-[#fdf2d2] border-2 rounded-xl shadow-md p-4 cursor-pointer hover:shadow-lg transition-all duration-300"
         style="border-color: <?php echo e($scrollColor); ?>;"
         @click="expanded = !expanded">
        <div class="flex items-center justify-between">
            <div class="flex items-center gap-4">
                <div class="text-4xl"><?php echo e($scrollIcon); ?></div>
                <div>
                    <h3 class="font-egyptian text-2xl text-ra-gold font-bold" style="color: <?php echo e($scrollColor); ?>;">
                        <?php echo e($scrollTitle); ?>

                    </h3>
                    <?php if($scrollDescription): ?>
                        <p class="text-desert-sand/70 text-sm mt-1"><?php echo e($scrollDescription); ?></p>
                    <?php endif; ?>
                </div>
            </div>
            <div class="flex items-center gap-4">
                <?php if(isset($scroll->tasks) && $scroll->tasks->count() > 0): ?>
                    <span class="px-3 py-1 rounded-full bg-papyrus-dark/50 text-desert-sand text-sm font-semibold border" style="border-color: <?php echo e($scrollColor); ?>;">
                        <?php echo e($scroll->tasks->count()); ?> <?php echo e(Str::plural('Quest', $scroll->tasks->count())); ?>

                    </span>
                <?php endif; ?>
                <?php if(isset($scroll->completed_count) && $scroll->completed_count > 0): ?>
                    <a href="<?php echo e(route('tasks.completed', ['scroll' => $scroll->id])); ?>" class="px-3 py-1 rounded-full bg-green-900/30 text-green-300 text-sm font-semibold border border-green-500 hover:bg-green-900/50 transition-colors">
                        ✅ <?php echo e($scroll->completed_count); ?> Completed
                    </a>
                <?php endif; ?>
                <button class="text-2xl transition-transform duration-300" :class="{ 'rotate-180': expanded }">
                    ▼
                </button>
            </div>
        </div>
    </div>

    <!-- Scroll Content -->
    <div x-show="expanded" 
         x-transition:enter="transition ease-out duration-300"
         x-transition:enter-start="opacity-0 transform -translate-y-4"
         x-transition:enter-end="opacity-100 transform translate-y-0"
         x-transition:leave="transition ease-in duration-200"
         x-transition:leave-start="opacity-100"
         x-transition:leave-end="opacity-0"
         class="scroll-content mt-4">
        <div class="bg-papyrus-dark/30 rounded-lg p-6 border-2" style="border-color: <?php echo e($scrollColor); ?>;">
            <?php if(isset($scroll->tasks) && $scroll->tasks->count() > 0): ?>
                <?php switch($viewMode):
                    case ('cards'): ?>
                        <?php if (isset($component)) { $__componentOriginal30dcade6a8bde148637410778c629f8b = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal30dcade6a8bde148637410778c629f8b = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.quests.views.cards','data' => ['tasks' => $scroll->tasks,'scrollColor' => $scrollColor]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('quests.views.cards'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['tasks' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($scroll->tasks),'scrollColor' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($scrollColor)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal30dcade6a8bde148637410778c629f8b)): ?>
<?php $attributes = $__attributesOriginal30dcade6a8bde148637410778c629f8b; ?>
<?php unset($__attributesOriginal30dcade6a8bde148637410778c629f8b); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal30dcade6a8bde148637410778c629f8b)): ?>
<?php $component = $__componentOriginal30dcade6a8bde148637410778c629f8b; ?>
<?php unset($__componentOriginal30dcade6a8bde148637410778c629f8b); ?>
<?php endif; ?>
                        <?php break; ?>
                    <?php case ('table'): ?>
                        <?php if (isset($component)) { $__componentOriginalea3133ae9e63ca1292dea26e774f18cf = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalea3133ae9e63ca1292dea26e774f18cf = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.quests.views.table','data' => ['tasks' => $scroll->tasks,'scrollColor' => $scrollColor]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('quests.views.table'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['tasks' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($scroll->tasks),'scrollColor' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($scrollColor)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalea3133ae9e63ca1292dea26e774f18cf)): ?>
<?php $attributes = $__attributesOriginalea3133ae9e63ca1292dea26e774f18cf; ?>
<?php unset($__attributesOriginalea3133ae9e63ca1292dea26e774f18cf); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalea3133ae9e63ca1292dea26e774f18cf)): ?>
<?php $component = $__componentOriginalea3133ae9e63ca1292dea26e774f18cf; ?>
<?php unset($__componentOriginalea3133ae9e63ca1292dea26e774f18cf); ?>
<?php endif; ?>
                        <?php break; ?>
                    <?php case ('list'): ?>
                        <?php if (isset($component)) { $__componentOriginalb4388b8ff4e79f6d7d86b90d90c127f2 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalb4388b8ff4e79f6d7d86b90d90c127f2 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.quests.views.list','data' => ['tasks' => $scroll->tasks,'scrollColor' => $scrollColor]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('quests.views.list'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['tasks' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($scroll->tasks),'scrollColor' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($scrollColor)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalb4388b8ff4e79f6d7d86b90d90c127f2)): ?>
<?php $attributes = $__attributesOriginalb4388b8ff4e79f6d7d86b90d90c127f2; ?>
<?php unset($__attributesOriginalb4388b8ff4e79f6d7d86b90d90c127f2); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalb4388b8ff4e79f6d7d86b90d90c127f2)): ?>
<?php $component = $__componentOriginalb4388b8ff4e79f6d7d86b90d90c127f2; ?>
<?php unset($__componentOriginalb4388b8ff4e79f6d7d86b90d90c127f2); ?>
<?php endif; ?>
                        <?php break; ?>
                    <?php case ('compact'): ?>
                        <?php if (isset($component)) { $__componentOriginal7f5558a76d16e83f26becc7d3f2c9056 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal7f5558a76d16e83f26becc7d3f2c9056 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.quests.views.compact','data' => ['tasks' => $scroll->tasks,'scrollColor' => $scrollColor]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('quests.views.compact'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['tasks' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($scroll->tasks),'scrollColor' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($scrollColor)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal7f5558a76d16e83f26becc7d3f2c9056)): ?>
<?php $attributes = $__attributesOriginal7f5558a76d16e83f26becc7d3f2c9056; ?>
<?php unset($__attributesOriginal7f5558a76d16e83f26becc7d3f2c9056); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal7f5558a76d16e83f26becc7d3f2c9056)): ?>
<?php $component = $__componentOriginal7f5558a76d16e83f26becc7d3f2c9056; ?>
<?php unset($__componentOriginal7f5558a76d16e83f26becc7d3f2c9056); ?>
<?php endif; ?>
                        <?php break; ?>
                    <?php case ('kanban'): ?>
                        <?php if (isset($component)) { $__componentOriginal3f505585ae225c1dfdbe9f7ca60429a7 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3f505585ae225c1dfdbe9f7ca60429a7 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.quests.views.kanban','data' => ['tasks' => $scroll->tasks,'scrollColor' => $scrollColor]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('quests.views.kanban'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['tasks' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($scroll->tasks),'scrollColor' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($scrollColor)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3f505585ae225c1dfdbe9f7ca60429a7)): ?>
<?php $attributes = $__attributesOriginal3f505585ae225c1dfdbe9f7ca60429a7; ?>
<?php unset($__attributesOriginal3f505585ae225c1dfdbe9f7ca60429a7); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3f505585ae225c1dfdbe9f7ca60429a7)): ?>
<?php $component = $__componentOriginal3f505585ae225c1dfdbe9f7ca60429a7; ?>
<?php unset($__componentOriginal3f505585ae225c1dfdbe9f7ca60429a7); ?>
<?php endif; ?>
                        <?php break; ?>
                    <?php default: ?>
                        <?php if (isset($component)) { $__componentOriginal30dcade6a8bde148637410778c629f8b = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal30dcade6a8bde148637410778c629f8b = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.quests.views.cards','data' => ['tasks' => $scroll->tasks,'scrollColor' => $scrollColor]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('quests.views.cards'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['tasks' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($scroll->tasks),'scrollColor' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($scrollColor)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal30dcade6a8bde148637410778c629f8b)): ?>
<?php $attributes = $__attributesOriginal30dcade6a8bde148637410778c629f8b; ?>
<?php unset($__attributesOriginal30dcade6a8bde148637410778c629f8b); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal30dcade6a8bde148637410778c629f8b)): ?>
<?php $component = $__componentOriginal30dcade6a8bde148637410778c629f8b; ?>
<?php unset($__componentOriginal30dcade6a8bde148637410778c629f8b); ?>
<?php endif; ?>
                <?php endswitch; ?>
            <?php else: ?>
                <div class="text-center py-12">
                    <div class="text-6xl mb-4 opacity-50">📜</div>
                    <p class="text-desert-sand/70 font-egyptian">No quests in this scroll yet.</p>
                    <a href="<?php echo e(route('tasks.create')); ?>" class="inline-block mt-4 cartouche-button">
                        Create Your First Quest
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php /**PATH C:\xampp\htdocs\inkieaskanger\resources\views/components/quests/scroll-category.blade.php ENDPATH**/ ?>