<?php
use Illuminate\Support\Facades\Storage;
?>
<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex justify-between items-center">
            <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold">
                <?php echo e(__('Mob Management')); ?>

            </h2>
            <div class="flex gap-2">
                <a href="<?php echo e(route('admin.mobs.create')); ?>" class="cartouche-button bg-gradient-to-r from-blood-red to-red-700">
                    New Mob
                </a>
                <a href="<?php echo e(route('admin.dashboard')); ?>" class="cartouche-button">
                    Back
                </a>
            </div>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <?php if(session('success')): ?>
                <div class="quest-card bg-gradient-to-r from-nile-turquoise/20 to-green-500/20 border-nile-turquoise mb-6">
                    <span class="block text-desert-sand font-egyptian"><?php echo e(session('success')); ?></span>
                </div>
            <?php endif; ?>

            <div class="quest-card">
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-ra-gold/30">
                        <thead>
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Image</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Name</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Level</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Stats</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">HP</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Rarity</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Rewards</th>
                                <th class="px-6 py-3 text-left text-xs font-egyptian text-ra-gold uppercase">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-ra-gold/20">
                            <?php $__empty_1 = true; $__currentLoopData = $mobs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mob): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="hover:bg-papyrus-dark/50 transition-colors">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <?php if($mob->image_normal): ?>
                                        <img src="<?php echo e(Storage::url($mob->image_normal)); ?>" alt="<?php echo e($mob->name); ?>" class="w-16 h-16 object-cover rounded border border-ra-gold/30">
                                    <?php else: ?>
                                        <div class="w-16 h-16 bg-papyrus-dark border border-ra-gold/30 rounded flex items-center justify-center text-2xl">👹</div>
                                    <?php endif; ?>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-desert-sand font-egyptian"><?php echo e($mob->name); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-nile-turquoise font-stat"><?php echo e($mob->level); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-desert-sand">
                                    ⚔️ <?php echo e($mob->attack); ?> 🛡️ <?php echo e($mob->defense); ?><br>
                                    <span class="text-xs">⚡ <?php echo e($mob->speed); ?> 🍀 <?php echo e($mob->luck); ?></span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-blood-red font-stat"><?php echo e($mob->hp); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="px-2 py-1 text-xs rounded border
                                        <?php if($mob->rarity === 'legendary'): ?> border-yellow-400 text-yellow-400
                                        <?php elseif($mob->rarity === 'epic'): ?> border-purple-400 text-purple-400
                                        <?php elseif($mob->rarity === 'rare'): ?> border-blue-400 text-blue-400
                                        <?php else: ?> border-gray-400 text-gray-400
                                        <?php endif; ?>">
                                        <?php echo e(ucfirst($mob->rarity)); ?>

                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-desert-sand">
                                    XP: <span class="text-nile-turquoise"><?php echo e($mob->xp_reward); ?></span><br>
                                    Gold: <span class="text-ra-gold"><?php echo e($mob->gold_reward); ?></span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="flex gap-2">
                                        <a href="<?php echo e(route('admin.mobs.edit', $mob)); ?>" class="text-nile-turquoise hover:text-teal-300 text-sm transition-colors">Edit</a>
                                        <form method="POST" action="<?php echo e(route('admin.mobs.destroy', $mob)); ?>" class="inline" 
                                            onsubmit="return confirm('Delete this mob?')">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="text-blood-red hover:text-red-400 text-sm transition-colors">Delete</button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="8" class="px-6 py-4 text-center text-desert-sand">No mobs found.</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>

                    <div class="mt-4">
                        <?php echo e($mobs->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\laragon\www\quest-of-ra\resources\views/admin/mobs/index.blade.php ENDPATH**/ ?>