<?php
use Illuminate\Support\Facades\Storage;
?>
<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <div x-data="egyptianAnimations()"></div>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex items-center gap-3">
            <span class="text-4xl">🏺</span>
            <h2 class="font-egyptian text-3xl text-ra-gold text-shadow-gold leading-tight">
                Temple of Tasks
            </h2>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <!-- Three Column Layout -->
            <div class="grid grid-cols-1 lg:grid-cols-12 gap-6">
                
                <!-- Main Content - Scroll Parchment -->
                <div class="lg:col-span-8 space-y-6">
                    <?php if(session('success')): ?>
                        <div class="quest-card bg-gradient-to-r from-ra-gold/20 to-nile-turquoise/20 border-nile-turquoise" role="alert">
                            <span class="block text-desert-sand font-egyptian"><?php echo e(session('success')); ?></span>
                            <?php if(session('level_up')): ?>
                            <div class="mt-2 text-ra-gold font-egyptian animate-gold-pulse" 
                                 x-data 
                                 x-init="setTimeout(() => window.dispatchEvent(new CustomEvent('level-up')), 500)">
                                👁️ Ra has blessed you — Level Up to <?php echo e(session('new_level')); ?>!
                            </div>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>

                    <!-- User Stats Card - Parchment Scroll -->
                    <div class="quest-card">
                        <div class="flex items-center justify-between mb-4">
                            <div class="flex items-center gap-4">
                                <?php if($user->character): ?>
                                    <div class="w-16 h-16">
                                        <?php if (isset($component)) { $__componentOriginala07a35e3652b0e27c6b884e53e6e34e4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginala07a35e3652b0e27c6b884e53e6e34e4 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.character-animation','data' => ['character' => $user->character,'state' => 'idle','class' => 'w-16 h-16 rounded-lg border-2 border-ra-gold']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('character-animation'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['character' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($user->character),'state' => 'idle','class' => 'w-16 h-16 rounded-lg border-2 border-ra-gold']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginala07a35e3652b0e27c6b884e53e6e34e4)): ?>
<?php $attributes = $__attributesOriginala07a35e3652b0e27c6b884e53e6e34e4; ?>
<?php unset($__attributesOriginala07a35e3652b0e27c6b884e53e6e34e4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginala07a35e3652b0e27c6b884e53e6e34e4)): ?>
<?php $component = $__componentOriginala07a35e3652b0e27c6b884e53e6e34e4; ?>
<?php unset($__componentOriginala07a35e3652b0e27c6b884e53e6e34e4); ?>
<?php endif; ?>
                                    </div>
                                    <h3 class="font-egyptian text-2xl text-ra-gold text-shadow-gold"><?php echo e($user->name); ?></h3>
                                    <span class="text-sm text-desert-sand">(<?php echo e($user->character->name); ?>)</span>
                                <?php else: ?>
                                    <h3 class="font-egyptian text-2xl text-ra-gold text-shadow-gold"><?php echo e($user->name); ?></h3>
                                <?php endif; ?>
                            </div>
                            <div class="text-center px-4 py-2 bg-ra-gold/20 border border-ra-gold rounded-lg">
                                <span class="font-stat text-2xl text-ra-gold">Rank <?php echo e($user->level); ?></span>
                            </div>
                        </div>
                        
                        <!-- XP Progress Bar - Sun Ray Shape -->
                        <div class="mb-6">
                            <div class="flex justify-between text-sm text-desert-sand mb-2">
                                <span>✨ Divine Energy: <?php echo e($xpInCurrentLevel); ?> / <?php echo e($xpNeededForNextLevel); ?></span>
                                <span class="text-ra-gold">Next Rank: <?php echo e($user->level + 1); ?></span>
                            </div>
                            <div class="relative w-full bg-shadow-ink rounded-full h-6 border-2 border-ra-gold/30 overflow-hidden">
                                <div class="h-full bg-gradient-to-r from-ra-gold via-yellow-400 to-ra-gold rounded-full transition-all duration-500 flex items-center justify-center shadow-gold-glow" 
                                     style="width: <?php echo e(min(100, max(0, $xpProgress))); ?>%; clip-path: polygon(0 0, 100% 0, calc(100% - 8px) 50%, 100% 100%, 0 100%);">
                                    <?php if($xpProgress > 10): ?>
                                    <span class="text-xs font-stat text-papyrus-dark font-bold"><?php echo e(round($xpProgress)); ?>%</span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <!-- Sacred Gold and Stats -->
                        <div class="grid grid-cols-2 md:grid-cols-5 gap-4">
                            <div class="text-center p-4 bg-ra-gold/10 border border-ra-gold rounded-lg">
                                <div class="text-3xl mb-1">💰</div>
                                <div class="font-stat text-2xl text-ra-gold"><?php echo e(number_format($user->gold)); ?></div>
                                <div class="text-xs text-desert-sand">Sacred Gold</div>
                            </div>
                            <div class="text-center p-4 bg-nile-turquoise/10 border border-nile-turquoise rounded-lg">
                                <div class="text-3xl mb-1">💎</div>
                                <div class="font-stat text-2xl text-nile-turquoise"><?php echo e(number_format($user->premium_coins)); ?></div>
                                <div class="text-xs text-desert-sand">Premium Coins</div>
                            </div>
                            <div class="text-center p-4 bg-blood-red/10 border border-blood-red/50 rounded-lg">
                                <div class="text-3xl mb-1">⚔️</div>
                                <div class="font-stat text-2xl text-blood-red"><?php echo e($totalStats['attack']); ?></div>
                                <div class="text-xs text-desert-sand">Strength</div>
                            </div>
                            <div class="text-center p-4 bg-nile-turquoise/10 border border-nile-turquoise/50 rounded-lg">
                                <div class="text-3xl mb-1">🛡️</div>
                                <div class="font-stat text-2xl text-nile-turquoise"><?php echo e($totalStats['defense']); ?></div>
                                <div class="text-xs text-desert-sand">Resilience</div>
                            </div>
                            <div class="text-center p-4 bg-purple-600/20 border border-purple-400/50 rounded-lg">
                                <div class="text-3xl mb-1">❤️</div>
                                <div class="font-stat text-2xl text-purple-300"><?php echo e($totalStats['stamina']); ?></div>
                                <div class="text-xs text-desert-sand">Endurance</div>
                            </div>
                        </div>
                    </div>

                    <!-- Quick Actions -->
                    <div class="quest-card">
                        <h3 class="font-egyptian text-xl text-ra-gold mb-4">Quick Actions</h3>
                        <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                            <a href="<?php echo e(route('tasks.create')); ?>" class="bg-nile-turquoise/20 hover:bg-nile-turquoise/30 border-2 border-nile-turquoise text-nile-turquoise font-bold py-3 px-4 rounded-lg text-center transition-all duration-300 hover:shadow-turquoise-glow">
                                🗺️ New Quest
                            </a>
                            <a href="<?php echo e(route('categories.create')); ?>" class="bg-ra-gold/20 hover:bg-ra-gold/30 border-2 border-ra-gold text-ra-gold font-bold py-3 px-4 rounded-lg text-center transition-all duration-300 hover:shadow-gold-glow">
                                📜 New Scroll
                            </a>
                            <a href="<?php echo e(route('shop.index')); ?>" class="bg-yellow-600/20 hover:bg-yellow-600/30 border-2 border-yellow-600 text-yellow-400 font-bold py-3 px-4 rounded-lg text-center transition-all duration-300">
                                💰 Market
                            </a>
                            <a href="<?php echo e(route('battle.index')); ?>" class="bg-blood-red/20 hover:bg-blood-red/30 border-2 border-blood-red text-blood-red font-bold py-3 px-4 rounded-lg text-center transition-all duration-300">
                                ⚔️ Arena
                            </a>
                        </div>
                    </div>

                    <!-- Recent Completed Quests -->
                    <?php if($recentTasks->count() > 0): ?>
                    <div class="quest-card">
                        <h3 class="font-egyptian text-xl text-ra-gold mb-4">Recent Blessings</h3>
                        <div class="space-y-2">
                            <?php $__currentLoopData = $recentTasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="flex justify-between items-center p-3 bg-papyrus-dark/50 rounded-lg border border-ra-gold/20 hover:border-ra-gold transition-all duration-300">
                                <div class="flex items-center gap-3">
                                    <span class="text-2xl">✨</span>
                                <span class="text-desert-sand"><?php echo e($task->title); ?></span>
                                </div>
                                <span class="text-sm text-nile-turquoise"><?php echo e($task->completed_at->diffForHumans()); ?></span>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>

                <!-- Right Sidebar - Power of Ra Panel -->
                <div class="lg:col-span-4 space-y-6">
                    <!-- Power of Ra Card -->
                    <div class="quest-card border-nile-turquoise">
                        <h3 class="font-egyptian text-xl text-nile-turquoise text-shadow-turquoise mb-4 flex items-center gap-2">
                            <span class="text-3xl">👁️</span>
                            <span>Power of Ra</span>
                        </h3>
                        
                        <div class="space-y-4">
                            <!-- Level Display -->
                            <div class="text-center p-4 bg-gradient-to-br from-ra-gold/20 to-yellow-600/20 border-2 border-ra-gold rounded-lg">
                                <div class="font-stat text-4xl text-ra-gold mb-1"><?php echo e($user->level); ?></div>
                                <div class="text-xs text-desert-sand">Rank</div>
                            </div>

                            <!-- Gold Display -->
                            <div class="p-3 bg-ra-gold/10 border border-ra-gold rounded-lg flex items-center justify-between">
                                <span class="text-desert-sand">Sacred Gold:</span>
                                <span class="font-stat text-ra-gold"><?php echo e(number_format($user->gold)); ?></span>
                            </div>

                            <!-- Premium Coins Display -->
                            <div class="p-3 bg-nile-turquoise/10 border border-nile-turquoise rounded-lg flex items-center justify-between">
                                <span class="text-desert-sand">💎 Premium Coins:</span>
                                <span class="font-stat text-nile-turquoise"><?php echo e(number_format($user->premium_coins)); ?></span>
                            </div>

                            <!-- VIP Status Panel -->
                            <?php if($user->isVip()): ?>
                                <?php
                                    $membership = $user->membership;
                                    $daysUntilExpiry = now()->diffInDays($user->vip_expires_at, false);
                                ?>
                                <div class="p-4 bg-gradient-to-br from-ra-gold/30 to-yellow-600/20 border-2 border-ra-gold rounded-lg">
                                    <div class="flex items-center justify-between mb-2">
                                        <span class="font-egyptian text-ra-gold text-lg">👑 VIP Status</span>
                                        <span class="bg-ra-gold text-papyrus-dark text-xs font-bold px-2 py-1 rounded-full">ACTIVE</span>
                                    </div>
                                    <?php if($membership): ?>
                                        <div class="text-xs text-desert-sand mb-2">
                                            <div><?php echo e($membership->name); ?></div>
                                            <div class="mt-1">
                                                <span class="text-nile-turquoise">+<?php echo e($membership->xp_bonus_percent); ?>% XP</span> | 
                                                <span class="text-nile-turquoise">+<?php echo e($membership->gold_bonus_percent); ?>% Gold</span>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    <?php if($user->vip_expires_at): ?>
                                        <div class="text-xs text-desert-sand">
                                            Expires: <?php echo e($user->vip_expires_at->format('M d, Y')); ?>

                                            <?php if($daysUntilExpiry <= 7 && $daysUntilExpiry >= 0): ?>
                                                <span class="text-blood-red block mt-1">⚠️ <?php echo e($daysUntilExpiry); ?> day<?php echo e($daysUntilExpiry !== 1 ? 's' : ''); ?> remaining</span>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>
                                    <?php
                                        $canClaimDaily = !$user->last_vip_reward_claimed_at || !$user->last_vip_reward_claimed_at->isToday();
                                    ?>
                                    <?php if($canClaimDaily): ?>
                                        <form method="POST" action="<?php echo e(route('rewards.daily-vip')); ?>" class="mt-3">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="w-full cartouche-button text-sm py-2">
                                                🎁 Claim Daily Blessing
                                            </button>
                                        </form>
                                    <?php else: ?>
                                        <div class="mt-3 text-xs text-desert-sand/70 text-center">
                                            Daily blessing already claimed today
                                        </div>
                                    <?php endif; ?>
                                </div>
                            <?php else: ?>
                                <div class="p-4 bg-papyrus-dark/50 border border-ra-gold/30 rounded-lg text-center space-y-2">
                                    <div class="text-desert-sand text-sm mb-2">Become VIP for exclusive benefits!</div>
                                    <a href="<?php echo e(route('membership.plans')); ?>" class="cartouche-button text-sm py-2 inline-block w-full">
                                        👑 Upgrade to VIP (PayPal)
                                    </a>
                                </div>
                            <?php endif; ?>

                            <!-- Buy Premium Coins Button -->
                            <div class="p-4 bg-nile-turquoise/10 border border-nile-turquoise rounded-lg text-center">
                                <a href="<?php echo e(route('coins.index')); ?>" class="cartouche-button text-sm py-2 inline-block w-full">
                                    💎 Buy Premium Coins (PayPal)
                                </a>
                            </div>

                            <!-- Equipped Items - Floating Relics -->
                            <div>
                                <h4 class="text-desert-sand mb-2 text-sm font-semibold">Blessed Relics</h4>
                                <?php
                                    $equippedItems = $user->userItems()->where('equipped', true)->with('item')->get();
                                ?>
                                <?php if($equippedItems->count() > 0): ?>
                                <div class="space-y-2">
                                    <?php $__currentLoopData = $equippedItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $userItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="flex items-center gap-2 p-2 bg-papyrus-dark/50 border border-ra-gold/30 rounded">
                                        <span class="text-xl"><?php echo e($userItem->item->type === 'weapon' ? '⚔️' : ($userItem->item->type === 'armor' ? '🛡️' : ($userItem->item->type === 'potion' ? '🧪' : '🔧'))); ?></span>
                                        <span class="text-xs text-desert-sand"><?php echo e($userItem->item->name); ?></span>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                <?php else: ?>
                                <p class="text-xs text-desert-sand/70 italic">No relics equipped</p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <!-- Blessings Meter - Daily Quest Streak -->
                    <div class="quest-card border-nile-turquoise">
                        <h3 class="font-egyptian text-lg text-nile-turquoise text-shadow-turquoise mb-4 flex items-center gap-2">
                            <span class="text-2xl">👁️</span>
                            <span>Blessings of Ra</span>
                        </h3>
                        
                        <div class="text-center mb-4">
                            <div class="font-stat text-4xl text-ra-gold mb-1"><?php echo e($streakData['streak']); ?></div>
                            <div class="text-xs text-desert-sand">Day Streak</div>
                        </div>
                        
                        <?php if($streakData['bonus_percent'] > 0): ?>
                        <div class="bg-gradient-to-r from-ra-gold/20 to-yellow-600/20 border-2 border-ra-gold rounded-lg p-3 mb-3">
                            <div class="flex justify-between items-center">
                                <span class="text-desert-sand text-sm font-semibold">Blessing Bonus:</span>
                                <span class="font-stat text-ra-gold text-lg">+<?php echo e($streakData['bonus_percent']); ?>%</span>
                            </div>
                            <div class="text-xs text-desert-sand/70 mt-1">
                                All daily quest rewards increased!
                            </div>
                        </div>
                        <?php else: ?>
                        <div class="bg-papyrus-dark/50 border border-ra-gold/30 rounded-lg p-3 mb-3 text-center">
                            <div class="text-xs text-desert-sand/70">
                                Complete a daily quest to start your streak!
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <!-- Visual Streak Indicator -->
                        <div class="mt-4">
                            <div class="flex gap-1 justify-center">
                                <?php for($i = 0; $i < min(7, $streakData['streak']); $i++): ?>
                                <div class="w-2 h-8 bg-gradient-to-t from-ra-gold to-yellow-400 rounded border border-ra-gold shadow-gold-glow"></div>
                                <?php endfor; ?>
                                <?php for($i = min(7, $streakData['streak']); $i < 7; $i++): ?>
                                <div class="w-2 h-8 bg-shadow-ink border border-ra-gold/20 rounded"></div>
                                <?php endfor; ?>
                            </div>
                            <div class="text-xs text-desert-sand/70 text-center mt-2">
                                <?php if($streakData['streak'] >= 7): ?>
                                <span class="text-ra-gold font-semibold">Maximum Blessing!</span>
                                <?php else: ?>
                                <?php echo e(7 - min(7, $streakData['streak'])); ?> more days for full blessing
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <!-- Daily Stats -->
                    <div class="quest-card">
                        <h3 class="font-egyptian text-lg text-ra-gold mb-4">Today's Progress</h3>
                        <div class="space-y-3">
                            <div class="flex justify-between items-center p-2 bg-green-900/20 border border-green-500/30 rounded">
                                <span class="text-desert-sand text-sm">Today</span>
                                <span class="font-stat text-green-400"><?php echo e($tasksCompletedToday); ?></span>
                            </div>
                            <div class="flex justify-between items-center p-2 bg-blue-900/20 border border-blue-500/30 rounded">
                                <span class="text-desert-sand text-sm">This Week</span>
                                <span class="font-stat text-blue-400"><?php echo e($tasksCompletedThisWeek); ?></span>
                            </div>
                            <div class="flex justify-between items-center p-2 bg-purple-900/20 border border-purple-500/30 rounded">
                                <span class="text-desert-sand text-sm">This Month</span>
                                <span class="font-stat text-purple-400"><?php echo e($tasksCompletedThisMonth); ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Achievements -->
            <?php if($achievements->count() > 0): ?>
            <div class="quest-card mt-6">
                <h3 class="font-egyptian text-2xl text-ra-gold mb-6 text-center">Blessings of the Gods</h3>
                <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                    <?php $__currentLoopData = $achievements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $achievement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="text-center p-4 bg-gradient-to-br from-ra-gold/10 to-yellow-600/10 border-2 border-ra-gold rounded-xl hover:shadow-gold-glow transition-all duration-300">
                        <div class="text-5xl mb-2"><?php echo e($achievement->icon); ?></div>
                        <div class="font-egyptian font-semibold text-ra-gold text-sm mb-1"><?php echo e($achievement->name); ?></div>
                        <div class="text-xs text-desert-sand"><?php echo e($achievement->description); ?></div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <?php endif; ?>

            <!-- Leaderboard -->
            <?php if($leaderboard->count() > 0): ?>
            <div class="quest-card mt-6">
                <h3 class="font-egyptian text-2xl text-ra-gold mb-4 text-center">Champions of Ra</h3>
                <div class="space-y-2">
                    <?php $__currentLoopData = $leaderboard; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $leader): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="flex justify-between items-center p-3 bg-papyrus-dark/50 rounded-lg border border-ra-gold/20 hover:border-ra-gold transition-all duration-300">
                        <div class="flex items-center gap-3">
                            <span class="font-egyptian text-ra-gold w-8">#<?php echo e($index + 1); ?></span>
                            <span class="text-desert-sand"><?php echo e($leader->name); ?></span>
                            <?php if($leader->id === $user->id): ?>
                            <span class="text-xs text-ra-gold">(You)</span>
                            <?php endif; ?>
                        </div>
                        <div class="flex gap-4 text-sm">
                            <span class="font-stat text-nile-turquoise">Rank <?php echo e($leader->level); ?></span>
                            <span class="text-desert-sand"><?php echo e(number_format($leader->xp)); ?> ✨</span>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\laragon\www\quest-of-ra\resources\views/dashboard.blade.php ENDPATH**/ ?>