import defaultTheme from 'tailwindcss/defaultTheme';
import forms from '@tailwindcss/forms';

/** @type {import('tailwindcss').Config} */
export default {
    content: [
        './vendor/laravel/framework/src/Illuminate/Pagination/resources/views/*.blade.php',
        './storage/framework/views/*.php',
        './resources/views/**/*.blade.php',
    ],

    theme: {
        extend: {
            colors: {
                'papyrus-dark': '#1a0e0a',
                'ra-gold': '#d4af37',
                'nile-turquoise': '#0fb9b1',
                'blood-red': '#b33939',
                'desert-sand': '#f5e6b2',
                'shadow-ink': '#100803',
            },
            fontFamily: {
                sans: ['Figtree', 'Noto Serif', ...defaultTheme.fontFamily.serif],
                'egyptian': ['Cinzel Decorative', ...defaultTheme.fontFamily.serif],
                'stat': ['Orbitron', ...defaultTheme.fontFamily.sans],
            },
            boxShadow: {
                'gold-glow': '0 0 20px rgba(212, 175, 55, 0.5)',
                'gold-glow-lg': '0 0 30px rgba(212, 175, 55, 0.7)',
                'turquoise-glow': '0 0 20px rgba(15, 185, 177, 0.5)',
            },
            backgroundImage: {
                'papyrus': 'linear-gradient(to bottom, #1a0e0a, #2d1b0f)',
                'gradient-radial': 'radial-gradient(var(--tw-gradient-stops))',
            },
        },
    },

    plugins: [forms],
};
